/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant;

import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.HeldEquipmentHandler;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.misc.BabylonWeapon;
import io.github.flemmli97.fateubw.common.entity.misc.EnkiduChains;
import io.github.flemmli97.fateubw.common.entity.misc.EnumaElish;
import io.github.flemmli97.fateubw.common.entity.utils.OnProjectileHit;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.TrailParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.ParticlePositionProvider;
import io.github.flemmli97.fateubw.common.registry.FateAttributes;
import io.github.flemmli97.fateubw.common.registry.FateDataComponents;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.LeapInDirection;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.PlayAnimation;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.CirclingData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.utils.math.MathUtils;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.joml.Vector4f;

public class Gilgamesh
extends BaseServant
implements OnProjectileHit {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String ONE_HAND_1 = BUILDER.add("one_hand_1", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.56}));
    public static final String ONE_HAND_2 = BUILDER.add("one_hand_2", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.56}));
    public static final String STAB_1 = BUILDER.add("stab_1", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.6, 0.72}));
    public static final String GUARD = BUILDER.add("guard", AnimationsBuilder.definition((double)0.4));
    public static final String BABYLON_1 = BUILDER.add("babylon_1", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.32}));
    public static final String BABYLON_2 = BUILDER.add("babylon_2", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.32}));
    public static final String BABYLON_3 = BUILDER.add("babylon_3", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.32}));
    public static final String EA = BUILDER.add("ea", AnimationsBuilder.definition((double)3.12).marker("start_attack", new double[]{0.1}).marker("attack", new double[]{1.56}));
    public static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)2.0));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final Vector4f summonColor = new Vector4f(1.0f, 0.85f, 0.3f, 0.7f);
    private final AnimationHandler<Gilgamesh> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    public final HeldEquipmentHandler heldEquipmentHandler = new HeldEquipmentHandler((LivingEntity)this, new ItemStack((ItemLike)FateItems.ENUMAELISH.get()), null);
    private int chainCooldown = 200;
    private int leapCooldown;

    public Gilgamesh(EntityType<? extends Gilgamesh> entityType, Level level) {
        super(entityType, level);
        this.revealServant();
    }

    @Override
    public boolean hasOwnWeapon() {
        return true;
    }

    @Override
    public HeldEquipmentHandler getEquipmentHandler() {
        return this.heldEquipmentHandler;
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{ONE_HAND_1}).play(BehaviourUtils.cooldownedPlay(true, 18, 30)).condition(gil -> !gil.useRanged() && BehaviourUtils.ifCloserThan(4.0).test(gil)).end(7).start(new String[]{ONE_HAND_2}).play(BehaviourUtils.cooldownedPlay(true, 18, 30)).condition(gil -> !gil.useRanged() && BehaviourUtils.ifCloserThan(4.0).test(gil)).end(7).start(new String[]{STAB_1}).play(BehaviourUtils.cooldownedPlay(true, 18, 30)).condition(gil -> !gil.useRanged() && BehaviourUtils.ifCloserThan(4.0).test(gil)).end(7).start(new String[]{BABYLON_1, BABYLON_2, BABYLON_3}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(20.0), (s, entity) -> 30 + entity.getRandom().nextInt(20) - (entity.chainCooldown > 0 ? 15 : 0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(8.0).max(18.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack(15, 30)}).end(33).start(new String[]{BABYLON_1, BABYLON_2, BABYLON_3}).play((PlayAnimation)BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(20.0), (s, entity) -> 30 + entity.getRandom().nextInt(20) - (entity.chainCooldown > 0 ? 15 : 0)).startCondition(gil -> gil.chainCooldown <= 0 && BehaviourUtils.ifCloserThan(16.0).test(gil))).condition(gil -> !gil.useRanged()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(BehaviourUtils.closeEnough(16))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(27).start(new String[]{EA}).play(BehaviourUtils.cooldownedPlay(false, 20, 35)).condition(BaseServant::canUseNobelPhantasm).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(4.0).max(8.0).speedMod(1.1f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(40).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(3, Gilgamesh::useRanged, new ExtendedBehaviour[]{new Idle()}).add(10, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(14.0f)}).add(7, new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().radius(7.0).speedMod(1.1f), BehaviourUtils.moveTo()}).add(2, gil -> gil.leapCooldown < 0 && BehaviourUtils.ifCloserThan(7.0).test(gil), new ExtendedBehaviour[]{new LeapInDirection().horizontalDirection((owner, target) -> LeapInDirection.createBackwardsVec((Vec3)owner.position(), (Vec3)target.position())).whenStarting(e -> {
            e.leapCooldown = 80 + e.getRandom().nextInt(40);
            BehaviourUtils.modifyExpiringMemory((Mob)this, MemoryModuleType.ATTACK_COOLING_DOWN, -15);
        })}).build();
    }

    public void baseTick() {
        super.baseTick();
        if (!this.level().isClientSide) {
            --this.chainCooldown;
            --this.leapCooldown;
            this.heldEquipmentHandler.setInUse(this.getAnimationHandler().isCurrent(new String[]{EA}) || this.healthBelow(0.5f));
        }
    }

    @Override
    public void setupAttack(AnimationDefinition anim) {
        if (this.getAnimationHandler().isCurrent(new String[]{BABYLON_1, BABYLON_2, BABYLON_3})) {
            BrainUtils.clearMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.LOOK_TARGET);
            this.getNavigation().stop();
            return;
        }
        super.setupAttack(anim);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{EA})) {
            if (anim.isAt("start_attack")) {
                this.startUsingItem(InteractionHand.MAIN_HAND);
                this.getMainHandItem().set((DataComponentType)FateDataComponents.GLOWING_ITEM.get(), (Object)Unit.INSTANCE);
            }
            if (!anim.isAt("attack")) {
                this.setTargetPositionFromAttackTarget();
            }
            if (anim.isAt("attack")) {
                this.ea(this.getTargetPosition());
            }
        } else if (anim.is(new String[]{BABYLON_1, BABYLON_2, BABYLON_3})) {
            LivingEntity target = this.getTarget();
            if (!anim.isPast("attack") && target != null) {
                this.getLookControl().setLookAt((Entity)target, 60.0f, 30.0f);
            }
            if (anim.isAt("attack") && target != null) {
                this.attackWithRangedAttack(target);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    protected float getKnockback(Entity attacker, DamageSource damageSource) {
        if (this.getAnimationHandler().isCurrent(new String[]{STAB_1})) {
            return 0.0f;
        }
        return super.getKnockback(attacker, damageSource) + 3.0f;
    }

    public AnimationHandler<Gilgamesh> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double height = this.getBbHeight();
        double width = this.getBbWidth();
        double length = 1.0f * this.getScale();
        if (anim.is(new String[]{ONE_HAND_1})) {
            width += 0.5 * (double)this.getScale();
            length += 0.7 * (double)this.getScale();
        }
        if (anim.is(new String[]{ONE_HAND_2})) {
            width += 1.2 * (double)this.getScale();
            length += 0.8 * (double)this.getScale();
        }
        if (anim.is(new String[]{STAB_1})) {
            width += 0.3 * (double)this.getScale();
            length += 0.9 * (double)this.getScale();
        }
        return new AABB(-width * 0.5, -0.03, 0.0, width * 0.5, height + 0.03, length);
    }

    @Override
    public boolean hurt(DamageSource damageSource, float damage) {
        if (!this.getAnimationHandler().isCurrent(new String[]{EA}) && !damageSource.is(DamageTypeTags.BYPASSES_ARMOR) && !damageSource.is(DamageTypeTags.IS_PROJECTILE) && this.getMainHandItem().is((Item)FateItems.ENUMAELISH.get()) && (double)this.getRandom().nextFloat() < 0.15) {
            this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.0f, 1.0f);
            this.getAnimationHandler().setAnimation(GUARD);
            Entity entity = damageSource.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                Vec3 dir = entity2.position().subtract(this.position());
                dir = new Vec3(dir.x(), 0.0, dir.z()).normalize().scale(5.0);
                entity2.setDeltaMovement(entity2.getDeltaMovement().add(dir).add(0.0, 0.3, 0.0));
            }
            for (int i = 0; i < 16; ++i) {
                float red = (float)(150 + this.getRandom().nextInt(100)) / 255.0f;
                float col = (float)(10 + this.getRandom().nextInt(200)) / 255.0f;
                if ((double)col >= (double)red * 0.8) {
                    col = 0.1f;
                    red = 0.1f;
                }
                AdvancedParticleContainer.make((ParticleOptions)new TrailParticleData((ParticleType<TrailParticleData>)((ParticleType)FateParticles.TRAIL.get()), TrailInfo.builder(new ParticlePositionProvider.ParticlePositionData(MathUtils.NORMAL_Y, 6)).setColor(red, col, col, 0.7f).setColor2(red, col, col, 0.7f).setWidth(0.03f).setWidth2(0.03f).build())).addData((AdvancedParticleData)new CirclingData((float)((this.getRandom().nextDouble() * 0.15 + 1.0) * (double)this.getBbWidth()), 0.0f, (float)(this.getRandom().nextInt() * 360), 80.0f, MathUtils.NORMAL_Y)).addData((AdvancedParticleData)new ParticleMetaData(10, false, 0.0f)).add(this.level(), this.getX(), this.getY(this.getRandom().nextDouble() * 1.2), this.getZ());
            }
            return false;
        }
        return !this.getAnimationHandler().isCurrent(new String[]{EA}) && super.hurt(damageSource, damage);
    }

    @Override
    public void regenMana(Entity source) {
        if (source != this) {
            double amount = this.getAttributeValue(FateAttributes.MANA_LEECH.asHolder());
            this.regenMana(amount * 0.4);
            return;
        }
        super.regenMana(source);
    }

    @Override
    public boolean nobelPhantasmCheck() {
        return this.healthBelow(0.5f) && super.nobelPhantasmCheck();
    }

    public void ea(TargetPosition target) {
        this.getMainHandItem().remove((DataComponentType)FateDataComponents.GLOWING_ITEM.get());
        if (!this.attemptUseNobelPhantasm()) {
            return;
        }
        EnumaElish ea = new EnumaElish(this.level(), (LivingEntity)this);
        if (target != null) {
            Vec3 pos = target.asVec(ea.position());
            ea.setRotationTo(pos.x(), pos.y(), pos.z(), 0.0f);
        }
        this.level().addFreshEntity((Entity)ea);
        this.revealServant();
        this.stopUsingItem();
    }

    public void attackWithRangedAttack(LivingEntity target) {
        double perc = Mth.clamp((double)(1.0f - this.getHealth() / this.getMaxHealth()), (double)0.2, (double)0.8);
        int randAmount = (int)(18.0 * perc);
        int base = 6 + (int)(6.0 * perc);
        int weaponAmount = this.getRandom().nextInt(Math.max(1, randAmount)) + base;
        if (this.getAnimationHandler().getAnimation() == null) {
            this.spawnBehind(target, weaponAmount);
        } else if (this.getAnimationHandler().isCurrent(new String[]{BABYLON_1, BABYLON_2, BABYLON_3})) {
            int chainChance = 0;
            if (this.chainCooldown < 0) {
                if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.3) {
                    chainChance = 3;
                } else if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.5) {
                    chainChance = 5;
                } else if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.8) {
                    chainChance = 7;
                }
            }
            if (chainChance > 0 && this.getRandom().nextInt(chainChance) == 0) {
                this.spawnChains(target, weaponAmount);
            } else if (this.getRandom().nextInt(3) == 0) {
                this.spawnAroundTarget(target, weaponAmount);
            } else {
                this.spawnBehind(target, weaponAmount);
            }
        }
    }

    private void spawnBehind(LivingEntity target, int amount) {
        BabylonWeapon.spawnWeapons((LivingEntity)this, target, amount, 7);
        this.chainCooldown -= 50;
    }

    private void spawnAroundTarget(LivingEntity target, int amount) {
        BabylonWeapon.spawnWeaponsAround((LivingEntity)this, target, amount, 6 + amount / 5);
        this.chainCooldown -= 50;
    }

    private void spawnChains(LivingEntity target, int amount) {
        amount = Math.max(7, Mth.ceil((double)((double)amount * 0.7)));
        EnkiduChains.spawnWeaponsAround((LivingEntity)this, target, amount, 7 + amount / 7);
    }

    protected boolean useRanged() {
        return this.getMainHandItem().getItem() != FateItems.ENUMAELISH.get();
    }

    @Override
    protected String getSummonAnimation() {
        return SUMMON;
    }

    @Override
    public Vector4f summonColor() {
        return this.summonColor;
    }

    @Override
    public void onProjectileHit(Entity entity) {
        if (entity instanceof EnkiduChains && this.chainCooldown < 0) {
            BehaviourUtils.modifyExpiringMemory((Mob)this, MemoryModuleType.ATTACK_COOLING_DOWN, -20);
            this.chainCooldown = 250 + this.getRandom().nextInt(100);
            LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)this);
            if (target != null && this.distanceToSqr((Entity)target) < 16.0) {
                Vec3 dir = target.position().subtract(this.position());
                dir = new Vec3(-dir.x(), 0.0, -dir.z()).normalize().scale(4.5);
                entity.setDeltaMovement(dir.x(), 0.2, dir.z());
            }
        }
    }
}

