/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant;

import io.github.flemmli97.fateubw.api.datapack.ServantExtraData;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.misc.MagicShot;
import io.github.flemmli97.fateubw.common.entity.summons.LesserMonster;
import io.github.flemmli97.fateubw.common.entity.summons.Tentacle;
import io.github.flemmli97.fateubw.common.registry.FateAttributes;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.util.BrainUtils;

public class Gilles
extends BaseServant {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String SUMMON_MONSTER = BUILDER.add("summon_monster", AnimationsBuilder.definition((double)1.2).marker("attack", new double[]{0.92}));
    public static final String SHOOT = BUILDER.add("shoot", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.76}));
    public static final String SUMMON_TENTACLE = BUILDER.add("summon_tentacle", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.68}));
    public static final String NP_ATTACK = BUILDER.add("np", AnimationsBuilder.definition((double)1.0));
    public static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)2.0));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Gilles> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public Gilles(EntityType<? extends Gilles> entityType, Level level) {
        super(entityType, level);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)FateItems.GRIMOIRE.get()));
    }

    @Override
    public boolean hasOwnWeapon() {
        return this.getMainHandItem().is((Item)FateItems.GRIMOIRE.get());
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{SUMMON_MONSTER}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(16.0), 50, 80)).condition(Gilles::canSummonMore).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(7.0).max(12.0).speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(14).start(new String[]{SUMMON_MONSTER}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(16.0), 50, 80)).condition(Gilles::canSummonMore).end(11).start(new String[]{SHOOT}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(16.0), 40, 90)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(7.0).max(12.0).speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(10).start(new String[]{SHOOT}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(16.0), 40, 90)).end(7).start(new String[]{SUMMON_TENTACLE}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(16.0), 50, 80)).end(10).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(7, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(12.0f)}).add(2, BehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().radius(7.0), BehaviourUtils.moveTo()}).build();
    }

    @Override
    public void setupAttack(AnimationDefinition anim) {
        BrainUtils.clearMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.LOOK_TARGET);
        this.getNavigation().stop();
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{SUMMON_MONSTER})) {
            if (!anim.isAt("attack")) {
                this.setTargetPositionFromAttackTarget();
            }
            if (anim.isAt("attack")) {
                this.summonMonster();
            }
        }
        if (anim.is(new String[]{SUMMON_TENTACLE})) {
            if (!anim.isAt("attack")) {
                this.setTargetPositionFromAttackTarget();
            }
            if (anim.isAt("attack")) {
                this.summonTentacleAt(this.getTargetPosition());
            }
        }
        if (anim.is(new String[]{SHOOT})) {
            LivingEntity target = this.getTarget();
            if (target != null) {
                this.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            }
            if (anim.isAt("attack")) {
                this.shoot();
            }
        }
    }

    public AnimationHandler<Gilles> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void regenMana(Entity source) {
        if (source != this) {
            double amount = this.getAttributeValue(FateAttributes.MANA_LEECH.asHolder());
            this.regenMana(amount * 0.5);
            return;
        }
        super.regenMana(source);
    }

    @Override
    public boolean nobelPhantasmCheck() {
        return this.healthBelow(0.5f) && super.nobelPhantasmCheck();
    }

    public void cthulhu() {
        if (!this.level().isClientSide) {
            // empty if block
        }
    }

    protected boolean canSummonMore() {
        return this.level().getEntitiesOfClass(LesserMonster.class, this.getBoundingBox().inflate(48.0), monster -> this.getUUID().equals(monster.getOwnerUUID())).size() < this.props().getConfig(ServantExtraData.GILLES_MONSTER_MAX);
    }

    public void summonMonster() {
        if (!this.level().isClientSide && this.canSummonMore()) {
            int amount = 1;
            if ((double)this.getHealth() < 0.5 * (double)this.getMaxHealth()) {
                amount = 1 + this.getRandom().nextInt(3);
            } else if ((double)this.getRandom().nextFloat() < 0.3) {
                ++amount;
            }
            block0: for (int i = 0; i < amount; ++i) {
                LesserMonster minion = new LesserMonster(this.level(), (LivingEntity)this);
                for (int j = 0; j < 10; ++j) {
                    double x = this.getX() + (double)this.random.nextInt(18) - 9.0;
                    double y = this.getY() + (double)this.random.nextInt(4) - 2.0;
                    double z = this.getZ() + (double)this.random.nextInt(18) - 9.0;
                    minion.setRanged((double)this.getRandom().nextFloat() < 0.4);
                    minion.absMoveTo(x, y, z, Mth.wrapDegrees((float)(this.level().random.nextFloat() * 360.0f)), 0.0f);
                    if (!this.level().noCollision((Entity)minion)) continue;
                    this.level().addFreshEntity((Entity)minion);
                    minion.setTarget(this.getTarget());
                    this.revealServant();
                    continue block0;
                }
            }
        }
    }

    public void summonTentacleAt(TargetPosition targetPosition) {
        if (!this.level().isClientSide) {
            Tentacle tentacle = (Tentacle)((EntityType)FateEntities.TENTACLE.get()).create((ServerLevel)this.level(), e -> e.setOwner((LivingEntity)this), BlockPos.containing((Position)targetPosition.position()), MobSpawnType.MOB_SUMMONED, false, false);
            tentacle.setup(targetPosition.position());
            this.level().addFreshEntity((Entity)tentacle);
        }
    }

    public void shoot() {
        MagicShot proj = new MagicShot(this.level(), (LivingEntity)this);
        if (this.getTarget() != null) {
            proj.shootAtEntity((Entity)this.getTarget(), 1.0f, 0.0f);
        } else {
            proj.shoot((Entity)this, this.getXRot(), this.getYRot(), 0.0f, 1.0f, 0.0f);
        }
        this.level().addFreshEntity((Entity)proj);
    }

    @Override
    protected String getSummonAnimation() {
        return SUMMON;
    }
}

