/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.api.datapack.ServantExtraData;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.utils.MoveType;
import io.github.flemmli97.fateubw.common.network.S2CAttackDebug;
import io.github.flemmli97.fateubw.common.network.S2CScreenShake;
import io.github.flemmli97.fateubw.common.particles.RingParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.TrailParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolderProvider;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailProvider;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.registry.FateMobEffects;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.registry.FateSounds;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.joml.Vector4f;

public class Heracles
extends BaseServant {
    protected static final EntityDataAccessor<Integer> DEATH_COUNT = SynchedEntityData.defineId(Heracles.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final ResourceLocation DEATH_MOD = Fate.modRes("heracles_death_modifier");
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    private static final String ONE_HAND_HEAVY_1 = BUILDER.add("one_hand_heavy_1", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.72}).marker("step", new double[]{0.48}).marker("weapon_swing_start", new double[]{0.56}).marker("weapon_swing_end", new double[]{0.76}));
    private static final String ONE_HAND_HEAVY_2 = BUILDER.add("one_hand_heavy_2", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.68}).marker("step", new double[]{0.48}).marker("weapon_swing_start", new double[]{0.56}).marker("weapon_swing_end", new double[]{0.76}));
    private static final String ONE_HAND_HEAVY_3 = BUILDER.add("one_hand_heavy_3", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.68}).marker("step", new double[]{0.48}).marker("weapon_swing_start", new double[]{0.56}).marker("weapon_swing_end", new double[]{0.76}));
    private static final String TWO_HAND_HEAVY_1 = BUILDER.add("two_hand_heavy_1", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.72}).marker("weapon_swing_start", new double[]{0.56}).marker("weapon_swing_end", new double[]{0.76}));
    private static final String TWO_HAND_HEAVY_2 = BUILDER.add("two_hand_heavy_2", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.68}).marker("weapon_swing_start", new double[]{0.56}).marker("weapon_swing_end", new double[]{0.76}));
    private static final String UPPER_CUT = BUILDER.add("upper_cut", AnimationsBuilder.definition((double)1.04).marker("attack", new double[]{0.64}).marker("weapon_swing_start", new double[]{0.48}).marker("weapon_swing_end", new double[]{0.72}));
    private static final String JUMP = BUILDER.add("jump", AnimationsBuilder.definition((double)0.8).marker("jump", new double[]{0.12}).marker("attempt", new double[]{0.24}).infinite());
    private static final String JUMP_HIT = BUILDER.add("jump_hit", AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.2}).infinite());
    private static final String LAND = BUILDER.add("land", AnimationsBuilder.definition((double)0.44));
    private static final String LEAP = BUILDER.add("leap", AnimationsBuilder.definition((double)1.6).marker("leap", new double[]{0.64}));
    private static final String LEAP_SLASH = BUILDER.add("leap_slash", AnimationsBuilder.definition((double)0.64).marker("attack", new double[]{0.16}).marker("weapon_swing_start", new double[]{0.05}).marker("weapon_swing_end", new double[]{0.28}));
    private static final String DEATH = BUILDER.add("death", AnimationsBuilder.definition((double)0.68).infinite());
    private static final String FAKE_DEATH = BUILDER.add("fake_death", AnimationsBuilder.definition((double)5.92).marker("roar", new double[]{5.0}).marker("revive", new double[]{5.5}));
    private static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)2.0).marker("roar", new double[]{0.84}));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Heracles> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (anim == null && this.getAnimationHandler().isCurrent(new String[]{UPPER_CUT})) {
            if (this.upperCutTarget != null) {
                this.upperCutTarget = null;
                this.getAnimationHandler().setAnimation(JUMP);
                return true;
            }
        } else if (anim != null) {
            if (anim.is(new String[]{UPPER_CUT})) {
                this.upperCutTarget = null;
            }
            if (anim.is(new String[]{LEAP})) {
                this.hitEntity = null;
            }
        }
        return false;
    });
    private boolean voidDeath;
    private LivingEntity upperCutTarget;
    private List<LivingEntity> hits;
    private int lastHitTick;
    private final Vector4f summonColor = new Vector4f(0.19607843f, 0.17254902f, 0.14901961f, 0.8f);
    private int jumpCooldown;
    protected List<LivingEntity> hitEntity;

    public Heracles(EntityType<? extends BaseServant> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DEATH_COUNT, (Object)0);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)FateItems.HERACLES_AXE.get()));
    }

    @Override
    public boolean hasOwnWeapon() {
        return this.getMainHandItem().is((Item)FateItems.HERACLES_AXE.get());
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return AttackBehaviourBuilder.create().start(BehaviourUtils.of(AnimationPlayHolder.builder((String)ONE_HAND_HEAVY_1).start(ONE_HAND_HEAVY_2, 2, 0.48f, 1).start(ONE_HAND_HEAVY_3, 2, 0.48f, 1).chainChance(0.5f).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 35)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(12).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)ONE_HAND_HEAVY_2).start(ONE_HAND_HEAVY_1, 2, 0.48f, 1).start(TWO_HAND_HEAVY_1, 2, 0.48f, 1).start(TWO_HAND_HEAVY_2, 2, 0.48f, 1).chain(ONE_HAND_HEAVY_3, 2, 0.48f).chainChance(0.5f).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 35)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(12).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)TWO_HAND_HEAVY_1).start(TWO_HAND_HEAVY_2, 2, 0.48f, 1).start(TWO_HAND_HEAVY_2, 2, 0.48f, 1).chain(ONE_HAND_HEAVY_2, 2, 0.48f).chainChance(0.5f).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 35)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(12).start(new String[]{JUMP}).play(BehaviourUtils.cooldownedPlay(false, 40, 60)).condition(entity -> {
            LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
            if (this.jumpCooldown <= 0 && target != null && target.getY() - entity.getY() > 4.0) {
                Vec3 pos = entity.position();
                Vec3 targetPos = target.position();
                Vec3 dir = targetPos.subtract(pos);
                EntityHitResult hit = ProjectileUtil.getEntityHitResult((Level)entity.level(), (Entity)entity, (Vec3)pos, (Vec3)targetPos, (AABB)entity.getBoundingBox().expandTowards(dir), e -> e == target);
                if (hit != null) {
                    this.jumpCooldown = 80 + entity.getRandom().nextInt(40);
                    return true;
                }
            }
            return false;
        }).end(11).start(new String[]{UPPER_CUT}).play(BehaviourUtils.cooldownedPlay(true, 20, 35)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(6).start(new String[]{LEAP}).play(BehaviourUtils.cooldownedPlay(false, 20, 35)).condition(BehaviourUtils.ifFurtherThan(6.0, 2.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(BehaviourUtils.closeEnough(16))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(13).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(12, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).add(4, new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget(), BehaviourUtils.moveTo()}).build();
    }

    public void baseTick() {
        super.baseTick();
        AnimationState anim = this.getAnimationHandler().getAnimation();
        if (!this.level().isClientSide) {
            if (anim != null) {
                if (anim.isAt("roar")) {
                    this.playSound((SoundEvent)FateSounds.HERACLES_ROAR.get(), 1.0f, 1.0f);
                    S2CScreenShake.sendAround((Entity)this, 24.0, 16, 2.0f);
                }
                if (anim.is(new String[]{FAKE_DEATH}) && anim.isAt("revive")) {
                    int maxDeaths = this.props().getConfig(ServantExtraData.HERACLES_DEATH_MAX);
                    double mod = (double)this.getDeaths() / (double)maxDeaths * 0.7;
                    this.applyDeathMod(mod);
                    this.setHealth(this.getMaxHealth());
                    this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 300, 2, false, false));
                    this.revealServant();
                }
            }
        } else if (anim != null && anim.isAt("weapon_swing_start")) {
            this.level().addParticle((ParticleOptions)new TrailParticleData((ParticleType<TrailParticleData>)((ParticleType)FateParticles.TRAIL.get()), TrailInfo.builder(EntityWeaponTrailProvider.EntityTrailData.create(this, anim.getID(), false)).setColor(0.23529412f, 0.24313726f, 0.19215687f, 0.6f).setColor2(0.23529412f, 0.24313726f, 0.19215687f, 0.2f).setType(TrailInfo.Visual.TEXTURE, 0).build()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected MoveType getMoveFromSpeed(double speed) {
        if (this.getTarget() != null && speed >= 1.0) {
            return MoveType.RUN;
        }
        return super.getMoveFromSpeed(speed);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Deaths", this.getDeaths());
        tag.putBoolean("DeathType", this.voidDeath);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setDeathNumber(tag.getInt("Deaths"));
        this.voidDeath = tag.getBoolean("DeathType");
    }

    public void setDeathNumber(int death) {
        this.entityData.set(DEATH_COUNT, (Object)Mth.clamp((int)death, (int)0, (int)this.props().getConfig(ServantExtraData.HERACLES_DEATH_MAX)));
    }

    public int getDeaths() {
        return (Integer)this.entityData.get(DEATH_COUNT);
    }

    public boolean isAlive() {
        return super.isAlive() && (this.getAnimationHandler() == null || !this.getAnimationHandler().isCurrent(new String[]{FAKE_DEATH}));
    }

    @Override
    public boolean hurt(DamageSource damageSource, float damage) {
        if (!damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            float f;
            damage -= 4.0f;
            if (f < 0.0f) {
                return false;
            }
        }
        return !this.getAnimationHandler().isCurrent(new String[]{FAKE_DEATH}) && super.hurt(damageSource, damage);
    }

    protected void actuallyHurt(DamageSource damageSource, float damageAmount) {
        super.actuallyHurt(damageSource, damageAmount);
        if (this.getHealth() <= 0.0f && !damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            int maxDeaths = this.props().getConfig(ServantExtraData.HERACLES_DEATH_MAX);
            if (this.getDeaths() < maxDeaths) {
                this.getAnimationHandler().setAnimation(FAKE_DEATH);
                this.setHealth(1.0E-4f);
                this.setDeathNumber(this.getDeaths() + 1);
            }
        }
    }

    private void applyDeathMod(double mod) {
        AttributeInstance att = this.getAttribute(Attributes.MAX_HEALTH);
        att.removeModifier(DEATH_MOD);
        AttributeInstance dmg = this.getAttribute(Attributes.ATTACK_DAMAGE);
        dmg.removeModifier(DEATH_MOD);
        if (mod != 0.0) {
            att.addPermanentModifier(new AttributeModifier(DEATH_MOD, -mod, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            dmg.addPermanentModifier(new AttributeModifier(DEATH_MOD, mod * 0.35, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{UPPER_CUT})) {
            if (anim.isAt("attack")) {
                Vec3 dir = Vec3.directionFromRotation((float)0.0f, (float)this.getYRot()).scale(2.0);
                this.setTargetPosition((TargetPosition)null);
                this.mobAttack(anim, this.getTarget(), e -> {
                    if (this.doHurtTarget((Entity)e)) {
                        e.setDeltaMovement(dir.x(), 2.0, dir.z());
                        e.hurtMarked = true;
                        if (e instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)e;
                            player.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
                        }
                        if (this.upperCutTarget == null || e == this.getTarget()) {
                            this.upperCutTarget = e;
                        }
                    }
                });
            }
        } else if (anim.is(new String[]{JUMP})) {
            if (anim.isAt("jump")) {
                LivingEntity target;
                LivingEntity livingEntity = target = this.upperCutTarget != null ? this.upperCutTarget : this.getTarget();
                if (target != null) {
                    Vec3 diff;
                    Vec3 dir = diff.add(0.0, (diff = target.position().add(target.getDeltaMovement().scale(20.0)).subtract(this.position())).y() > 0.0 ? -diff.y() * 0.5 : 0.0, 0.0).normalize().scale(3.5);
                    this.setDeltaMovement(dir.x(), Mth.clamp((double)dir.y(), (double)1.5, (double)2.5), dir.z());
                } else {
                    Vec3 dir = Vec3.directionFromRotation((float)0.0f, (float)this.getYRot()).scale(2.0);
                    this.setDeltaMovement(dir.x(), 2.0, dir.z());
                }
            }
            if (anim.isPast("attempt") && !anim.done(0)) {
                OrientedBoundingBox obb = this.calculateAttackAABB(anim, null, 0.0);
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTEMPT, (Entity)this);
                List hits = this.level().getEntitiesOfClass(LivingEntity.class, obb.getEncompassingBox(), entity -> this.targetPred.test(entity) && obb.intersects(entity.getBoundingBox()));
                if (!hits.isEmpty()) {
                    S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)this);
                    this.getAnimationHandler().setAnimation(JUMP_HIT);
                    this.setDeltaMovement(Vec3.ZERO);
                    this.hits = hits;
                    return;
                }
            }
            if (anim.done(0)) {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
                this.handleAirFall(anim);
            }
        } else if (anim.is(new String[]{JUMP_HIT})) {
            if (anim.isAt("attack") && this.hits != null) {
                Vec3 dir = Vec3.directionFromRotation((float)0.0f, (float)this.getYRot());
                this.hits.forEach(e -> {
                    if (this.doHurtTarget((Entity)e)) {
                        e.setDeltaMovement(dir.x(), -4.0, dir.z());
                        e.hurtMarked = true;
                        e.addEffect(new MobEffectInstance(FateMobEffects.GRAVITY.asHolder(), 200, 3));
                        if (e instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)e;
                            player.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
                        }
                    }
                });
                if (!this.hits.isEmpty()) {
                    AdvancedParticleContainer.make((ParticleOptions)new RingParticleData(this.getYRot(), 40.0f)).addData((AdvancedParticleData)new ColorData(0.9f, 0.9f, 0.9f)).addData((AdvancedParticleData)new ScaleData(1.0f, 4.0f, 3)).addData((AdvancedParticleData)new ParticleMetaData(8, false, 0.0f)).add(this.level(), this.getX(), this.getEyeY(), this.getZ());
                }
                this.hits = null;
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.1, 0.0));
            }
            if (anim.isPast("attack")) {
                this.handleAirFall(anim);
            } else {
                this.setDeltaMovement(Vec3.ZERO);
                if (this.hits != null) {
                    this.hits.forEach(e -> {
                        e.setDeltaMovement(Vec3.ZERO);
                        if (e instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)e;
                            player.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
                        }
                    });
                }
            }
        } else if (anim.is(new String[]{LEAP})) {
            if (anim.isAt("leap")) {
                Vec3 dir = this.getTarget() != null ? this.getTarget().position().subtract(this.position()) : this.getViewVector(1.0f);
                dir = new Vec3(dir.x(), 0.0, dir.z());
                this.setDeltaMovement(dir.normalize().scale(4.5).add(0.0, 0.25, 0.0));
            }
            if (anim.isPast("leap")) {
                if (this.hitEntity == null) {
                    this.hitEntity = new ArrayList<LivingEntity>();
                }
                this.mobAttack(anim, this.getTarget(), e -> {
                    if (!this.hitEntity.contains(e)) {
                        this.hitEntity.add((LivingEntity)e);
                        this.doHurtTarget((Entity)e);
                    }
                });
                if (!this.hitEntity.isEmpty()) {
                    S2CScreenShake.sendAround((Entity)this, 12.0, 8, 2.0f);
                    this.setDeltaMovement(this.getDeltaMovement().scale(0.05));
                    this.getAnimationHandler().setAnimation(LEAP_SLASH);
                }
            }
        } else {
            if (anim.isAt("step")) {
                Vec3 dir = Utils.fromRelativeVector((Entity)this, new Vec3(0.0, 0.0, 1.0)).scale(0.3);
                this.setDeltaMovement(this.getDeltaMovement().add(dir));
            }
            super.handleAttack(anim);
        }
    }

    private void handleAirFall(AnimationState anim) {
        this.fallDistance = 0.0f;
        if (anim.done(0) && this.onGround()) {
            this.getAnimationHandler().setAnimation(LAND);
        }
        if (!(!anim.isPast(6.0) || this.getInBlockState().is(Blocks.AIR) && this.getBlockStateOn().is(Blocks.AIR))) {
            this.getAnimationHandler().setAnimation(LAND);
        }
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        boolean hurt = super.doHurtTarget(entity);
        if (hurt) {
            if (this.lastHitTick != this.tickCount) {
                S2CScreenShake.sendAround((Entity)this, 12.0, 8, 2.0f);
                this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.0f, this.getRandom().nextFloat() * 0.2f + 0.9f);
            }
            this.lastHitTick = this.tickCount;
        }
        return hurt;
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        if (anim.is(new String[]{JUMP})) {
            double widthH = (double)this.getBbWidth() * 0.5 + 1.3;
            double length = (double)this.getBbWidth() + 2.5;
            return new AABB(-widthH, -1.0, -0.5, widthH, (double)this.getBbHeight() + 1.5, length);
        }
        double height = this.getBbHeight();
        double width = this.getBbWidth();
        double length = 1.0f * this.getScale();
        if (anim.is(new String[]{ONE_HAND_HEAVY_1, TWO_HAND_HEAVY_1})) {
            width += 0.6 * (double)this.getScale();
            length += 1.7 * (double)this.getScale();
        }
        if (anim.is(new String[]{ONE_HAND_HEAVY_2, ONE_HAND_HEAVY_3, TWO_HAND_HEAVY_2})) {
            width += 2.2 * (double)this.getScale();
            length += 1.3 * (double)this.getScale();
        }
        if (anim.is(new String[]{UPPER_CUT})) {
            width += 0.6 * (double)this.getScale();
            length += 1.7 * (double)this.getScale();
        }
        return new AABB(-width * 0.5, -0.03, 0.0, width * 0.5, height + 0.03, length);
    }

    public AnimationHandler<Heracles> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public String getDeathAnimation() {
        return DEATH;
    }

    @Override
    protected String getSummonAnimation() {
        return SUMMON;
    }

    @Override
    public double getSummonProgress(float partialTicks) {
        double prog = super.getSummonProgress(partialTicks);
        return prog >= 0.0 ? Mth.clamp((double)(prog * 2.0), (double)0.0, (double)1.0) : prog;
    }

    @Override
    public Vector4f summonColor() {
        return this.summonColor;
    }

    @Override
    public EntityWeaponTrailHolderProvider.WeaponTrail weaponTrailEdge(boolean left) {
        return new EntityWeaponTrailHolderProvider.WeaponTrail(new Vector4f(0.0f, 0.0f, -0.8f, 1.0f), new Vector4f(0.0f, 0.0f, -1.9f, 1.0f));
    }
}

