/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant;

import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.summons.GordiusWheel;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.TrailParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailProvider;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.fateubw.mixinhelper.HorseExtension;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.joml.Vector4f;

public class Iskander
extends BaseServant {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String ONE_HAND_1 = BUILDER.add("one_hand_1", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.56}).marker("step", new double[]{0.28}).marker("weapon_swing_start", new double[]{0.36}).marker("weapon_swing_end", new double[]{0.6}));
    public static final String ONE_HAND_2 = BUILDER.add("one_hand_2", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.56}).marker("step", new double[]{0.28}).marker("weapon_swing_start", new double[]{0.36}).marker("weapon_swing_end", new double[]{0.6}));
    public static final String ONE_HAND_3 = BUILDER.add("one_hand_3", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.56}).marker("step", new double[]{0.28}).marker("weapon_swing_start", new double[]{0.36}).marker("weapon_swing_end", new double[]{0.6}));
    public static final String ONE_HAND_4 = BUILDER.add("one_hand_4", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.56}).marker("step", new double[]{0.28}).marker("weapon_swing_start", new double[]{0.36}).marker("weapon_swing_end", new double[]{0.6}));
    public static final String ONE_HAND_5 = BUILDER.add("one_hand_5", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.56}).marker("step", new double[]{0.28}).marker("weapon_swing_start", new double[]{0.36}).marker("weapon_swing_end", new double[]{0.6}));
    public static final String ONE_HAND_6 = BUILDER.add("one_hand_6", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.56}).marker("step", new double[]{0.28}).marker("weapon_swing_start", new double[]{0.36}).marker("weapon_swing_end", new double[]{0.6}));
    public static final String ONE_HAND_7 = BUILDER.add("one_hand_7", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.56}).marker("step", new double[]{0.28}).marker("weapon_swing_start", new double[]{0.36}).marker("weapon_swing_end", new double[]{0.6}));
    private static final String CHARIOT = BUILDER.add("chariot_summon", AnimationsBuilder.definition((double)1.68).marker("attack", new double[]{0.76}).marker("weapon_swing_start", new double[]{0.52}).marker("weapon_swing_end", new double[]{0.8}));
    private static final String SUMMON_HORSE = BUILDER.add("horse", CHARIOT);
    public static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)2.0));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Iskander> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private final Vector4f summonColor = new Vector4f(0.4392157f, 0.09019608f, 0.08235294f, 0.7f);
    private int summonCooldown;

    public Iskander(EntityType<? extends Iskander> entityType, Level level) {
        super(entityType, level);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)FateItems.KUPRIOTS.get()));
    }

    @Override
    public boolean hasOwnWeapon() {
        return this.getMainHandItem().is((Item)FateItems.KUPRIOTS.get());
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return AttackBehaviourBuilder.create().start(BehaviourUtils.of(AnimationPlayHolder.builder((String)ONE_HAND_1).start(ONE_HAND_3, 2, 0.28f, 1).start(ONE_HAND_5, 2, 0.28f, 1).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 27)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(8).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)ONE_HAND_2).start(ONE_HAND_1, 2, 0.28f, 1).start(ONE_HAND_6, 2, 0.28f, 1).start(ONE_HAND_7, 2, 0.28f, 1).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 27)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(8).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)ONE_HAND_3).start(ONE_HAND_6, 2, 0.28f, 1).start(ONE_HAND_7, 2, 0.28f, 1).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 27)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(8).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)ONE_HAND_4).start(ONE_HAND_3, 2, 0.28f, 1).start(ONE_HAND_5, 2, 0.28f, 1).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 27)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(8).start(new String[]{SUMMON_HORSE}).play(BehaviourUtils.cooldownedPlay(false, 25, 40)).condition(Iskander::canSummonMounts).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(10.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(5).start(new String[]{SUMMON_HORSE}).play(BehaviourUtils.cooldownedPlay(false, 25, 40)).condition(entity -> entity.canSummonMounts() && !entity.canUseNobelPhantasm()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(10.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(7).start(new String[]{CHARIOT}).play(BehaviourUtils.cooldownedPlay(false, 25, 40)).condition(entity -> entity.canSummonMounts() && entity.canUseNobelPhantasm()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(6.0).max(12.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(14).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(6, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).add(6, BehaviourUtils.withCondition(Entity::isPassenger), new ExtendedBehaviour[]{new SetRandomWalkTarget().setRadius(8.0, 4.0), BehaviourUtils.moveTo()}).add(3, new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().radius(6.0), BehaviourUtils.moveTo()}).build();
    }

    public void baseTick() {
        AnimationState anim;
        super.baseTick();
        if (!this.level().isClientSide && !this.isPassenger()) {
            --this.summonCooldown;
        }
        if (this.level().isClientSide && (anim = this.getAnimationHandler().getAnimation()) != null && anim.isAt("weapon_swing_start")) {
            this.level().addParticle((ParticleOptions)new TrailParticleData((ParticleType<TrailParticleData>)((ParticleType)FateParticles.TRAIL.get()), TrailInfo.builder(EntityWeaponTrailProvider.EntityTrailData.create(this, anim.getID(), false)).setColor(0.84313726f, 0.7176471f, 0.5764706f, 0.6f).setColor2(0.84313726f, 0.7176471f, 0.5764706f, 0.2f).setType(TrailInfo.Visual.TEXTURE, 0).build()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{CHARIOT, SUMMON_HORSE})) {
            LivingEntity target = this.getTarget();
            if (target != null && !anim.isPast(0.28)) {
                this.lookAt((Entity)target, 60.0f, 30.0f);
            }
            this.level().getEntities(EntityTypeTest.forClass(LivingEntity.class), this.getBoundingBox().inflate(12.0, 8.0, 12.0), this.targetPred).forEach(e -> {
                Vec3 dir = e.position().subtract(this.position());
                boolean none = dir.x() == 0.0 && dir.z() == 0.0;
                dir = new Vec3(none ? 1.0 : dir.x(), 0.0, dir.z()).normalize().scale(0.5);
                e.setDeltaMovement(e.getDeltaMovement().add(dir));
                e.hurtMarked = true;
            });
            if (anim.isAt("attack")) {
                if (anim.is(new String[]{SUMMON_HORSE})) {
                    this.summonHorse();
                } else {
                    this.summonChariot();
                }
            }
        } else {
            if (anim.isAt("step")) {
                Vec3 dir = Utils.fromRelativeVector((Entity)this, new Vec3(0.0, 0.0, 1.0)).scale(0.4);
                this.setDeltaMovement(this.getDeltaMovement().add(dir));
            }
            super.handleAttack(anim);
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, Vec3 target, double grow) {
        if (this.getVehicle() != null) {
            GordiusWheel gordiusWheel;
            Entity vehicle = this.getVehicle();
            Entity entity = this.getVehicle();
            if (entity instanceof GordiusWheel && (gordiusWheel = (GordiusWheel)entity).getWheelEntity() != null) {
                vehicle = gordiusWheel.getWheelEntity();
            }
            double width = (double)vehicle.getBbWidth() * 0.5 + 1.7;
            double height = this.getY() - vehicle.getY() + (double)this.getBbHeight() + 0.2;
            AABB aabb = new AABB(-width * 0.5, -0.02, -width * 0.5, width * 0.5, height, width * 0.5);
            return new OrientedBoundingBox(aabb, vehicle.getYRot(), 0.0f, vehicle.position());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double height = this.getBbHeight();
        double width = this.getBbWidth();
        double length = 1.0f * this.getScale();
        if (anim.is(new String[]{ONE_HAND_1})) {
            return new AABB(-(width += 1.1 * (double)this.getScale()) * 0.7, -0.03, 0.0, width * 0.3, height + 0.03, length += 0.7 * (double)this.getScale());
        }
        if (anim.is(new String[]{ONE_HAND_2, ONE_HAND_3, ONE_HAND_4})) {
            width += 1.3 * (double)this.getScale();
            length += 0.6 * (double)this.getScale();
        }
        if (anim.is(new String[]{ONE_HAND_5, ONE_HAND_6})) {
            width += 1.8 * (double)this.getScale();
            length += 0.7 * (double)this.getScale();
        }
        if (anim.is(new String[]{ONE_HAND_7})) {
            width += 0.6 * (double)this.getScale();
            length += 0.9 * (double)this.getScale();
        }
        return new AABB(-width * 0.5, -0.03, 0.0, width * 0.5, height + 0.03, length);
    }

    public AnimationHandler<Iskander> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean hurt(DamageSource damageSource, float damage) {
        if (this.getAnimationHandler().isCurrent(new String[]{CHARIOT})) {
            return false;
        }
        if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(damageSource, damage);
        }
        if (this.getVehicle() != null) {
            this.getVehicle().hurt(damageSource, damage *= 0.5f);
        }
        return super.hurt(damageSource, damage);
    }

    @Override
    public boolean nobelPhantasmCheck() {
        return this.healthBelow(0.8f) && super.nobelPhantasmCheck();
    }

    protected boolean canSummonMounts() {
        return !this.isPassenger() && this.summonCooldown <= 0;
    }

    public void summonChariot() {
        if (this.isPassenger() || this.level().isClientSide) {
            return;
        }
        if (!this.attemptUseNobelPhantasm()) {
            return;
        }
        GordiusWheel wheel = (GordiusWheel)((EntityType)FateEntities.GORDIUS_WHEEL.get()).create(this.level());
        wheel.setPos(this.getX(), this.getY(), this.getZ());
        this.level().addFreshEntity((Entity)wheel);
        this.boardingCooldown = 0;
        this.startRiding((Entity)wheel);
        for (int i = 0; i < 5; ++i) {
            LightningBolt lightningboltentity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
            lightningboltentity.moveTo(this.getX() + this.random.nextGaussian() * 2.0, this.getY(), this.getZ() + this.random.nextGaussian() * 2.0);
            lightningboltentity.setVisualOnly(true);
            this.level().addFreshEntity((Entity)lightningboltentity);
        }
        this.summonCooldown = 150 + this.getRandom().nextInt(100);
        this.revealServant();
    }

    public void summonHorse() {
        if (this.isPassenger() || this.level().isClientSide) {
            return;
        }
        Horse horse = (Horse)EntityType.HORSE.create(this.level());
        horse.setPos(this.getX(), this.getY(), this.getZ());
        horse.setTamed(true);
        ((HorseExtension)horse).fate$setTotalControl(true);
        this.level().addFreshEntity((Entity)horse);
        horse.getAttribute(Attributes.MAX_HEALTH).setBaseValue(horse.getAttributeBaseValue(Attributes.MAX_HEALTH) + 30.0);
        horse.getAttribute(Attributes.ARMOR).setBaseValue(2.0);
        horse.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(horse.getAttributeBaseValue(Attributes.MOVEMENT_SPEED) + 0.15);
        this.boardingCooldown = 0;
        this.startRiding((Entity)horse);
        for (int i = 0; i < 5; ++i) {
            LightningBolt lightningboltentity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
            lightningboltentity.moveTo(this.getX() + this.random.nextGaussian() * 2.0, this.getY(), this.getZ() + this.random.nextGaussian() * 2.0);
            lightningboltentity.setVisualOnly(true);
            this.level().addFreshEntity((Entity)lightningboltentity);
        }
        this.summonCooldown = 150 + this.getRandom().nextInt(100);
        this.revealServant();
    }

    @Override
    protected String getSummonAnimation() {
        return SUMMON;
    }

    @Override
    public Vector4f summonColor() {
        return this.summonColor;
    }
}

