/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant;

import io.github.flemmli97.fateubw.api.datapack.ServantExtraData;
import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.HeldEquipmentHandler;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.TeleportBehaviour;
import io.github.flemmli97.fateubw.common.entity.misc.MagicBeam;
import io.github.flemmli97.fateubw.common.entity.misc.MagicBufCircle;
import io.github.flemmli97.fateubw.common.registry.FateAttributes;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.registry.FateMobEffects;
import io.github.flemmli97.fateubw.common.utils.TeleportUtils;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.LeapInDirection;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import org.joml.Vector4f;

public class Medea
extends BaseServant {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String CAST_1 = BUILDER.add("cast_1", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.6}));
    public static final String CAST_2 = BUILDER.add("cast_2", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.72}));
    public static final String CAST_3 = BUILDER.add("cast_3", AnimationsBuilder.definition((double)1.36).marker("attack", new double[]{1.2}));
    public static final String CAST_4 = BUILDER.add("cast_4", AnimationsBuilder.definition((double)3.04).marker("attack_start", new double[]{0.72}).marker("attack_end", new double[]{2.6}).marker("teleport_start", new double[]{0.28}).marker("teleport_end", new double[]{2.8}));
    public static final String MAGIC_CIRCLE = BUILDER.add("magic_circle", AnimationsBuilder.definition((double)2.2).marker("attack", new double[]{1.04}).marker("push", new double[]{0.52}));
    public static final String RULE_BREAKER = BUILDER.add("rule_breaker", AnimationsBuilder.definition((double)2.72).marker("attack", new double[]{1.84}).marker("teleport_start", new double[]{0.8}).marker("teleport_end", new double[]{2.44}));
    public static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)2.0));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    public static final String CIRCLE_COMMAND = String.valueOf(FateEntities.MEDEA.getID()) + ".circle";
    private final AnimationHandler<Medea> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (!this.level().isClientSide() && this.teleportPre != null) {
            this.teleportPre = null;
            this.teleportPos = null;
            this.setNoGravity(this.gravityPre);
        }
        return false;
    });
    public final HeldEquipmentHandler heldEquipmentHandler = new HeldEquipmentHandler((LivingEntity)this, new ItemStack((ItemLike)FateItems.RULE_BREAKER.get()), null);
    private boolean gravityPre;
    private Vec3 teleportPre;
    private Vec3 teleportPos;
    private int circleDelay;
    private int aiCircledelay;
    private Vec3 circlePos;
    private final Vector4f summonColor = new Vector4f(0.23137255f, 0.05490196f, 0.29803923f, 0.7f);

    public Medea(EntityType<? extends BaseServant> entityType, Level level) {
        super(entityType, level);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)FateItems.STAFF.get()));
    }

    @Override
    public boolean hasOwnWeapon() {
        return this.getMainHandItem().is((Item)FateItems.STAFF.get());
    }

    @Override
    public HeldEquipmentHandler getEquipmentHandler() {
        return this.heldEquipmentHandler;
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{CAST_1}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(15.0), 20, 40)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(6.0).max(15.0).speedMod(1.1f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(11).start(new String[]{CAST_1}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(15.0), 20, 40)).condition(BehaviourUtils.ifCloserThan(6.0)).prepare(new ExtendedBehaviour[]{new LeapInDirection().horizontalDirection((owner, target) -> LeapInDirection.createBackwardsVec((Vec3)owner.position(), (Vec3)target.position()).scale((double)1.2f))}).end(15).start(new String[]{CAST_2}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(15.0), 20, 40)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(6.0).max(15.0).speedMod(1.1f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(11).start(new String[]{CAST_3}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(15.0), 20, 40)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(6.0).max(15.0).speedMod(1.1f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(9).start(new String[]{CAST_3}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(15.0), 20, 40)).condition(BehaviourUtils.ifCloserThan(6.0)).prepare(new ExtendedBehaviour[]{new LeapInDirection().horizontalDirection((owner, target) -> LeapInDirection.createBackwardsVec((Vec3)owner.position(), (Vec3)target.position()).scale((double)1.2f))}).end(13).start(new String[]{CAST_4}).play(BehaviourUtils.cooldownedPlay(false, 20, 40)).condition(BehaviourUtils.ifCloserThan(18.0)).end(6).start(new String[]{MAGIC_CIRCLE}).play(BehaviourUtils.cooldownedPlay(false, 30, 60)).condition(medea -> medea.aiCircledelay < 0).end(8).start(new String[]{RULE_BREAKER}).play(BehaviourUtils.cooldownedPlay(false, 20, 40)).condition(BaseServant::canUseNobelPhantasm).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(7.0).max(12.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(50).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(4, new ExtendedBehaviour[]{new TeleportBehaviour().min(2.0).max(12.0).teleportMin(6).teleportMax(13), new Idle()}).add(7, BehaviourUtils.ifCloserThan(5.0), new ExtendedBehaviour[]{new TeleportBehaviour().min(2.0).max(12.0).teleportMin(8).teleportMax(14), new Idle()}).add(15, new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().radius(8.0).speedMod(1.1f), BehaviourUtils.moveTo()}).build();
    }

    public void baseTick() {
        super.baseTick();
        --this.circleDelay;
        --this.aiCircledelay;
        if (this.level().isClientSide) {
            if (this.getAnimationHandler().isCurrent(new String[]{MAGIC_CIRCLE}) && this.getAnimationHandler().getAnimation().isAt("attack")) {
                this.sphereParticles();
            }
        } else {
            if (this.tickCount % 10 == 0 && this.circlePos != null && this.level().getEntities(EntityTypeTest.forClass(MagicBufCircle.class), new AABB(this.circlePos.add(-2.0, -2.0, -2.0), this.circlePos.add(2.0, 2.0, 2.0)), e -> e.getOwner() == this).isEmpty()) {
                this.circlePos = null;
            }
            this.heldEquipmentHandler.setInUse(this.getAnimationHandler().isCurrent(new String[]{RULE_BREAKER}));
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("CircleDelay", this.circleDelay);
        tag.putInt("CircleDelayAI", this.aiCircledelay);
        if (this.circlePos != null) {
            tag.putDouble("CircleX", this.circlePos.x());
            tag.putDouble("CircleY", this.circlePos.y());
            tag.putDouble("CircleZ", this.circlePos.z());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.circleDelay = tag.getInt("CircleDelay");
        this.aiCircledelay = tag.getInt("CircleDelayAI");
        if (tag.contains("CircleX")) {
            this.circlePos = new Vec3(tag.getDouble("CircleX"), tag.getDouble("CircleY"), tag.getDouble("CircleZ"));
        }
    }

    public boolean hasRestriction() {
        return super.hasRestriction() || this.circlePos != null;
    }

    public BlockPos getRestrictCenter() {
        return this.circlePos != null ? BlockPos.containing((Position)this.circlePos) : super.getRestrictCenter();
    }

    public boolean isWithinRestriction(BlockPos pos) {
        if (this.circlePos != null) {
            float range = this.props().getConfig(ServantExtraData.MEDEA_CIRCLE_RANGE).floatValue();
            if (this.circlePos.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5) > (double)(range * range)) {
                return false;
            }
        }
        return super.isWithinRestriction(pos);
    }

    @Override
    public String[] specialCommands() {
        return new String[]{CIRCLE_COMMAND};
    }

    @Override
    public void doSpecialCommand(ServerPlayer sender, String id) {
        if (id.equals(CIRCLE_COMMAND) && this.circleDelay <= 0) {
            this.getAnimationHandler().setAnimation(MAGIC_CIRCLE);
        }
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{CAST_1, CAST_2, CAST_3})) {
            LivingEntity target = this.getTarget();
            if (target != null) {
                this.lookAt((Entity)target, 60.0f, 30.0f);
            }
            if (anim.isAt("attack")) {
                this.singleShot(target);
            }
        } else if (anim.is(new String[]{CAST_4})) {
            LivingEntity target = this.getTarget();
            if (target != null) {
                this.lookAt((Entity)target, 60.0f, 30.0f);
            }
            if (anim.isAt("teleport_start")) {
                this.teleportPre = this.position();
                this.gravityPre = this.isNoGravity();
                this.teleportTo(this.getX(), this.getY() + 8.0, this.getZ());
                this.teleportPos = this.position();
            }
            if (this.teleportPos != null) {
                this.setPos(this.teleportPos);
            }
            if (anim.isAt("teleport_end")) {
                this.fallDistance = 0.0f;
                this.teleportTo(this.teleportPre.x(), this.teleportPre.y(), this.teleportPre.z());
                this.teleportPre = null;
                this.teleportPos = null;
                this.setNoGravity(this.gravityPre);
            }
            if (anim.isAt("attack_start")) {
                this.applyManaLeechDebuff(60, 0.3);
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end") && this.tickCount % 3 == 0) {
                this.attackWithRangedAttack(target);
            }
        } else if (anim.is(new String[]{MAGIC_CIRCLE})) {
            if (anim.isAt("attack")) {
                this.makeCircle();
            }
            if (anim.isAt("push")) {
                this.level().getEntities(EntityTypeTest.forClass(LivingEntity.class), this.getBoundingBox().inflate(12.0, 8.0, 12.0), this.targetPred).forEach(e -> {
                    Vec3 dir = e.position().subtract(this.position());
                    boolean none = dir.x() == 0.0 && dir.z() == 0.0;
                    dir = new Vec3(none ? 1.0 : dir.x(), 0.0, dir.z()).normalize().scale(2.5);
                    e.setDeltaMovement(e.getDeltaMovement().add(dir));
                    e.hurtMarked = true;
                });
            }
        } else if (anim.is(new String[]{RULE_BREAKER})) {
            LivingEntity target = this.getTarget();
            if (target != null) {
                this.lookAt((Entity)target, 60.0f, 30.0f);
            }
            if (anim.isAt("teleport_start")) {
                Vec3 dir;
                if (this.getTarget() != null) {
                    dir = this.getTarget().position().subtract(this.position());
                } else {
                    Vec3 look = Vec3.directionFromRotation((float)0.0f, (float)this.getYHeadRot()).scale(11.0);
                    BlockHitResult res = this.level().clip(new ClipContext(this.getEyePosition(), this.getEyePosition().add(look), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                    dir = res.getLocation().subtract(this.getEyePosition());
                }
                Vec3 off = dir.normalize();
                dir = dir.subtract(off);
                this.teleportPre = this.position();
                this.gravityPre = this.isNoGravity();
                TeleportUtils.teleportTo((LivingEntity)this, this.getX() + dir.x(), this.getY() + dir.y(), this.getZ() + dir.z(), SoundEvents.ENDERMAN_TELEPORT, (ParticleOptions)ParticleTypes.WITCH);
                this.teleportPos = this.position();
            }
            if (anim.isAt("teleport_end") && this.teleportPre != null) {
                this.teleportTo(this.teleportPre.x(), this.teleportPre.y(), this.teleportPre.z());
                this.teleportPre = null;
                this.teleportPos = null;
                this.setNoGravity(this.gravityPre);
            }
            if (anim.isAt("attack")) {
                this.ruleBreaker();
            }
        }
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double height = this.getBbHeight();
        double width = this.getBbWidth();
        double length = 1.0f * this.getScale();
        if (anim.is(new String[]{RULE_BREAKER})) {
            width += 0.2 * (double)this.getScale();
            length += 0.7 * (double)this.getScale();
        }
        return new AABB(-width * 0.5, -0.03, 0.0, width * 0.5, height + 0.03, length);
    }

    public AnimationHandler<Medea> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean hurt(DamageSource damageSource, float damage) {
        return !this.getAnimationHandler().isCurrent(new String[]{RULE_BREAKER}) && !this.transit(false) && super.hurt(damageSource, damage);
    }

    @Override
    public void regenMana(Entity source) {
        if (source != this) {
            double amount = this.getAttributeValue(FateAttributes.MANA_LEECH.asHolder());
            this.regenMana(amount * 0.5);
            return;
        }
        super.regenMana(source);
    }

    private boolean transit(boolean teleportOnly) {
        AnimationState anim = this.getAnimationHandler().getAnimation();
        if (anim == null) {
            return false;
        }
        if (anim.is(new String[]{CAST_4})) {
            if (!teleportOnly) {
                return anim.isPast("teleport_start", 0.56);
            }
            return anim.isPast("teleport_start", 0.56) || anim.isPast("teleport_end");
        }
        return anim.is(new String[]{RULE_BREAKER}) && (anim.isPast("teleport_start", 1.32) || anim.isPast("teleport_end", 2.6));
    }

    public boolean isInvisible() {
        if (this.transit(true)) {
            return true;
        }
        return super.isInvisible();
    }

    @Override
    public boolean nobelPhantasmCheck() {
        return this.healthBelow(0.6f) && super.nobelPhantasmCheck();
    }

    public void ruleBreaker() {
        if (!this.attemptUseNobelPhantasm()) {
            return;
        }
        this.mobAttack(this.getAnimationHandler().getAnimation(), this.getTarget(), entity -> {
            if (this.doHurtTarget((Entity)entity)) {
                entity.addEffect(new MobEffectInstance(FateMobEffects.RULE_BREAKER.asHolder(), CommonConfig.ruleBreakerDuration));
                if (entity instanceof BaseServant) {
                    BaseServant servant = (BaseServant)entity;
                    servant.useMana(servant.getMana());
                }
                entity.getActiveEffects().removeIf(inst -> ((MobEffect)inst.getEffect().value()).getCategory() != MobEffectCategory.HARMFUL);
            }
        });
        this.revealServant();
    }

    public void singleShot(LivingEntity target) {
        int strength = 0;
        MobEffectInstance eff = this.getEffect(MobEffects.DAMAGE_BOOST);
        if (eff != null) {
            strength = eff.getAmplifier();
        }
        MagicBeam beam = new MagicBeam(this.level(), (LivingEntity)this, target);
        Vec3 look = this.getViewVector(1.0f);
        beam.setPos(this.getEyePosition().add(look.x(), 2.0, look.z()));
        beam.setDamageMultiplier(1.0f + (float)strength * 0.15f);
        if (target != null) {
            beam.setRotationTo((Entity)target, 0.0f);
        } else {
            beam.setRotationToDir(look.x(), look.y(), look.z(), 0.0f);
        }
        this.level().addFreshEntity((Entity)beam);
        this.revealServant();
    }

    public void attackWithRangedAttack(LivingEntity target) {
        int strength = 0;
        MobEffectInstance eff = this.getEffect(MobEffects.DAMAGE_BOOST);
        if (eff != null) {
            strength = eff.getAmplifier();
        }
        int amount = this.getRandom().nextInt(2) + 1;
        for (Vec3 offset : Utils.randomSidedPositions((LivingEntity)this, amount, 7)) {
            MagicBeam beam = new MagicBeam(this.level(), (LivingEntity)this, target);
            beam.setDamageMultiplier(0.9f + (float)strength * 0.15f);
            beam.setPos(offset.x, offset.y, offset.z);
            if (target != null) {
                beam.setRotationTo((Entity)target, 0.0f);
            } else {
                Vec3 dir = this.getViewVector(1.0f);
                beam.setRotationToDir(dir.x(), dir.y(), dir.z(), 0.0f);
            }
            this.level().addFreshEntity((Entity)beam);
        }
        this.revealServant();
    }

    public void makeCircle() {
        if (!this.level().isClientSide) {
            MagicBufCircle circle = new MagicBufCircle(this.level(), (LivingEntity)this, this.props().getConfig(ServantExtraData.MEDEA_CIRCLE_RANGE).floatValue());
            this.level().addFreshEntity((Entity)circle);
            int duration = this.props().getConfig(ServantExtraData.MEDEA_CIRCLE_DURATION);
            this.circleDelay = duration + this.random.nextInt(100);
            this.aiCircledelay = duration + this.random.nextInt(400);
            this.circlePos = circle.position();
            if (this.getOwner() != null) {
                this.getOwner().sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.medea.circle.spawn"));
            }
            this.playSound(SoundEvents.BEACON_POWER_SELECT, 1.0f, 1.0f);
        }
    }

    private void sphereParticles() {
        double goldenAngle = Math.PI * (Math.sqrt(5.0) - 1.0);
        for (int i = 0; i < 40; ++i) {
            double phi = Math.acos(1.0 - 2.0 * (double)i / 50.0);
            double theta = goldenAngle * (double)i;
            double x = Math.cos(theta) * Math.sin(phi);
            double y = Math.sin(theta) * Math.sin(phi);
            double z = Math.cos(phi);
            this.level().addParticle((ParticleOptions)ParticleTypes.WITCH, this.getX() + x, this.getY(0.5) + y, this.getZ() + z, x * 0.15, y * 0.15, z * 0.15);
        }
    }

    @Override
    protected String getSummonAnimation() {
        return SUMMON;
    }

    @Override
    public Vector4f summonColor() {
        return this.summonColor;
    }
}

