/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant;

import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.effects.PetrificationEffect;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.SetWalkToFront;
import io.github.flemmli97.fateubw.common.entity.misc.ChainDagger;
import io.github.flemmli97.fateubw.common.entity.summons.GordiusWheel;
import io.github.flemmli97.fateubw.common.entity.summons.Pegasus;
import io.github.flemmli97.fateubw.common.entity.utils.OnProjectileHit;
import io.github.flemmli97.fateubw.common.particles.RingParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.TrailParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolderProvider;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailProvider;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.registry.FateMobEffects;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class Medusa
extends BaseServant
implements OnProjectileHit {
    protected static final EntityDataAccessor<Boolean> THROWN_DAGGER = SynchedEntityData.defineId(Medusa.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final double VIEW_ANGLE = 0.5235987901687622;
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String DUAL_REVERSE_1 = BUILDER.add("dual_reverse_1", AnimationsBuilder.definition((double)0.64).marker("attack", new double[]{0.48}).marker("step", new double[]{0.24}).marker("weapon_swing_start", new double[]{0.32}).marker("weapon_swing_end", new double[]{0.52}));
    public static final String DUAL_REVERSE_2 = BUILDER.add("dual_reverse_2", AnimationsBuilder.definition((double)0.64).marker("attack", new double[]{0.48}).marker("step", new double[]{0.24}).marker("weapon_swing_start", new double[]{0.32}).marker("weapon_swing_end", new double[]{0.52}));
    public static final String DUAL_REVERSE_3 = BUILDER.add("dual_reverse_3", AnimationsBuilder.definition((double)0.64).marker("attack", new double[]{0.48}).marker("step", new double[]{0.24}).marker("weapon_swing_start", new double[]{0.32}).marker("weapon_swing_end", new double[]{0.52}));
    public static final String DUAL_REVERSE_4 = BUILDER.add("dual_reverse_4", AnimationsBuilder.definition((double)0.64).marker("attack", new double[]{0.48}).marker("step", new double[]{0.24}).marker("weapon_swing_start", new double[]{0.32}).marker("weapon_swing_end", new double[]{0.52}));
    public static final String CHAIN_THROW = BUILDER.add("chain_throw", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.6}));
    public static final String RETRIEVE = BUILDER.add("chain_retrieve", AnimationsBuilder.definition((double)0.88).marker("retrieve", new double[]{0.56}));
    public static final String EYE = BUILDER.add("eye", AnimationsBuilder.definition((double)1.88).marker("open", new double[]{0.64}).marker("close", new double[]{1.64}));
    public static final String JUMP = BUILDER.add("jump", AnimationsBuilder.definition((double)0.48).marker("jump", new double[]{0.24}).infinite());
    public static final String LAND = BUILDER.add("land", AnimationsBuilder.definition((double)0.64).marker("attack", new double[]{0.16}));
    public static final String BELLEROPHON = BUILDER.add("bellerophon", AnimationsBuilder.definition((double)2.28).marker("attack", new double[]{0.2}));
    public static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)2.0));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Medusa> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        this.eyeAffected = null;
        return false;
    });
    private final Vector4f summonColor = new Vector4f(0.6862745f, 0.34509805f, 0.5568628f, 0.7f);
    private List<LivingEntity> eyeAffected;
    private ChainDagger dagger;
    private int throwCooldown;
    private int summonCooldown;
    private int eyeCooldown;

    private static Predicate<Medusa> meleeCondition(String anim) {
        return medusa -> {
            Pegasus pegasus;
            Entity vehicle = medusa.getVehicle();
            if (!(vehicle instanceof Pegasus) || !(pegasus = (Pegasus)vehicle).canFly()) {
                return true;
            }
            LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)medusa);
            return target == null || medusa.prepareAttackBox(anim, (Entity)target, -0.2f, false).intersects(target.getBoundingBox());
        };
    }

    public Medusa(EntityType<? extends BaseServant> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(THROWN_DAGGER, (Object)false);
    }

    public boolean daggerThrown() {
        return (Boolean)this.getEntityData().get(THROWN_DAGGER);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)FateItems.MEDUSA_DAGGER.get()));
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)FateItems.MEDUSA_DAGGER.get()));
    }

    @Override
    public boolean hasOwnWeapon() {
        return this.getMainHandItem().is((Item)FateItems.MEDUSA_DAGGER.get()) || this.getOffhandItem().is((Item)FateItems.MEDUSA_DAGGER.get());
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{DUAL_REVERSE_1}).play(BehaviourUtils.cooldownedPlay(true, 12, 20)).condition(Medusa.meleeCondition(DUAL_REVERSE_1)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(6).start(new String[]{DUAL_REVERSE_2}).play(BehaviourUtils.cooldownedPlay(true, 12, 20)).condition(entity -> Medusa.meleeCondition(DUAL_REVERSE_2).test((Medusa)entity) && !entity.getOffhandItem().isEmpty()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(6).start(new String[]{DUAL_REVERSE_3}).play(BehaviourUtils.cooldownedPlay(true, 12, 20)).condition(Medusa.meleeCondition(DUAL_REVERSE_3)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(6).start(new String[]{DUAL_REVERSE_4}).play(BehaviourUtils.cooldownedPlay(true, 12, 20)).condition(entity -> Medusa.meleeCondition(DUAL_REVERSE_4).test((Medusa)entity) && !entity.getOffhandItem().isEmpty()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(6).start(new String[]{JUMP}).play(BehaviourUtils.cooldownedPlay(false, 15, 25)).condition(entity -> !entity.isPassenger()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f)).closeEnoughDist(BehaviourUtils.closeEnough(9))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(2).start(new String[]{JUMP}).play(BehaviourUtils.cooldownedPlay(false, 15, 25)).condition(entity -> !entity.isPassenger() && BehaviourUtils.ifFurtherThan(8.0).test(entity)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f)).closeEnoughDist(BehaviourUtils.closeEnough(9))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(13).start(new String[]{CHAIN_THROW}).play(BehaviourUtils.cooldownedPlay(false, 15, 25)).condition(Medusa::canThrow).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(16.0).speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveTo()}).end(6).start(new String[]{CHAIN_THROW}).play(BehaviourUtils.cooldownedPlay(false, 15, 25)).condition(entity -> entity.canThrow() && BehaviourUtils.ifFurtherThan(6.0).test(entity)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(16.0).speedMod((m, e) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveTo()}).end(7).start(new String[]{EYE}).play(BehaviourUtils.cooldownedPlay(false, 30, 50)).condition(entity -> entity.eyeCooldown <= 0 && entity.healthBelow(0.75f)).prepare(new ExtendedBehaviour[]{new SetWalkToFront().distance(7.0f).speedMod((m, e) -> Float.valueOf(1.1f)).startCondition(medusa -> medusa.getTarget() != null && !Utils.isInView((Entity)medusa.getTarget(), (Entity)medusa, 0.5235987901687622))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack(20, 25)}).end(7).start(new String[]{EYE}).play(BehaviourUtils.cooldownedPlay(false, 30, 50)).condition(entity -> entity.eyeCooldown <= 0 && entity.healthBelow(0.5f)).prepare(new ExtendedBehaviour[]{new SetWalkToFront().distance(7.0f).speedMod((m, e) -> Float.valueOf(1.1f)).startCondition(medusa -> medusa.getTarget() != null && !Utils.isInView((Entity)medusa.getTarget(), (Entity)medusa, 0.5235987901687622))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack(20, 25)}).end(5).start(new String[]{EYE}).play(BehaviourUtils.cooldownedPlay(false, 30, 50)).condition(entity -> entity.eyeCooldown <= 0 && entity.healthBelow(0.75f) && !entity.isPassenger()).prepare(new ExtendedBehaviour[]{new SetWalkToFront().distance(7.0f).speedMod((m, e) -> Float.valueOf(1.1f)).startCondition(medusa -> medusa.getTarget() != null && !Utils.isInView((Entity)medusa.getTarget(), (Entity)medusa, 0.5235987901687622))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack(20, 25)}).end(5).start(new String[]{BELLEROPHON}).play(BehaviourUtils.cooldownedPlay(false, 20, 40)).condition(Medusa::canSummonPegasus).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(6.0).max(12.0).speedMod((m, e) -> Float.valueOf(1.3f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveTo()}).end(40).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(6, entity -> !entity.isPassenger(), new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).add(3, new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().speedMod(1.1f), BehaviourUtils.moveTo()}).add(6, Entity::isPassenger, new ExtendedBehaviour[]{new SetRandomWalkTarget(), BehaviourUtils.moveTo()}).add(3, Entity::isPassenger, new ExtendedBehaviour[]{new Idle()}).build();
    }

    public void baseTick() {
        super.baseTick();
        if (!this.level().isClientSide) {
            if (this.dagger != null) {
                if (!this.dagger.isAlive()) {
                    this.dagger = null;
                    this.getEntityData().set(THROWN_DAGGER, (Object)false);
                }
            } else {
                --this.throwCooldown;
            }
            if (!this.isPassenger()) {
                --this.summonCooldown;
            }
            --this.eyeCooldown;
        } else {
            AnimationState anim = this.getAnimationHandler().getAnimation();
            if (anim != null && anim.isAt("weapon_swing_start")) {
                this.level().addParticle((ParticleOptions)new TrailParticleData((ParticleType<TrailParticleData>)((ParticleType)FateParticles.TRAIL.get()), TrailInfo.builder(EntityWeaponTrailProvider.EntityTrailData.create(this, anim.getID(), false)).setColor(0.3137255f, 0.3137255f, 0.3137255f, 0.6f).setColor2(0.3137255f, 0.3137255f, 0.3137255f, 0.2f).setType(TrailInfo.Visual.TEXTURE, 0).build()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{CHAIN_THROW})) {
            LivingEntity target = this.getTarget();
            if (target != null) {
                this.lookAt((Entity)target, 60.0f, 30.0f);
            }
            if (anim.isAt("attack")) {
                this.throwDaggerAt(target);
            }
        } else if (anim.is(new String[]{RETRIEVE})) {
            if (anim.isAt("retrieve") && this.dagger != null) {
                this.dagger.retractHook();
                this.dagger = null;
                this.getEntityData().set(THROWN_DAGGER, (Object)false);
                BrainUtils.clearMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN);
            }
        } else if (anim.is(new String[]{EYE})) {
            LivingEntity target = this.getTarget();
            if (target != null) {
                this.lookAt((Entity)target, 60.0f, 30.0f);
            }
            if (anim.isAt("open")) {
                this.eyeAffected = new ArrayList<LivingEntity>();
                this.eyeCooldown = this.random.nextInt(150) + 150;
            }
            if (anim.isPast("open") && !anim.isPast("close")) {
                this.gorgonsEyes();
            }
        } else if (anim.is(new String[]{JUMP})) {
            LivingEntity target = this.getTarget();
            if (anim.isAt("jump")) {
                Vec3 dir;
                if (target != null) {
                    dir = target.position().subtract(this.position());
                    dir = (dir = new Vec3(dir.x(), 0.0, dir.z())).lengthSqr() > 1024.0 ? dir.normalize().scale(4.48) : dir.scale(0.14);
                } else {
                    dir = this.getViewVector(1.0f).scale(0.75);
                }
                this.setDeltaMovement(dir.x(), 0.8, dir.z());
            }
            if (anim.isPast("jump")) {
                this.fallDistance = 0.0f;
                if (anim.done(0) && this.onGround()) {
                    this.getAnimationHandler().setAnimation(this.getAnimationHandler().get(LAND), 0, -1, 0.0);
                }
                if (!(!anim.isPast(6.0) || this.getInBlockState().is(Blocks.AIR) && this.getBlockStateOn().is(Blocks.AIR))) {
                    this.getAnimationHandler().setAnimation(this.getAnimationHandler().get(LAND), 0, -1, 0.0);
                }
            }
        } else if (anim.is(new String[]{BELLEROPHON})) {
            LivingEntity target = this.getTarget();
            if (target != null && !anim.isPast(0.28)) {
                this.lookAt((Entity)target, 60.0f, 30.0f);
            }
            this.level().getEntities(EntityTypeTest.forClass(LivingEntity.class), this.getBoundingBox().inflate(12.0, 8.0, 12.0), this.targetPred).forEach(e -> {
                Vec3 dir = e.position().subtract(this.position());
                boolean none = dir.x() == 0.0 && dir.z() == 0.0;
                dir = new Vec3(none ? 1.0 : dir.x(), 0.0, dir.z()).normalize().scale(0.5);
                e.setDeltaMovement(e.getDeltaMovement().add(dir));
                e.hurtMarked = true;
            });
            if (anim.isAt("attack")) {
                this.summonPegasus();
            }
        } else {
            if (anim.isAt("step")) {
                Vec3 dir = Utils.fromRelativeVector((Entity)this, new Vec3(0.0, 0.0, 1.0)).scale(0.3);
                this.setDeltaMovement(this.getDeltaMovement().add(dir));
            }
            super.handleAttack(anim);
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, Vec3 target, double grow) {
        if (anim.is(new String[]{LAND})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.getYRot(), 0.0f, this.position());
        }
        if (this.getVehicle() != null) {
            GordiusWheel gordiusWheel;
            Entity vehicle = this.getVehicle();
            Entity entity = this.getVehicle();
            if (entity instanceof GordiusWheel && (gordiusWheel = (GordiusWheel)entity).getWheelEntity() != null) {
                vehicle = gordiusWheel.getWheelEntity();
            }
            double width = (double)vehicle.getBbWidth() * 0.5 + 1.7;
            double height = this.getY() - vehicle.getY() + (double)this.getBbHeight() + 0.2;
            AABB aabb = new AABB(-width * 0.5, -0.02, -width * 0.5, width * 0.5, height, width * 0.5);
            return new OrientedBoundingBox(aabb, vehicle.getYRot(), 0.0f, vehicle.position());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        if (anim.is(new String[]{LAND})) {
            double width = this.getBbWidth() + 3.0f * this.getScale();
            return new AABB(-width * 0.5, -0.02, -width * 0.3, width * 0.5, (double)this.getBbHeight() * 0.5, width * 0.7);
        }
        double height = this.getBbHeight();
        double width = this.getBbWidth();
        double length = 1.0f * this.getScale();
        if (anim.is(new String[]{DUAL_REVERSE_1})) {
            return new AABB(-(width += 0.9 * (double)this.getScale()) * 0.7, -0.03, 0.0, width * 0.3, height + 0.03, length += 0.6 * (double)this.getScale());
        }
        if (anim.is(new String[]{DUAL_REVERSE_2})) {
            return new AABB(-(width += 0.9 * (double)this.getScale()) * 0.3, -0.03, 0.0, width * 0.7, height + 0.03, length += 0.6 * (double)this.getScale());
        }
        if (anim.is(new String[]{DUAL_REVERSE_3, DUAL_REVERSE_4})) {
            width += 0.8 * (double)this.getScale();
            length += 0.7 * (double)this.getScale();
        }
        return new AABB(-width * 0.5, -0.03, 0.0, width * 0.5, height + 0.03, length);
    }

    public AnimationHandler<Medusa> getAnimationHandler() {
        return this.animationHandler;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    @Override
    public boolean hurt(DamageSource damageSource, float damage) {
        if (this.getAnimationHandler().isCurrent(new String[]{BELLEROPHON})) {
            return false;
        }
        if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(damageSource, damage);
        }
        if (this.getVehicle() != null) {
            this.getVehicle().hurt(damageSource, damage *= 0.5f);
        }
        return super.hurt(damageSource, damage);
    }

    @Override
    public boolean nobelPhantasmCheck() {
        return this.healthBelow(0.5f) && super.nobelPhantasmCheck();
    }

    public void throwDaggerAt(@Nullable LivingEntity target) {
        if (!this.level().isClientSide) {
            ChainDagger dagger = new ChainDagger(this.level(), (LivingEntity)this, true);
            if (target == null) {
                dagger.shoot((Entity)this, this.getXRot(), this.getYRot(), 0.0f, 3.0f, 0.0f);
            } else {
                dagger.shootAtEntity((Entity)target, 3.0f, 0.0f);
            }
            this.level().addFreshEntity((Entity)dagger);
            this.dagger = dagger;
            this.throwCooldown = this.random.nextInt(50) + 45;
            this.getEntityData().set(THROWN_DAGGER, (Object)true);
        }
    }

    public void gorgonsEyes() {
        if (this.eyeAffected == null) {
            this.eyeAffected = new ArrayList<LivingEntity>();
        }
        List entities = this.level().getEntities(EntityTypeTest.forClass(LivingEntity.class), this.getBoundingBox().inflate(32.0), e -> e == this.getTarget() || this.targetPred.test(e));
        boolean success = false;
        for (LivingEntity entity : entities) {
            if (this.eyeAffected.contains(entity) || !Utils.isInView((Entity)entity, (Entity)this, 0.5235987901687622)) continue;
            this.eyeAffected.add(entity);
            MobEffectInstance eff = entity.getEffect(FateMobEffects.PETRIFICATION.asHolder());
            int amplifier = 0;
            if (eff != null) {
                if (eff.getAmplifier() >= PetrificationEffect.MAX_PROGRESS) continue;
                amplifier = eff.getAmplifier() + 1;
            }
            entity.addEffect(new MobEffectInstance(FateMobEffects.PETRIFICATION.asHolder(), CommonConfig.petrificationDuration, amplifier));
            success = true;
        }
        if (success) {
            AdvancedParticleContainer.make((ParticleOptions)new RingParticleData(this.getYHeadRot(), 0.0f)).addData((AdvancedParticleData)new ScaleData(1.0f, 4.0f, 8)).addData((AdvancedParticleData)new ColorData(new Vector4f(0.49019608f, 0.047058824f, 0.49803922f, 1.0f), Optional.of(new Vector4f(0.49019608f, 0.047058824f, 0.49803922f, 0.2f)), 10)).addData((AdvancedParticleData)new ParticleMetaData(10, false, 0.0f)).add(this.level(), this.getX(), this.getEyeY(), this.getZ());
            this.playSound(SoundEvents.TOTEM_USE, 1.0f, this.getRandom().nextFloat() * 0.2f + 1.1f);
        }
    }

    protected boolean canSummonPegasus() {
        return !this.isPassenger() && this.canUseNobelPhantasm() && this.summonCooldown <= 0;
    }

    public void summonPegasus() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.attemptUseNobelPhantasm()) {
                return;
            }
            Pegasus peg = (Pegasus)((EntityType)FateEntities.PEGASUS.get()).create(serverLevel, null, this.blockPosition(), MobSpawnType.MOB_SUMMONED, false, false);
            peg.setPos(this.position());
            peg.setYRot(this.getYRot());
            peg.yRotO = this.getYRot();
            peg.yHeadRot = this.getYRot();
            peg.yHeadRotO = this.getYRot();
            peg.yBodyRot = this.getYRot();
            peg.yBodyRotO = this.getYRot();
            this.level().addFreshEntity((Entity)peg);
            this.startRiding((Entity)peg, true);
            this.revealServant();
            this.summonCooldown = 150 + this.getRandom().nextInt(100);
        }
    }

    @Override
    protected String getSummonAnimation() {
        return SUMMON;
    }

    @Override
    public Vector4f summonColor() {
        return this.summonColor;
    }

    public boolean canThrow() {
        return this.dagger == null && this.throwCooldown <= 0;
    }

    @Override
    public void onProjectileHit(Entity entity) {
        if (entity instanceof ChainDagger) {
            this.getAnimationHandler().setAnimation(RETRIEVE);
        }
    }

    @Override
    public EntityWeaponTrailHolderProvider.WeaponTrail weaponTrailEdge(boolean left) {
        return new EntityWeaponTrailHolderProvider.WeaponTrail(new Vector4f(0.0f, 0.0f, -0.5f, 1.0f), new Vector4f(0.0f, 0.0f, -0.8f, 1.0f));
    }
}

