/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant;

import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.network.S2CAttackDebug;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.TrailParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.ParticlePositionProvider;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolderProvider;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailProvider;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.utils.MathsHelper;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.LeapInDirection;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.SinMotionData;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.joml.Vector4f;

public class Sasaki
extends BaseServant {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String TWO_HAND_1 = BUILDER.add("two_hand_1", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.88}).marker("step", new double[]{0.6}).marker("weapon_swing_start", new double[]{0.68}).marker("weapon_swing_end", new double[]{0.92}));
    public static final String TWO_HAND_2 = BUILDER.add("two_hand_2", AnimationsBuilder.definition((double)0.96).marker("attack", new double[]{0.84}).marker("step", new double[]{0.56}).marker("weapon_swing_start", new double[]{0.6}).marker("weapon_swing_end", new double[]{0.88}));
    public static final String TWO_HAND_3 = BUILDER.add("two_hand_3", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.8}).marker("step", new double[]{0.52}).marker("weapon_swing_start", new double[]{0.6}).marker("weapon_swing_end", new double[]{0.84}));
    public static final String TWO_HAND_4 = BUILDER.add("two_hand_4", AnimationsBuilder.definition((double)0.96).marker("attack", new double[]{0.84}).marker("step", new double[]{0.56}).marker("weapon_swing_start", new double[]{0.6}).marker("weapon_swing_end", new double[]{0.88}));
    public static final String TWO_HAND_5 = BUILDER.add("two_hand_5", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.8}).marker("step", new double[]{0.52}).marker("weapon_swing_start", new double[]{0.6}).marker("weapon_swing_end", new double[]{0.84}));
    public static final String TWO_HAND_6 = BUILDER.add("two_hand_6", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.8}).marker("step", new double[]{0.52}).marker("weapon_swing_start", new double[]{0.6}).marker("weapon_swing_end", new double[]{0.84}));
    public static final String TWO_HAND_7 = BUILDER.add("two_hand_7", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.8}).marker("step", new double[]{0.52}).marker("weapon_swing_start", new double[]{0.6}).marker("weapon_swing_end", new double[]{0.84}));
    public static final String ONE_HAND_1 = BUILDER.add("one_hand_1", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.76}).marker("weapon_swing_start", new double[]{0.6}).marker("weapon_swing_end", new double[]{0.8}));
    public static final String KATANA_1 = BUILDER.add("katana_1", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.72}).marker("step", new double[]{0.64}));
    private static final String TSUBAME_GAESHI = BUILDER.add("tsubame_gaeshi", AnimationsBuilder.definition((double)2.16).marker("attack_prepare", new double[]{1.24}).marker("attack", new double[]{1.36}).marker("particle", new double[]{1.36}));
    public static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)4.0));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Sasaki> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private Vec3 hikenPos;
    private boolean hiken;

    public Sasaki(EntityType<? extends BaseServant> entityType, Level level) {
        super(entityType, level);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)FateItems.MONOHOSHI_ZAO.get()));
    }

    @Override
    public boolean hasOwnWeapon() {
        return this.getMainHandItem().is((Item)FateItems.MONOHOSHI_ZAO.get());
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return AttackBehaviourBuilder.create().start(BehaviourUtils.of(AnimationPlayHolder.builder((String)TWO_HAND_1).start(TWO_HAND_2, 2, 0.52f, 3).start(TWO_HAND_2, 2, 0.52f, 1).chain(TWO_HAND_6, 2, 0.52f).start(TWO_HAND_3, 2, 0.52f, 1).chain(TWO_HAND_4, 2, 0.52f).start(TWO_HAND_3, 2, 0.52f, 1).chain(ONE_HAND_1, 2, 0.52f).start(TWO_HAND_5, 2, 0.52f, 3).start(TWO_HAND_5, 2, 0.52f, 1).chain(TWO_HAND_7, 2, 0.52f).build())).play(BehaviourUtils.cooldownedPlay(true, 18, 35)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(10).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)TWO_HAND_2).start(TWO_HAND_1, 2, 0.52f, 3).start(TWO_HAND_1, 2, 0.52f, 1).chain(TWO_HAND_3, 2, 0.52f).start(TWO_HAND_1, 2, 0.52f, 1).chain(TWO_HAND_5, 2, 0.52f).start(TWO_HAND_4, 2, 0.52f, 3).start(TWO_HAND_4, 2, 0.52f, 1).chain(TWO_HAND_5, 2, 0.52f).start(TWO_HAND_7, 2, 0.52f, 3).build())).play(BehaviourUtils.cooldownedPlay(true, 18, 35)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(10).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)TWO_HAND_3).start(TWO_HAND_6, 2, 0.52f, 5).start(TWO_HAND_6, 2, 0.52f, 3).chain(TWO_HAND_2, 2, 0.52f).build())).play(BehaviourUtils.cooldownedPlay(true, 18, 35)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(10).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)TWO_HAND_4).start(TWO_HAND_5, 2, 0.52f, 5).start(TWO_HAND_5, 2, 0.52f, 3).chain(TWO_HAND_1, 2, 0.52f).build())).play(BehaviourUtils.cooldownedPlay(true, 18, 35)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(10).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)KATANA_1).start(TWO_HAND_5, 2, 0.52f, 2).start(ONE_HAND_1, 2, 0.52f, 1).build())).play(BehaviourUtils.cooldownedPlay(true, 18, 35)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(10).start(new String[]{TSUBAME_GAESHI}).play(BehaviourUtils.cooldownedPlay(false, 18, 35)).condition(BaseServant::canUseNobelPhantasm).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(10.0).speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(50).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(5, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).add(3, new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().radius(5.0), BehaviourUtils.moveTo()}).add(2, BehaviourUtils.ifCloserThan(8.0), new ExtendedBehaviour[]{new LeapInDirection().horizontalDirection((owner, target) -> LeapInDirection.createBackwardsVec((Vec3)owner.position(), (Vec3)target.position()).scale((double)1.3f)).whenStarting(e -> BehaviourUtils.modifyExpiringMemory((Mob)e, MemoryModuleType.ATTACK_COOLING_DOWN, -15)), new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).build();
    }

    public void baseTick() {
        AnimationState anim;
        super.baseTick();
        if (this.level().isClientSide && (anim = this.getAnimationHandler().getAnimation()) != null && anim.isAt("weapon_swing_start")) {
            this.level().addParticle((ParticleOptions)new TrailParticleData((ParticleType<TrailParticleData>)((ParticleType)FateParticles.TRAIL.get()), TrailInfo.builder(EntityWeaponTrailProvider.EntityTrailData.create(this, anim.getID(), false)).setColor(0.14509805f, 0.14509805f, 0.34509805f, 0.4f).setColor2(0.70980394f, 0.7411765f, 0.80784315f, 0.1f).setWidth(1.0f).setWidth2(1.0f).setType(TrailInfo.Visual.TEXTURE, 3).build()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{TSUBAME_GAESHI})) {
            if (!anim.isPast("attack_prepare") && this.getTarget() != null) {
                this.lookAt((Entity)this.getTarget(), 60.0f, 90.0f);
            }
            if (anim.isAt("attack_prepare")) {
                Vec3 dir;
                if (this.getTarget() != null) {
                    dir = this.getTarget().position().subtract(this.position());
                    if ((dir = dir.add(dir.normalize().scale(3.0))).lengthSqr() > 144.0) {
                        dir = dir.normalize().scale(12.0);
                    }
                } else {
                    Vec3 look = Vec3.directionFromRotation((float)0.0f, (float)this.getYHeadRot()).scale(11.0);
                    BlockHitResult res = this.level().clip(new ClipContext(this.getEyePosition(), this.getEyePosition().add(look), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                    dir = res.getLocation().subtract(this.getEyePosition());
                }
                this.hikenPos = this.position().add(dir);
            }
            if (anim.isAt("attack")) {
                this.tsubameSlash();
            }
        } else {
            if (anim.isAt("step")) {
                Vec3 dir = Utils.fromRelativeVector((Entity)this, new Vec3(0.0, 0.0, 1.0)).scale(0.4);
                this.setDeltaMovement(this.getDeltaMovement().add(dir));
            }
            super.handleAttack(anim);
        }
    }

    public void tsubameSlash() {
        if (this.hikenPos == null) {
            return;
        }
        Vec3 dir = this.hikenPos.subtract(this.position());
        float yRot = MathsHelper.YRotFrom(dir);
        OrientedBoundingBox obb = new OrientedBoundingBox(new AABB((double)this.getBbWidth() * 0.5 - 1.5, -0.3, 0.0, (double)this.getBbWidth() * 0.5 + 1.5, (double)this.getBbHeight() + 0.3, dir.length() + 2.0), yRot, 0.0f, this.position());
        S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)this);
        boolean damage = false;
        this.hiken = true;
        for (LivingEntity entity2 : this.level().getEntitiesOfClass(LivingEntity.class, obb.getEncompassingBox(), entity -> this.targetPred.test(entity) && obb.intersects(entity.getBoundingBox()))) {
            if (this.doHurtTarget((Entity)entity2) && !damage) {
                damage = true;
            }
            if (this.doHurtTarget((Entity)entity2) && !damage) {
                damage = true;
            }
            if (!this.doHurtTarget((Entity)entity2) || damage) continue;
            damage = true;
        }
        this.hiken = false;
        dir = dir.lengthSqr() < 64.0 ? dir.normalize().scale(5.0) : dir.scale(0.7);
        this.tsubameParticles(this.position().add(0.0, (double)this.getEyeHeight(), 0.0).add(dir));
        if (damage) {
            this.level().playSound(null, (Entity)this, SoundEvents.PLAYER_ATTACK_CRIT, this.getSoundSource(), 0.7f, 0.9f);
        }
        this.teleportTo(this.hikenPos.x(), this.hikenPos.y(), this.hikenPos.z());
    }

    private void tsubameParticles(Vec3 at) {
        int duration = 6;
        Vec3 basePos = new Vec3(3.0, 0.0, -1.0);
        Vec3 baseDir = new Vec3(-3.5, 0.0, 2.0).scale((double)(1.0f / (float)duration));
        Vec3 baseSweer = new Vec3(0.0, 0.0, 0.4);
        Vec3 baseNormal = baseDir.add(0.0, 1.0, 0.0).normalize().scale(0.4).yRot(90.0f);
        float yRot = -this.getYRot() * ((float)Math.PI / 180);
        float[] angles = new float[]{-45.0f, 45.0f, -135.0f};
        for (int i = 0; i < 3; ++i) {
            float angle = angles[i] * ((float)Math.PI / 180);
            Vec3 pos = basePos.zRot(angle).yRot(yRot);
            Vec3 dir = baseDir.zRot(angle).yRot(yRot);
            Vec3 sweer = baseSweer.zRot(angle).yRot(yRot);
            Vec3 normal = baseNormal.zRot(angle).yRot(yRot);
            AdvancedParticleContainer.make((ParticleOptions)new TrailParticleData((ParticleType<TrailParticleData>)((ParticleType)FateParticles.TRAIL.get()), TrailInfo.builder(new ParticlePositionProvider.ParticlePositionData(normal, duration)).setColor(0.28235295f, 0.050980393f, 0.6313726f, 0.7f).setColor2(0.57254905f, 0.4117647f, 0.8117647f, 0.4f).setWidth(0.4f).setWidth2(0.2f).setType(TrailInfo.Visual.TEXTURE, 0).build())).addData((AdvancedParticleData)new MotionData(dir, true, false)).addData((AdvancedParticleData)new SinMotionData(sweer, (float)duration * 0.85f, (float)duration, true)).addData((AdvancedParticleData)new ParticleMetaData(duration, false, 0.0f)).add(this.level(), at.x() + pos.x(), at.y() + pos.y(), at.z() + pos.z());
        }
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double height = this.getBbHeight();
        double width = this.getBbWidth();
        double length = 1.0f * this.getScale();
        if (anim.is(new String[]{TWO_HAND_1})) {
            return new AABB(-(width += 2.8 * (double)this.getScale()) * 0.8, -0.03, 0.0, width * 0.2, height + 0.03, length += 1.4 * (double)this.getScale());
        }
        if (anim.is(new String[]{TWO_HAND_2})) {
            return new AABB(-(width += 2.8 * (double)this.getScale()) * 0.2, -0.03, 0.0, width * 0.8, height + 0.03, length += 1.4 * (double)this.getScale());
        }
        if (anim.is(new String[]{TWO_HAND_3})) {
            return new AABB(-(width += 2.8 * (double)this.getScale()) * 0.4, -0.03, 0.0, width * 0.6, height + 0.03, length += 1.4 * (double)this.getScale());
        }
        if (anim.is(new String[]{TWO_HAND_4})) {
            return new AABB(-(width += 2.4 * (double)this.getScale()) * 0.4, -0.03, 0.0, width * 0.6, height + 0.03, length += 1.4 * (double)this.getScale());
        }
        if (anim.is(new String[]{TWO_HAND_5})) {
            return new AABB(-(width += 2.4 * (double)this.getScale()) * 0.3, -0.03, 0.0, width * 0.7, height + 0.03, length += 1.4 * (double)this.getScale());
        }
        if (anim.is(new String[]{TWO_HAND_6})) {
            return new AABB(-(width += 2.8 * (double)this.getScale()) * 0.8, -0.03, 0.0, width * 0.2, height + 0.03, length += 1.4 * (double)this.getScale());
        }
        if (anim.is(new String[]{TWO_HAND_7})) {
            width += 0.5 * (double)this.getScale();
            height += 2.1 * (double)this.getScale();
            length += 1.6 * (double)this.getScale();
        }
        if (anim.is(new String[]{ONE_HAND_1})) {
            width += 3.4 * (double)this.getScale();
            length += 1.7 * (double)this.getScale();
        }
        if (anim.is(new String[]{KATANA_1})) {
            width += 0.5 * (double)this.getScale();
            length += 1.7 * (double)this.getScale();
        }
        return new AABB(-width * 0.5, -0.03, 0.0, width * 0.5, height + 0.03, length);
    }

    @Override
    protected DamageSource damageSourceAttack(Entity target) {
        return this.hiken ? FateDamageTypes.direct(FateDamageTypes.TSUBAME, (Entity)this) : super.damageSourceAttack(target);
    }

    public AnimationHandler<Sasaki> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean hurt(DamageSource damageSource, float damage) {
        return !this.getAnimationHandler().isCurrent(new String[]{TSUBAME_GAESHI}) && super.hurt(damageSource, damage);
    }

    @Override
    public boolean nobelPhantasmCheck() {
        return this.healthBelow(0.7f) && super.nobelPhantasmCheck();
    }

    @Override
    public double getSummonProgress(float partialTicks) {
        double prog = super.getSummonProgress(partialTicks);
        return prog >= 0.0 ? Mth.clamp((double)(prog * 2.0), (double)0.0, (double)1.0) : prog;
    }

    @Override
    protected String getSummonAnimation() {
        return SUMMON;
    }

    @Override
    public EntityWeaponTrailHolderProvider.WeaponTrail weaponTrailEdge(boolean left) {
        return new EntityWeaponTrailHolderProvider.WeaponTrail(new Vector4f(0.0f, 0.0f, -1.2f, 1.0f), new Vector4f(0.0f, 0.0f, -1.8f, 1.0f));
    }
}

