/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant.lancelot;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.fateubw.api.datapack.ServantExtraData;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.HeldEquipmentHandler;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.servant.lancelot.LancelotAttackAI;
import io.github.flemmli97.fateubw.common.entity.servant.lancelot.LancelotInventory;
import io.github.flemmli97.fateubw.common.entity.servant.lancelot.LancelotUseHandler;
import io.github.flemmli97.fateubw.common.lib.FateTags;
import io.github.flemmli97.fateubw.common.network.S2CScreenShake;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.TrailParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolderProvider;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailProvider;
import io.github.flemmli97.fateubw.common.registry.FateDataComponents;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.utils.MathsHelper;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.LeapInDirection;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.utils.ItemUtils;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.joml.Vector4f;

public class Lancelot
extends BaseServant {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String TWO_HAND_1 = BUILDER.add("two_hand_1", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.88}).marker("step", new double[]{0.6}).marker("weapon_swing_start", new double[]{0.6}).marker("weapon_swing_end", new double[]{0.92}));
    public static final String TWO_HAND_2 = BUILDER.add("two_hand_2", AnimationsBuilder.definition((double)0.96).marker("attack", new double[]{0.84}).marker("step", new double[]{0.52}).marker("weapon_swing_start", new double[]{0.6}).marker("weapon_swing_end", new double[]{0.88}));
    public static final String TWO_HAND_3 = BUILDER.add("two_hand_3", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.8}).marker("step", new double[]{0.52}).marker("weapon_swing_start", new double[]{0.6}).marker("weapon_swing_end", new double[]{0.84}));
    public static final String TWO_HAND_4 = BUILDER.add("two_hand_4", AnimationsBuilder.definition((double)0.96).marker("attack", new double[]{0.84}).marker("step", new double[]{0.52}).marker("weapon_swing_start", new double[]{0.6}).marker("weapon_swing_end", new double[]{0.88}));
    public static final String ONE_HAND_1 = BUILDER.add("one_hand_1", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.56}).marker("step", new double[]{0.32}).marker("weapon_swing_start", new double[]{0.4}).marker("weapon_swing_end", new double[]{0.6}));
    public static final String STAB_1 = BUILDER.add("stab_1", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.68}));
    public static final String JUMP = BUILDER.add("jump", AnimationsBuilder.definition((double)0.48).marker("jump", new double[]{0.28}).infinite());
    public static final String JUMP_LAND = BUILDER.add("jump_land", AnimationsBuilder.definition((double)1.08).marker("attack", new double[]{0.2}));
    public static final String TRIDENT = BUILDER.add("trident", AnimationsBuilder.definition((double)1.52).marker("attack", new double[]{1.0}));
    public static final String BOW = BUILDER.add("bow", AnimationsBuilder.definition((double)1.28).marker("use_start", new double[]{0.24}).marker("attack", new double[]{1.08}));
    public static final String CROSSBOW = BUILDER.add("crossbow", AnimationsBuilder.definition((double)2.2).marker("use_start", new double[]{0.32}).marker("attack", new double[]{1.88}));
    public static final String GUN = BUILDER.add("gun", AnimationsBuilder.definition((double)3.28).marker("attack_start", new double[]{1.0}).marker("attack_end", new double[]{2.16}));
    public static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)2.0));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Lancelot> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (anim != null) {
            this.swapWithInventory(anim.animation());
        } else {
            this.swapWithInventory(null);
        }
        return false;
    });
    private final Vector4f summonColor = new Vector4f(0.10980392f, 0.10980392f, 0.12941177f, 0.7f);
    public final HeldEquipmentHandler heldEquipmentHandler = new HeldEquipmentHandler((LivingEntity)this, new ItemStack((ItemLike)FateItems.ARONDIGHT.get()), null);
    private final LancelotInventory inventory = new LancelotInventory((LivingEntity)this);
    private final SimpleContainer swapped = new SimpleContainer(1);
    private int pickupDelay;

    public Lancelot(EntityType<? extends Lancelot> entityType, Level level) {
        super(entityType, level);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WOODEN_SWORD));
    }

    @Override
    public boolean hasOwnWeapon() {
        return this.getMainHandItem().is((Item)FateItems.ARONDIGHT.get());
    }

    @Override
    public HeldEquipmentHandler getEquipmentHandler() {
        return this.heldEquipmentHandler;
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return AttackBehaviourBuilder.create().start(BehaviourUtils.of(AnimationPlayHolder.builder((String)TWO_HAND_1).start(TWO_HAND_2, 2, 0.24f, 1).start(TWO_HAND_3, 2, 0.24f, 1).chainChance(0.5f).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 30)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(5).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)TWO_HAND_2).start(TWO_HAND_1, 2, 0.24f, 1).chain(ONE_HAND_1).chainChance(0.5f).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 30)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(5).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)TWO_HAND_4).start(TWO_HAND_2, 2, 0.24f, 1).start(TWO_HAND_3, 2, 0.24f, 1).chainChance(0.5f).build())).play(BehaviourUtils.cooldownedPlay(true, 20, 30)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(5).start(new String[]{ONE_HAND_1}).play(BehaviourUtils.cooldownedPlay(true, 20, 30)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(5).start(new String[]{STAB_1}).play(BehaviourUtils.cooldownedPlay(true, 20, 30)).condition(entity -> entity.canUseAttack(STAB_1)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(2.0).max(4.0)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveTo()}).end(5).start(new String[]{JUMP}).play(BehaviourUtils.cooldownedPlay(false, 20, 30)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f)).closeEnoughDist(BehaviourUtils.closeEnough(9))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(2).start(new String[]{JUMP}).play(BehaviourUtils.cooldownedPlay(false, 20, 25)).condition(BehaviourUtils.ifFurtherThan(8.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((m, e) -> Float.valueOf(1.1f)).closeEnoughDist(BehaviourUtils.closeEnough(9))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(12).start(new String[]{BOW}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(11.0), 25, 35)).condition(entity -> entity.canUseAttack(BOW)).prepare(new ExtendedBehaviour[]{new LeapInDirection().shouldLeap((owner, target) -> owner.distanceToSqr((Entity)target) < 49.0).horizontalDirection((owner, target) -> LeapInDirection.createBackwardsVec((Vec3)owner.position(), (Vec3)target.position()).scale((double)1.3f))}).end(3).start(new String[]{BOW}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(11.0), 25, 35)).condition(entity -> entity.canUseAttack(BOW)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(10.0).speedMod(1.1f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(2).start(new String[]{CROSSBOW}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(15.0), 25, 35)).condition(entity -> entity.canUseAttack(CROSSBOW)).prepare(new ExtendedBehaviour[]{new LeapInDirection().shouldLeap((owner, target) -> owner.distanceToSqr((Entity)target) < 49.0).horizontalDirection((owner, target) -> LeapInDirection.createBackwardsVec((Vec3)owner.position(), (Vec3)target.position()).scale((double)1.3f))}).end(3).start(new String[]{CROSSBOW}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(15.0), 25, 35)).condition(entity -> entity.canUseAttack(CROSSBOW)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(10.0).speedMod(1.1f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(2).start(new String[]{TRIDENT}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(11.0), 25, 35)).condition(entity -> entity.canUseAttack(TRIDENT)).prepare(new ExtendedBehaviour[]{new LeapInDirection().shouldLeap((owner, target) -> owner.distanceToSqr((Entity)target) < 49.0).horizontalDirection((owner, target) -> LeapInDirection.createBackwardsVec((Vec3)owner.position(), (Vec3)target.position()).scale((double)1.3f))}).end(3).start(new String[]{TRIDENT}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(11.0), 25, 35)).condition(entity -> entity.canUseAttack(TRIDENT)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(10.0).speedMod(1.1f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(2).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(6, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).add(3, new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().speedMod(1.1f).radius(7.0), BehaviourUtils.moveTo()}).build();
    }

    public void baseTick() {
        super.baseTick();
        --this.pickupDelay;
        if (this.level().isClientSide) {
            for (int x = 0; x < 2; ++x) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.random.nextDouble() * (double)this.getBbHeight(), this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02);
            }
            AnimationState anim = this.getAnimationHandler().getAnimation();
            if (anim != null && anim.isAt("weapon_swing_start")) {
                this.level().addParticle((ParticleOptions)new TrailParticleData((ParticleType<TrailParticleData>)((ParticleType)FateParticles.TRAIL.get()), TrailInfo.builder(EntityWeaponTrailProvider.EntityTrailData.create(this, anim.getID(), false)).setColor(0.0f, 0.0f, 0.0f, 0.5f).setColor2(0.2f, 0.0f, 0.0f, 0.5f).setType(TrailInfo.Visual.SOLID, 0).build()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        } else {
            this.heldEquipmentHandler.setInUse(this.healthBelow(0.5f) && !this.inventory.swapped());
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("Inventory", (Tag)this.inventory.save((HolderLookup.Provider)this.registryAccess()));
        tag.put("Swapped", (Tag)this.swapped.createTag((HolderLookup.Provider)this.registryAccess()));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.inventory.load(tag.getCompound("Inventory"), (HolderLookup.Provider)this.registryAccess());
        this.swapped.fromTag(tag.getList("Swapped", 10), (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{JUMP})) {
            LivingEntity target = this.getTarget();
            if (anim.isAt("jump")) {
                Vec3 dir;
                if (target != null) {
                    dir = target.position().subtract(this.position());
                    dir = (dir = new Vec3(dir.x(), 0.0, dir.z())).lengthSqr() > 676.0 ? dir.normalize().scale(3.6400000000000006) : dir.scale(0.14);
                } else {
                    dir = this.getViewVector(1.0f).scale(0.75);
                }
                this.setDeltaMovement(dir.x(), 1.0, dir.z());
            }
            if (anim.isPast("jump")) {
                this.fallDistance = 0.0f;
                if (anim.done(0) && this.onGround()) {
                    this.getAnimationHandler().setAnimation(this.getAnimationHandler().get(JUMP_LAND), 0, -1, 0.0);
                }
                if (!(!anim.isPast(6.0) || this.getInBlockState().is(Blocks.AIR) && this.getBlockStateOn().is(Blocks.AIR))) {
                    this.getAnimationHandler().setAnimation(this.getAnimationHandler().get(JUMP_LAND), 0, -1, 0.0);
                }
            }
        } else if (anim.is(new String[]{CROSSBOW, BOW, TRIDENT})) {
            InteractionHand hand;
            Pair<ResourceLocation, LancelotUseHandler> handler;
            LivingEntity target = this.getTarget();
            if (anim.isAt("use_start") && (handler = LancelotAttackAI.getFor(this.getItemInHand(hand = this.toUseHand()))) != null) {
                ((LancelotUseHandler)handler.getSecond()).startUse((LivingEntity)this, target, hand);
            }
            if (!anim.isPast("attack")) {
                this.setTargetPositionFromAttackTarget();
            }
            if (anim.isAt("attack") && (target == null || this.getSensing().hasLineOfSight((Entity)target)) && (handler = LancelotAttackAI.getFor(this.getItemInHand(hand = this.toUseHand()))) != null) {
                this.useItemRemaining = 1;
                ((LancelotUseHandler)handler.getSecond()).use((LivingEntity)this, target, this.getUsedItemHand());
            }
        } else {
            if (anim.isAt("step")) {
                Vec3 dir = Utils.fromRelativeVector((Entity)this, new Vec3(0.0, 0.0, 1.0)).scale(0.3);
                this.setDeltaMovement(this.getDeltaMovement().add(dir));
            }
            if (anim.isAt("attack") && anim.is(new String[]{JUMP_LAND})) {
                S2CScreenShake.sendAround((Entity)this, 10.0, 8, 3.0f);
                this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.0f, 0.9f);
            }
            super.handleAttack(anim);
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, Vec3 target, double grow) {
        if (anim.is(new String[]{JUMP_LAND})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.getYRot(), 0.0f, this.position());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        if (anim.is(new String[]{JUMP_LAND})) {
            double width = this.getBbWidth() + 4.0f * this.getScale();
            return new AABB(-width * 0.5, -0.02, -width * 0.3, width * 0.5, (double)this.getBbHeight() * 0.5, width * 0.7);
        }
        double height = this.getBbHeight();
        double width = this.getBbWidth();
        double length = 1.0f * this.getScale();
        if (anim.is(new String[]{TWO_HAND_1})) {
            return new AABB(-(width += 2.4 * (double)this.getScale()) * 0.6, -0.03, 0.0, width * 0.4, height + 0.03, length += (double)(1.0f * this.getScale()));
        }
        if (anim.is(new String[]{TWO_HAND_2})) {
            return new AABB(-(width += 2.4 * (double)this.getScale()) * 0.4, -0.03, 0.0, width * 0.6, height + 0.03, length += (double)(1.0f * this.getScale()));
        }
        if (anim.is(new String[]{TWO_HAND_3, TWO_HAND_4})) {
            width += 1.9 * (double)this.getScale();
            length += (double)(1.0f * this.getScale());
        }
        if (anim.is(new String[]{ONE_HAND_1})) {
            width += 1.5 * (double)this.getScale();
            length += 0.75 * (double)this.getScale();
        }
        if (anim.is(new String[]{STAB_1})) {
            width += 0.3 * (double)this.getScale();
            length += (double)(2.0f * this.getScale());
        }
        return new AABB(-width * 0.5, -0.03, 0.0, width * 0.5, height + 0.03, length);
    }

    public AnimationHandler<Lancelot> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean hurt(DamageSource damageSource, float damage) {
        if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(damageSource, damage);
        }
        if (this.isPassenger()) {
            return this.getVehicle().hurt(damageSource, damage);
        }
        if (!damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !this.level().isClientSide && damageSource.is(DamageTypeTags.IS_PROJECTILE) && !damageSource.is(DamageTypeTags.BYPASSES_ARMOR) && this.getRandom().nextFloat() < this.props().getConfig(ServantExtraData.LANCELOT_REFLECT_CHANCE).floatValue() && damageSource.getDirectEntity() != null && !(damageSource.getDirectEntity() instanceof LivingEntity)) {
            this.reflectProjectile(damageSource.getDirectEntity());
            this.level().playSound(null, this.blockPosition(), SoundEvents.ANVIL_PLACE, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return false;
        }
        return super.hurt(damageSource, damage);
    }

    public boolean canPickUpLoot() {
        return true;
    }

    protected void pickUpItem(ItemEntity itemEntity) {
        if (itemEntity.hasPickUpDelay()) {
            return;
        }
        super.pickUpItem(itemEntity);
    }

    public ItemStack equipItemIfPossible(ItemStack stack) {
        if (this.pickupDelay > 0) {
            return ItemStack.EMPTY;
        }
        ItemStack res = this.inventory.insert(stack);
        if (res != null) {
            if (!res.isEmpty()) {
                this.spawnAtLocation(res);
            }
            return stack;
        }
        Equipable equipable = Equipable.get((ItemStack)stack);
        EquipmentSlot equipmentSlot = equipable != null ? equipable.getEquipmentSlot() : EquipmentSlot.MAINHAND;
        ItemStack current = this.getItemBySlot(equipmentSlot);
        if (current.getItem() == FateItems.ARONDIGHT.get() && equipmentSlot == EquipmentSlot.MAINHAND) {
            return ItemStack.EMPTY;
        }
        if (this.canHoldItem(stack) && this.canReplaceCurrentItem(stack, current)) {
            if (!current.isEmpty()) {
                this.spawnAtLocation(current);
            }
            this.setItemSlotAndDropWhenKilled(equipmentSlot, stack);
            this.revealServant();
            return stack;
        }
        return ItemStack.EMPTY;
    }

    protected boolean canReplaceCurrentItem(ItemStack candidate, ItemStack existing) {
        return ItemUtils.isItemBetter((LivingEntity)this, null, (ItemStack)candidate, (ItemStack)existing);
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
        if (stack.getItem() != FateItems.ARONDIGHT.get()) {
            stack.set((DataComponentType)FateDataComponents.CORRUPTED_ITEM.get(), (Object)Unit.INSTANCE);
        }
        super.setItemSlot(slot, stack);
    }

    protected void dropEquipment() {
        super.dropEquipment();
        for (ItemStack stack : this.inventory) {
            this.spawnAtLocation(stack);
        }
        this.inventory.clearContent();
    }

    public ItemEntity spawnAtLocation(ItemStack stack) {
        stack.remove((DataComponentType)FateDataComponents.CORRUPTED_ITEM.get());
        return super.spawnAtLocation(stack);
    }

    @Override
    public boolean nobelPhantasmCheck() {
        return this.healthBelow(0.5f) && super.nobelPhantasmCheck();
    }

    public boolean canUseAttack(String animation) {
        if (animation.equals(TRIDENT)) {
            return this.checkHands(s -> LancelotAttackAI.get(LancelotAttackAI.TRIDENT).matches((ItemStack)s)) || !this.inventory.get(LancelotAttackAI.TRIDENT).isEmpty();
        }
        if (animation.equals(BOW)) {
            return this.checkHands(s -> LancelotAttackAI.get(LancelotAttackAI.BOW).matches((ItemStack)s)) || !this.inventory.get(LancelotAttackAI.BOW).isEmpty();
        }
        if (animation.equals(CROSSBOW)) {
            return this.checkHands(s -> LancelotAttackAI.get(LancelotAttackAI.CROSSBOW).matches((ItemStack)s)) || !this.inventory.get(LancelotAttackAI.CROSSBOW).isEmpty();
        }
        if (animation.equals(STAB_1)) {
            return this.checkHands(s -> s.is(FateTags.Items.SPEARS)) || !this.inventory.get(LancelotAttackAI.TRIDENT).isEmpty() || !this.inventory.get(LancelotInventory.SPEAR).isEmpty();
        }
        return !this.getMainHandItem().isEmpty() || !this.getOffhandItem().isEmpty();
    }

    private boolean checkHands(Predicate<ItemStack> stack) {
        return stack.test(this.getMainHandItem()) || stack.test(this.getOffhandItem());
    }

    private void swapWithInventory(String animation) {
        if (this.level().isClientSide) {
            return;
        }
        if (animation == null) {
            this.inventory.swapItems(null);
        } else if (animation.equals(BOW)) {
            if (!this.checkHands(s -> LancelotAttackAI.get(LancelotAttackAI.BOW).matches((ItemStack)s))) {
                this.inventory.swapItems(LancelotAttackAI.BOW);
            }
        } else if (animation.equals(CROSSBOW)) {
            if (!this.checkHands(s -> LancelotAttackAI.get(LancelotAttackAI.CROSSBOW).matches((ItemStack)s))) {
                this.inventory.swapItems(LancelotAttackAI.CROSSBOW);
            }
        } else if (animation.equals(TRIDENT)) {
            if (!this.checkHands(s -> LancelotAttackAI.get(LancelotAttackAI.TRIDENT).matches((ItemStack)s))) {
                this.inventory.swapItems(LancelotAttackAI.TRIDENT);
            }
        } else if (animation.equals(STAB_1) && !this.checkHands(s -> s.is(FateTags.Items.SPEARS)) && !this.inventory.swapItems(LancelotInventory.SPEAR)) {
            this.inventory.swapItems(LancelotAttackAI.TRIDENT);
        }
    }

    protected InteractionHand toUseHand() {
        if (this.getAnimationHandler().isCurrent(new String[]{CROSSBOW})) {
            return this.getMainHandItem().getItem() instanceof CrossbowItem ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        }
        if (this.getAnimationHandler().isCurrent(new String[]{TRIDENT})) {
            return this.getMainHandItem().getItem() instanceof TridentItem ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        }
        if (this.getAnimationHandler().isCurrent(new String[]{BOW})) {
            return this.getMainHandItem().getItem() instanceof BowItem ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        }
        if (this.getAnimationHandler().isCurrent(new String[]{STAB_1})) {
            return this.getMainHandItem().is(FateTags.Items.SPEARS) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        }
        return !this.getMainHandItem().isEmpty() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public ItemStack getProjectile(ItemStack weaponStack) {
        Item item = weaponStack.getItem();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem weapon = (ProjectileWeaponItem)item;
            Predicate predicate = weapon.getSupportedHeldProjectiles();
            ItemStack itemstack = ProjectileWeaponItem.getHeldProjectile((LivingEntity)this, (Predicate)predicate);
            if (itemstack.isEmpty()) {
                ItemStack arrow = this.inventory.get(LancelotInventory.ARROWS);
                if (predicate.test(arrow)) {
                    return arrow;
                }
                ItemStack firework = this.inventory.get(LancelotInventory.FIREWORKS);
                if (predicate.test(firework)) {
                    return firework;
                }
            }
            return itemstack.isEmpty() ? new ItemStack((ItemLike)Items.ARROW) : itemstack;
        }
        return super.getProjectile(weaponStack);
    }

    private void reflectProjectile(Entity oldProjectile) {
        Entity entity;
        CompoundTag old = new CompoundTag();
        oldProjectile.saveWithoutId(old);
        old.remove("UUID");
        if (old.contains("Owner")) {
            old.putUUID("Owner", this.getUUID());
        }
        if ((entity = oldProjectile.getType().create(this.level())) instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            entity.load(old);
            projectile.setOwner((Entity)this);
            float velocity = (float)(entity.getDeltaMovement().length() * 0.7);
            if (this.getTarget() != null) {
                LivingEntity target = this.getTarget();
                Vec3 dir = new Vec3(target.getX() - entity.getX(), target.getY() + (double)target.getEyeHeight() - entity.getY(), target.getZ() - entity.getZ());
                this.shootProj(entity, dir.x, dir.y, dir.z, velocity, 1.0f);
            } else {
                this.shootProj(entity, -entity.getDeltaMovement().x, -entity.getDeltaMovement().y, -entity.getDeltaMovement().z, velocity, 1.0f);
            }
            this.level().addFreshEntity(entity);
        }
    }

    private void shootProj(Entity e, double dirX, double dirY, double dirZ, float vel, float acc) {
        Vec3 dir = new Vec3(dirX, dirY, dirZ).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)acc, this.random.nextGaussian() * (double)0.0075f * (double)acc, this.random.nextGaussian() * (double)0.0075f * (double)acc).scale((double)vel);
        e.setDeltaMovement(dir);
        float[] xYRot = MathsHelper.YXRotFrom(dir);
        float targetYRot = xYRot[0];
        float targetXRot = xYRot[1];
        e.setYRot(targetYRot);
        e.setXRot(targetXRot);
        e.yRotO = e.getYRot();
        e.xRotO = e.getXRot();
    }

    @Override
    public String[] specialCommands() {
        return new String[]{String.valueOf(FateEntities.LANCELOT.getID()) + ".drop"};
    }

    @Override
    public void doSpecialCommand(ServerPlayer sender, String id) {
        if (id.equals(String.valueOf(FateEntities.LANCELOT.getID()) + ".drop")) {
            this.swapWithInventory(null);
            for (ItemStack stack : this.inventory) {
                this.spawnAtLocation(stack);
            }
            this.inventory.clearContent();
            this.pickupDelay = 100;
        }
    }

    @Override
    public boolean flipAnimation() {
        return this.toUseHand() == InteractionHand.OFF_HAND;
    }

    @Override
    protected String getSummonAnimation() {
        return SUMMON;
    }

    @Override
    public Vector4f summonColor() {
        return this.summonColor;
    }

    @Override
    public EntityWeaponTrailHolderProvider.WeaponTrail weaponTrailEdge(boolean left) {
        return new EntityWeaponTrailHolderProvider.WeaponTrail(new Vector4f(0.0f, 0.0f, -0.6f, 1.0f), new Vector4f(0.0f, 0.0f, -1.3f, 1.0f));
    }
}

