/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant.lancelot;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.entity.servant.lancelot.LancelotAttackAI;
import io.github.flemmli97.fateubw.common.entity.servant.lancelot.LancelotUseHandler;
import io.github.flemmli97.fateubw.common.lib.FateTags;
import io.github.flemmli97.tenshilib.common.utils.ItemUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Fireworks;
import org.jetbrains.annotations.Nullable;

public class LancelotInventory
implements Iterable<ItemStack> {
    public static final ResourceLocation SPEAR = Fate.modRes("spear");
    public static final ResourceLocation ARROWS = Fate.modRes("arrows");
    public static final ResourceLocation FIREWORKS = Fate.modRes("fireworks");
    public static final Comparator<ResourceLocation> NAMESPACE_FIRST = Comparator.comparing(ResourceLocation::getNamespace).thenComparing(ResourceLocation::getPath);
    private final LivingEntity entity;
    private final List<ResourceLocation> slotData;
    private final NonNullList<ItemStack> items;
    private SwappedStack swappedStack;

    public LancelotInventory(LivingEntity entity) {
        this.entity = entity;
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(LancelotAttackAI.getView().keySet().stream().sorted(NAMESPACE_FIRST).toList());
        list.add(SPEAR);
        list.add(ARROWS);
        list.add(FIREWORKS);
        this.slotData = ImmutableList.copyOf(list);
        this.items = NonNullList.withSize((int)this.slotData.size(), (Object)ItemStack.EMPTY);
    }

    @Nullable
    public ItemStack insert(ItemStack stack) {
        int idx;
        ItemStack current;
        if (stack.getItem() instanceof ArrowItem) {
            int idx2 = this.slotData.indexOf(ARROWS);
            ItemStack current2 = (ItemStack)this.items.get(idx2);
            if (ItemStack.isSameItemSameComponents((ItemStack)current2, (ItemStack)stack)) {
                int grow = Math.min(stack.getCount(), current2.getMaxStackSize() - current2.getCount());
                if (grow > 0) {
                    current2.grow(grow);
                    stack.shrink(grow);
                }
                return ItemStack.EMPTY;
            }
            if (current2.isEmpty() || stack.getCount() > current2.getCount()) {
                this.items.set(idx2, (Object)stack);
                return current2;
            }
            return null;
        }
        if (stack.getItem() instanceof FireworkRocketItem) {
            int idx3 = this.slotData.indexOf(FIREWORKS);
            ItemStack current3 = (ItemStack)this.items.get(idx3);
            if (ItemStack.isSameItemSameComponents((ItemStack)current3, (ItemStack)stack)) {
                int grow = Math.min(stack.getCount(), current3.getMaxStackSize() - current3.getCount());
                if (grow > 0) {
                    current3.grow(grow);
                    stack.shrink(grow);
                }
                return ItemStack.EMPTY;
            }
            Fireworks stackFireworks = (Fireworks)stack.get(DataComponents.FIREWORKS);
            Fireworks currentFireworks = (Fireworks)current3.get(DataComponents.FIREWORKS);
            if (current3.isEmpty() || currentFireworks == null || stackFireworks != null && stackFireworks.explosions().size() > currentFireworks.explosions().size()) {
                this.items.set(idx3, (Object)stack);
                return current3;
            }
            return null;
        }
        Pair<ResourceLocation, LancelotUseHandler> handler = LancelotAttackAI.getFor(stack);
        if (handler != null && ((current = (ItemStack)this.items.get(idx = this.slotData.indexOf(handler.getFirst()))).isEmpty() || ((LancelotUseHandler)handler.getSecond()).isBetterThan(this.entity, current, stack))) {
            this.items.set(idx, (Object)stack);
            return current;
        }
        if (stack.is(FateTags.Items.SPEARS)) {
            idx = this.slotData.indexOf(SPEAR);
            current = (ItemStack)this.items.get(idx);
            if (current.isEmpty() || ItemUtils.isItemBetter((LivingEntity)this.entity, null, (ItemStack)stack, (ItemStack)current)) {
                this.items.set(idx, (Object)stack);
                return current;
            }
            return null;
        }
        return null;
    }

    private int idxFor(ResourceLocation id) {
        return this.slotData.indexOf(id);
    }

    public ItemStack get(ResourceLocation id) {
        int idx = this.idxFor(id);
        if (idx == -1) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.items.get(idx);
    }

    public void clearContent() {
        this.items.clear();
    }

    public boolean swapItems(ResourceLocation id) {
        if (id == null) {
            if (this.swappedStack != null) {
                this.entity.setItemInHand(InteractionHand.OFF_HAND, this.swappedStack.stack());
            }
            this.swappedStack = null;
            return true;
        }
        int idx = this.idxFor(id);
        if (idx == -1) {
            return false;
        }
        ItemStack current = (ItemStack)this.items.get(idx);
        if (current.isEmpty()) {
            return false;
        }
        if (this.swappedStack != null) {
            this.swapItems(null);
        }
        this.swappedStack = new SwappedStack(this.entity.getOffhandItem(), id);
        this.entity.setItemInHand(InteractionHand.OFF_HAND, ((ItemStack)this.items.get(idx)).copy());
        return true;
    }

    public boolean swapped() {
        return this.swappedStack != null;
    }

    public LancelotInventory setSwappedStack(SwappedStack swappedStack) {
        this.swappedStack = swappedStack;
        return this;
    }

    public CompoundTag save(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ListTag content = new ListTag();
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        for (ItemStack stack : this.items) {
            content.add((Object)((Tag)ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)ops, (Object)stack).getOrThrow()));
        }
        tag.put("Content", (Tag)content);
        ListTag ids = new ListTag();
        for (ResourceLocation id : this.slotData) {
            ids.add((Object)((Tag)ResourceLocation.CODEC.encodeStart((DynamicOps)ops, (Object)id).getOrThrow()));
        }
        tag.put("Ids", (Tag)ids);
        if (this.swappedStack != null) {
            tag.put("SwappedStack", (Tag)ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)ops, (Object)this.swappedStack.stack()).getOrThrow());
            tag.put("SwappedId", (Tag)ResourceLocation.CODEC.encodeStart((DynamicOps)ops, (Object)this.swappedStack.id()).getOrThrow());
        }
        return tag;
    }

    public void load(CompoundTag tag, HolderLookup.Provider provider) {
        int i;
        ListTag content = tag.getList("Content", 10);
        ListTag idTag = tag.getList("Ids", 8);
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        int[] idxs = new int[idTag.size()];
        block0: for (i = 0; i < idTag.size(); ++i) {
            ResourceLocation id = (ResourceLocation)ResourceLocation.CODEC.parse((DynamicOps)ops, (Object)idTag.get(i)).getOrThrow();
            for (int j = 0; j < this.slotData.size(); ++j) {
                if (!this.slotData.get(i).equals((Object)id)) continue;
                idxs[i] = i;
                continue block0;
            }
        }
        for (i = 0; i < content.size(); ++i) {
            ItemStack stack = (ItemStack)ItemStack.OPTIONAL_CODEC.parse((DynamicOps)ops, (Object)content.get(i)).getOrThrow();
            this.items.set(idxs[i], (Object)stack);
        }
        if (tag.contains("SwappedStack")) {
            this.swappedStack = new SwappedStack((ItemStack)ItemStack.OPTIONAL_CODEC.parse((DynamicOps)ops, (Object)tag.get("SwappedStack")).getOrThrow(), (ResourceLocation)ResourceLocation.CODEC.parse((DynamicOps)ops, (Object)tag.get("SwappedId")).getOrThrow());
        }
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return this.items.iterator();
    }

    record SwappedStack(ItemStack stack, ResourceLocation id) {
    }
}

