/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant.lancelot.impl;

import io.github.flemmli97.fateubw.common.entity.servant.lancelot.LancelotUseHandler;
import io.github.flemmli97.fateubw.mixin.CrossbowAccessor;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class CrossbowHandler
implements LancelotUseHandler {
    private int getPowerLevel(LivingEntity entity) {
        return Mth.floor((double)(entity.getAttributeValue(Attributes.ATTACK_DAMAGE) * 0.4));
    }

    @Override
    public void startUse(LivingEntity entity, LivingEntity target, InteractionHand hand) {
        entity.startUsingItem(hand);
        ItemStack stack = entity.getUseItem();
        Item item = stack.getItem();
        if (item instanceof CrossbowItem) {
            CrossbowItem crossbow = (CrossbowItem)item;
            ((CrossbowAccessor)crossbow).fetchChargingSounds(stack).start().ifPresent(sound -> entity.playSound((SoundEvent)sound.value(), 1.0f, 0.7f));
        }
    }

    @Override
    public void use(LivingEntity entity, LivingEntity target, InteractionHand hand) {
        entity.releaseUsingItem();
        ItemStack stack = entity.getItemInHand(hand);
        Item item = stack.getItem();
        if (item instanceof CrossbowItem) {
            CrossbowItem crossbow = (CrossbowItem)item;
            Holder.Reference power = entity.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.POWER);
            int powerLevel = ((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).getLevel((Holder)power);
            EnchantmentHelper.updateEnchantments((ItemStack)stack, arg_0 -> this.lambda$use$1((Holder)power, powerLevel, entity, arg_0));
            ChargedProjectiles projectile = (ChargedProjectiles)stack.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
            float vel = projectile.contains(Items.FIREWORK_ROCKET) ? 1.7f : 3.4f;
            crossbow.performShooting(entity.level(), entity, hand, stack, vel, 1.0f, null);
            EnchantmentHelper.updateEnchantments((ItemStack)stack, arg_0 -> CrossbowHandler.lambda$use$2((Holder)power, powerLevel, arg_0));
        }
    }

    @Override
    public boolean matches(ItemStack item) {
        return item.getItem() instanceof CrossbowItem;
    }

    @Override
    public boolean isBetterThan(LivingEntity entity, ItemStack current, ItemStack stack) {
        ItemEnchantments enchants = (ItemEnchantments)current.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments enchants2 = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        return enchants2.size() > enchants.size();
    }

    private static /* synthetic */ void lambda$use$2(Holder power, int powerLevel, ItemEnchantments.Mutable mutable) {
        mutable.set(power, powerLevel);
    }

    private /* synthetic */ void lambda$use$1(Holder power, int powerLevel, LivingEntity entity, ItemEnchantments.Mutable mutable) {
        mutable.set(power, powerLevel + this.getPowerLevel(entity));
    }
}

