/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.summons;

import io.github.flemmli97.fateubw.common.entity.summons.GordiusWheel;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.utils.MathsHelper;
import io.github.flemmli97.tenshilib.common.entity.MultiPartEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GordiusChariot
extends MultiPartEntity
implements OwnableEntity {
    private static final double CHARIOT_JOINT_DIST = 1.6;

    public GordiusChariot(EntityType<GordiusChariot> multipartType, Level level) {
        super(multipartType, level);
    }

    public GordiusChariot(LivingEntity parent, float width, float height) {
        super((EntityType)FateEntities.GORDIUS_CHARIOT.get(), parent, width, height);
    }

    public boolean parentTick() {
        if (this.getOwner() != null && !this.getOwner().level().isClientSide && !this.isEntityAddedToLevel()) {
            Vec3 wheelJoint = this.getOwner().getWheelJoint();
            Vec3 dir = wheelJoint.subtract(this.getOwner().position()).normalize().scale(1.6);
            this.setPos(wheelJoint.x() + dir.x(), wheelJoint.y() + dir.y(), wheelJoint.z() + dir.z());
            this.level().addFreshEntity((Entity)this);
            return true;
        }
        return false;
    }

    public void baseTick() {
        Vec3 lookDir;
        super.baseTick();
        if (!this.level().isClientSide() && (lookDir = this.directionToLookAt()) != null) {
            float[] yxRot = MathsHelper.YXRotFrom(lookDir);
            this.setYRot(MathsHelper.rotlerp(this.getYRot(), yxRot[0], 15.0f));
            this.setXRot(MathsHelper.rotlerp(this.getXRot(), yxRot[1], 15.0f));
            this.setYBodyRot(this.getYRot());
            this.setYHeadRot(this.getYRot());
        }
    }

    private Vec3 directionToLookAt() {
        GordiusWheel owner = this.getOwner();
        if (owner != null) {
            return this.getOwner().getWheelJoint().subtract(this.position());
        }
        return null;
    }

    protected void updatePosition() {
        Vec3 wheelJoint = this.getOwner().getWheelJoint();
        Vec3 offsetDir = wheelJoint.subtract(this.position());
        double maxDist = 1.6 * (double)this.getOwner().getScale();
        Vec3 target = wheelJoint.subtract(offsetDir.normalize().scale(maxDist));
        if (this.position().distanceToSqr(target) > 6.0) {
            this.teleportTo(target.x(), target.y(), target.z());
        } else {
            this.moveTo(target.x(), target.y(), target.z(), false);
        }
    }

    public float maxUpStep() {
        return this.getOwner().maxUpStep();
    }

    public void setYRot(float yRot) {
        super.setYRot(Mth.wrapDegrees((float)yRot));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        float scale = this.getOwner() != null ? this.getOwner().getScale() : 1.0f;
        return new Vec3(0.0, 1.0625 * (double)scale + entity.getVehicleAttachmentPoint((Entity)this.getOwner()).y(), -0.15).yRot(-this.getYRot() * ((float)Math.PI / 180));
    }

    public GordiusWheel getOwner() {
        LivingEntity sup = super.getOwner();
        if (sup instanceof GordiusWheel) {
            GordiusWheel wheel = (GordiusWheel)sup;
            return wheel;
        }
        return null;
    }
}

