/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.summons;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.api.datapack.AttributeHolderProperties;
import io.github.flemmli97.fateubw.common.datapack.DatapackHandler;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.SetTargetFromRider;
import io.github.flemmli97.fateubw.common.entity.summons.GordiusChariot;
import io.github.flemmli97.fateubw.common.entity.utils.MoveStateTracker;
import io.github.flemmli97.fateubw.common.entity.utils.MoveType;
import io.github.flemmli97.fateubw.common.entity.utils.StandingVehicle;
import io.github.flemmli97.fateubw.common.network.S2CAttackDebug;
import io.github.flemmli97.fateubw.common.network.S2CScreenShake;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.utils.MathsHelper;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.AOEAttackEntity;
import io.github.flemmli97.tenshilib.common.entity.MultiPartEntity;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetMoveToRestriction;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedMobDataHandler;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class GordiusWheel
extends PathfinderMob
implements AnimatedEntity,
StandingVehicle,
AOEAttackEntity,
SmartBrainOwner<GordiusWheel>,
SyncedMobDataHandler {
    private static final EntityDataAccessor<Integer> WHEEL = SynchedEntityData.defineId(GordiusWheel.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Byte> MOVE_FLAGS = SynchedEntityData.defineId(GordiusWheel.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final TypedResource<Vec3> CHARGE_MOTION = new TypedResource(Fate.modRes("charge_motion"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String STOMP = BUILDER.add("stomp", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.52}));
    public static final String CHARGING = BUILDER.add("charge", AnimationsBuilder.definition((double)2.6).marker("charge_start", new double[]{0.48}).marker("charge_end", new double[]{2.16}));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    public final Predicate<LivingEntity> targetPred = target -> {
        Mob mob;
        if (target == this) {
            return false;
        }
        if (this.getTarget() == target) {
            return true;
        }
        Entity patt0$temp = this.getFirstPassenger();
        if (patt0$temp instanceof Mob && target == (mob = (Mob)patt0$temp).getTarget()) {
            return true;
        }
        Entity patt1$temp = this.getFirstPassenger();
        if (patt1$temp instanceof BaseServant) {
            BaseServant servant = (BaseServant)patt1$temp;
            return servant.targetPred.test((LivingEntity)target);
        }
        return this.canAttack((LivingEntity)target) && !this.hasPassenger((Entity)target);
    };
    private final AnimationHandler<GordiusWheel> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (!this.level().isClientSide && anim != null && anim.is(new String[]{CHARGING})) {
            this.setChargeMotion(null);
        }
        return false;
    });
    private final SyncedDataContainer<GordiusWheel> syncedDataContainer = SyncedDataContainer.builder((Entity)this).define(CHARGE_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null).build();
    private MultiPartEntity wheels;
    private final MoveStateTracker moveStateTracker = new MoveStateTracker(2, this::getMoveType);
    public int wheelMoveTick;
    public float wheelPartial;

    public GordiusWheel(EntityType<? extends GordiusWheel> type, Level level) {
        super(type, level);
        if (!level.isClientSide) {
            this.updateAttributes();
        }
        this.lookControl = new GordiusLookControl((Mob)this);
        this.moveControl = new GordiusMoveControl((Mob)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return BaseServant.createAttributes().add(Attributes.STEP_HEIGHT, 1.6);
    }

    private void updateAttributes() {
        AttributeHolderProperties props = DatapackHandler.SERVANT_PROPS.getGeneric(this.getType());
        props.attributes().forEach((att, val) -> {
            AttributeInstance inst = this.getAttribute((Holder)att);
            if (inst != null) {
                inst.setBaseValue(val.doubleValue());
                if (att == Attributes.MAX_HEALTH) {
                    this.setHealth(this.getMaxHealth());
                }
            }
        });
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(WHEEL, (Object)-1);
        builder.define(MOVE_FLAGS, (Object)0);
    }

    public SyncedDataContainer<?> getDataContainer() {
        return this.syncedDataContainer;
    }

    public List<? extends ExtendedSensor<? extends GordiusWheel>> getSensors() {
        return List.of();
    }

    protected PathNavigation createNavigation(Level level) {
        return new SmoothGroundNavigation((Mob)this, level);
    }

    public BrainActivityGroup<? extends GordiusWheel> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new FloatToSurfaceOfFluid(), new SetTargetFromRider()});
    }

    public BrainActivityGroup<? extends GordiusWheel> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new MoveToWalkTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate(), new SetMoveToRestriction(), new SetRandomWalkTarget().startCondition(m -> m.getRandom().nextInt(120) == 0)})});
    }

    public BrainActivityGroup<? extends GordiusWheel> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), SelectableBehaviourBuilder.builder().add(1, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).build().startCondition(BehaviourUtils::runCooldownBehaviour).stopIf(e -> !BehaviourUtils.runCooldownBehaviour(e)), AttackBehaviourBuilder.create().start(new String[]{STOMP}).play(BehaviourUtils.cooldownedPlay(true, 10, 40)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(1).start(new String[]{CHARGING}).play(BehaviourUtils.cooldownedPlay(false, 10, 40)).prepare(new ExtendedBehaviour[]{new SetChargeTarget()}).end(1).build().startCondition(BehaviourUtils::runCombatBehaviour)});
    }

    protected Brain.Provider<?> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    public void baseTick() {
        Vec3 lookDir;
        super.baseTick();
        this.getAnimationHandler().tick();
        if (!this.level().isClientSide) {
            Mob mob;
            Entity entity;
            if (this.wheels == null) {
                this.wheels = new GordiusChariot((LivingEntity)this, 2.2f, 1.6f);
            }
            if (this.wheels.parentTick()) {
                this.entityData.set(WHEEL, (Object)this.wheels.getId());
            }
            this.getAnimationHandler().runIfNotNull(this::handleAttack);
            if (this.getTarget() == null && (entity = this.getFirstPassenger()) instanceof Mob && (mob = (Mob)entity).getTarget() != this.getTarget()) {
                this.setTarget(mob.getTarget());
            }
        }
        this.moveStateTracker.tick();
        if (this.getMoveType() != MoveType.NONE) {
            ++this.wheelMoveTick;
        }
        if ((lookDir = this.directionToLookAt()) != null) {
            float[] yxRot = MathsHelper.YXRotFrom(lookDir);
            this.setYRot(MathsHelper.rotlerp(this.getYRot(), yxRot[0], 30.0f));
            this.setXRot(MathsHelper.rotlerp(this.getXRot(), yxRot[1], 30.0f));
            this.setYBodyRot(this.getYRot());
            this.setYHeadRot(this.getYRot());
        }
    }

    private Vec3 directionToLookAt() {
        if (this.isCharging()) {
            return this.getChargeMotion();
        }
        return null;
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        this.tickBrain((LivingEntity)this);
        if (!(this.getControllingPassenger() instanceof Player) && this.getDeltaMovement().horizontalDistanceSqr() > 0.003 && this.isAlive()) {
            double speedMod = this.getMoveControl().getSpeedModifier();
            MoveType move = speedMod > 1.0 || speedMod >= 1.0 && this.getTarget() != null ? MoveType.RUN : (speedMod <= 0.8 ? MoveType.SNEAK : MoveType.WALK);
            if (this.isImmobile()) {
                move = MoveType.NONE;
            }
            this.setMovingFlag(move);
        } else {
            this.setMovingFlag(MoveType.NONE);
            this.setShiftKeyDown(false);
            this.setSprinting(false);
        }
    }

    public float interpolatedMoveTick(float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTick(partialTicks);
    }

    public float interpolatedMoveTickOf(MoveType moveType, float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTickOf(moveType, partialTicks);
    }

    public void setMovingFlag(MoveType type) {
        this.entityData.set(MOVE_FLAGS, (Object)((byte)type.ordinal()));
    }

    public MoveType getMoveType() {
        return MoveType.values()[(Byte)this.entityData.get(MOVE_FLAGS)];
    }

    public Vec3 getPassengerRidingPosition(Entity passenger) {
        MultiPartEntity wheel;
        if (this.hasPassenger(passenger) && (wheel = this.getWheelEntity()) != null) {
            return wheel.getPassengerRidingPosition(passenger);
        }
        return super.getPassengerRidingPosition(passenger);
    }

    @Nullable
    public MultiPartEntity getWheelEntity() {
        GordiusChariot part;
        Entity entity;
        if (this.level().isClientSide && this.wheels == null && (entity = this.level().getEntity(((Integer)this.entityData.get(WHEEL)).intValue())) instanceof GordiusChariot && (part = (GordiusChariot)entity).getOwner() == this) {
            this.wheels = part;
        }
        return this.wheels;
    }

    public Vec3 getWheelJoint() {
        Vec3 offset = new Vec3(0.0, 0.0, -1.0);
        offset.scale((double)this.getScale());
        return this.position().add(offset.yRot(-this.getYRot() * ((float)Math.PI / 180)));
    }

    public LivingEntity getTarget() {
        return BrainUtils.getTargetOfEntity((LivingEntity)this);
    }

    public void setTarget(@Nullable LivingEntity target) {
        super.setTarget(target);
        if (super.getTarget() == null) {
            BrainUtils.clearMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET);
        } else {
            BrainUtils.setMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET, (Object)super.getTarget());
        }
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean hurt(DamageSource damageSource, float damage) {
        if (!damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && this.isCharging()) {
            damage *= 0.5f;
        }
        return super.hurt(damageSource, damage);
    }

    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{CHARGING})) {
            Vec3 dir;
            if (anim.isPast("charge_start") && !anim.isPast("charge_end") && (dir = this.getChargeMotion()) != null) {
                this.setDeltaMovement(dir.x(), this.getDeltaMovement().y(), dir.z());
                OrientedBoundingBox obb = this.prepareAttackBox(anim.getAnimation(), null, 0.2, false);
                List list = this.level().getEntitiesOfClass(LivingEntity.class, obb.getEncompassingBox(), entity -> this.targetPred.test((LivingEntity)entity) && obb.intersects(entity.getBoundingBox()));
                for (LivingEntity e : list) {
                    e.hurt(FateDamageTypes.direct(FateDamageTypes.GORDIUS_TRAMPLE, (Entity)this), (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
                }
                this.playSound(SoundEvents.COW_STEP, 0.4f, 0.4f);
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)this);
                S2CScreenShake.sendAround((Entity)this, 14.0, 4, 1.5f);
            }
        } else {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                this.mobAttack(anim, this.getTarget(), this::doHurtTarget);
                S2CScreenShake.sendAround((Entity)this, 6.0, 8, 2.0f);
            }
        }
    }

    public void mobAttack(AnimationState anim, LivingEntity target, Consumer<LivingEntity> cons) {
        OrientedBoundingBox obb = this.prepareAttackBox(anim.getAnimation(), (Entity)target, 0.2, false);
        this.level().getEntitiesOfClass(LivingEntity.class, obb.getEncompassingBox(), entity -> this.targetPred.test((LivingEntity)entity) && obb.intersects(entity.getBoundingBox())).forEach(cons);
        if (!this.level().isClientSide) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)this);
        }
    }

    public OrientedBoundingBox prepareAttackBox(String anim, Entity target, double grow, boolean debug) {
        OrientedBoundingBox obb = this.calculateAttackAABB(this.getAnimationHandler().createDefaulted(anim), target != null ? target.position() : null, grow);
        if (debug) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTEMPT, (Entity)this);
        }
        return obb;
    }

    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, @Nullable Vec3 target, double grow) {
        if (anim.is(new String[]{CHARGING})) {
            AABB aabb2 = this.getBoundingBox().minmax(this.wheels.getBoundingBox());
            double lenX = aabb2.getXsize();
            double lenZ = aabb2.getZsize();
            double expand = 0.3 + grow;
            double len = Math.sqrt(lenX * lenX + lenZ * lenZ) + 2.0 * expand;
            double width = Math.min(lenX, lenZ) * 0.5 + expand;
            double offset = (double)this.wheels.getBbWidth() * 0.5 + expand;
            AABB aabb = new AABB(-width, -0.02, -offset, width, (double)this.getBbHeight(), len - offset);
            return new OrientedBoundingBox(aabb, this.getYRot(), 0.0f, this.wheels.position());
        }
        double width = (double)this.getBbWidth() * 0.5 + 1.5;
        AABB aabb = new AABB(-width * 0.8, -0.02, -width * 0.5, width * 0.8, (double)this.getBbHeight() * 0.5, width * 1.2);
        return new OrientedBoundingBox(aabb, this.getYRot(), 0.0f, this.position());
    }

    public boolean doHurtTarget(Entity entity) {
        return Utils.runWithInvulTimer((Entity)this, entity, x$0 -> super.doHurtTarget(x$0), 0);
    }

    public AnimationHandler<GordiusWheel> getAnimationHandler() {
        return this.animationHandler;
    }

    public Vec3 getChargeMotion() {
        return (Vec3)this.getDataContainer().get(CHARGE_MOTION);
    }

    public void setChargeTo(Vec3 pos) {
        Vec3 dir = pos.subtract(this.position());
        dir = new Vec3(dir.x(), 0.0, dir.z());
        this.setChargeMotion(dir.normalize().scale(0.55));
    }

    public void setChargeMotion(Vec3 chargeMotion) {
        this.getDataContainer().set(CHARGE_MOTION, (Object)chargeMotion);
    }

    public boolean isCharging() {
        if (this.getAnimationHandler() == null) {
            return false;
        }
        AnimationState anim = this.getAnimationHandler().getAnimation();
        return anim != null && anim.is(new String[]{CHARGING}) && anim.isPast("attack");
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.COW_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.COW_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.COW_DEATH;
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
    }

    public boolean isPickable() {
        return true;
    }

    public void push(Entity entity) {
    }

    public boolean canAttack(LivingEntity entity) {
        Entity entity2 = this.getFirstPassenger();
        if (entity2 instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entity2;
            return entity != ownable.getOwner();
        }
        return super.canAttack(entity);
    }

    protected static class GordiusLookControl
    extends LookControl {
        public GordiusLookControl(Mob mob) {
            super(mob);
        }

        public void setLookAt(double x, double y, double z, float deltaYaw, float deltaPitch) {
            super.setLookAt(x, y, z, Math.min(deltaYaw, 10.0f), deltaPitch);
        }
    }

    protected class GordiusMoveControl
    extends MoveControl {
        public GordiusMoveControl(Mob mob) {
            super(mob);
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                double dZ;
                double dY;
                this.operation = MoveControl.Operation.WAIT;
                double dX = this.wantedX - GordiusWheel.this.getX();
                double len = dX * dX + (dY = this.wantedY - GordiusWheel.this.getY()) * dY + (dZ = this.wantedZ - GordiusWheel.this.getZ()) * dZ;
                if (len < 2.5E-7) {
                    this.mob.setZza(0.0f);
                    return;
                }
                float n = (float)(Mth.atan2((double)dZ, (double)dX) * 57.2957763671875) - 90.0f;
                float rotY = this.rotlerp(this.mob.getYRot(), n, 30.0f);
                this.mob.setYRot(rotY);
                float speed = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED));
                speed = Mth.degreesDifferenceAbs((float)rotY, (float)this.mob.getYRot()) > 10.0f ? speed * 0.5f : speed;
                this.mob.setSpeed(speed);
                BlockPos blockPos = this.mob.blockPosition();
                BlockState blockState = this.mob.level().getBlockState(blockPos);
                VoxelShape voxelShape = blockState.getCollisionShape((BlockGetter)this.mob.level(), blockPos);
                if (dY > (double)this.mob.maxUpStep() && dX * dX + dZ * dZ < (double)Math.max(1.0f, this.mob.getBbWidth()) || !voxelShape.isEmpty() && this.mob.getY() < voxelShape.max(Direction.Axis.Y) + (double)blockPos.getY() && !blockState.is(BlockTags.DOORS) && !blockState.is(BlockTags.FENCES)) {
                    this.mob.getJumpControl().jump();
                    this.operation = MoveControl.Operation.JUMPING;
                }
            } else {
                super.tick();
            }
        }
    }

    public static class SetChargeTarget
    extends ExtendedBehaviour<GordiusWheel> {
        private static final MemoryTest MEMORIES = MemoryTest.builder((int)1).hasMemories(new MemoryModuleType[]{MemoryModuleType.ATTACK_TARGET});
        private Vec3 targetPos;

        protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return MEMORIES;
        }

        protected boolean shouldKeepRunning(GordiusWheel entity) {
            double dX = this.targetPos.x() - entity.getX();
            double dZ = this.targetPos.z() - entity.getZ();
            float yRot = MathsHelper.YRotFrom(dX, dZ);
            float diffY = Mth.degreesDifference((float)entity.getYRot(), (float)yRot);
            if (Math.abs(diffY) < 16.0f) {
                entity.setChargeTo(this.targetPos);
                return false;
            }
            return true;
        }

        protected void start(GordiusWheel entity) {
            this.targetPos = BrainUtils.getTargetOfEntity((LivingEntity)entity).getEyePosition();
        }

        protected void tick(GordiusWheel entity) {
            super.tick((LivingEntity)entity);
            double dY = this.targetPos.y() - entity.getEyeY();
            double dX = this.targetPos.x() - entity.getX();
            double dZ = this.targetPos.z() - entity.getZ();
            float[] yXRot = MathsHelper.YXRotFrom(dX, dY, dZ);
            entity.setYRot(MathsHelper.rotlerp(entity.getYRot(), yXRot[0], 17.0f));
            entity.setXRot(MathsHelper.rotlerp(entity.getXRot(), yXRot[1], 30.0f));
            entity.setYBodyRot(entity.getYRot());
            entity.setYHeadRot(entity.getYRot());
        }
    }
}

