/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.summons;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.api.datapack.AttributeHolderProperties;
import io.github.flemmli97.fateubw.common.datapack.DatapackHandler;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.MoveBehindBehaviour;
import io.github.flemmli97.fateubw.common.entity.misc.ThrownItemEntity;
import io.github.flemmli97.fateubw.common.entity.servant.Hassan;
import io.github.flemmli97.fateubw.common.entity.utils.MoveStateTracker;
import io.github.flemmli97.fateubw.common.entity.utils.MoveType;
import io.github.flemmli97.fateubw.common.entity.utils.ServantModelLike;
import io.github.flemmli97.fateubw.common.entity.utils.TargetableOpponent;
import io.github.flemmli97.fateubw.common.lib.FateTags;
import io.github.flemmli97.fateubw.common.network.S2CAttackDebug;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.TrailParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolder;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolderProvider;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailProvider;
import io.github.flemmli97.fateubw.common.registry.FateAttributes;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.utils.MathsHelper;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.AOEAttackEntity;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetMoveToRestriction;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedMobDataHandler;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.AllApplicableBehaviours;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowEntity;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.InteractWithDoor;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class HassanClone
extends PathfinderMob
implements AnimatedEntity,
OwnableEntity,
AOEAttackEntity,
TargetableOpponent,
ServantModelLike,
SmartBrainOwner<HassanClone>,
SyncedMobDataHandler,
EntityWeaponTrailHolderProvider {
    public static final ResourceLocation BACKSTAB_MODIFIER = Fate.modRes("hassan_backstab");
    protected static final EntityDataAccessor<Byte> MOVE_FLAGS = SynchedEntityData.defineId(HassanClone.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final AnimationDefinitionContainer ANIMS = Hassan.BUILDER.build();
    private UUID ownerUUID;
    private Hassan owner;
    public final Predicate<LivingEntity> targetPred = Utils.servantTargetPredicate((Mob)this);
    private final AnimationHandler<HassanClone> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (anim != null && this.getTarget() != null) {
            this.targetPosition = this.getTarget().position();
        }
        if (anim == null || !anim.is(new String[]{Hassan.SUMMON})) {
            if (!this.offHandCache.isEmpty()) {
                this.setItemInHand(InteractionHand.OFF_HAND, this.offHandCache);
                this.offHandCache = ItemStack.EMPTY;
            }
            if (!this.mainHandCache.isEmpty()) {
                this.setItemInHand(InteractionHand.MAIN_HAND, this.mainHandCache);
                this.mainHandCache = ItemStack.EMPTY;
            }
        }
        return false;
    });
    private final SyncedDataContainer<HassanClone> syncedDataContainer;
    private final MoveStateTracker moveStateTracker = new MoveStateTracker(3, this::getMoveFlag);
    protected Vec3 targetPosition;
    private ItemStack mainHandCache = ItemStack.EMPTY;
    private ItemStack offHandCache = ItemStack.EMPTY;
    private final EntityWeaponTrailHolder<HassanClone> trailHolder = new EntityWeaponTrailHolder<HassanClone>(this);

    public HassanClone(EntityType<? extends HassanClone> type, Level level) {
        super(type, level);
        SyncedDataContainer.Builder builder = SyncedDataContainer.builder((Entity)this);
        this.definedAdditinoalSyncedData((SyncedDataContainer.Builder<HassanClone>)builder);
        this.syncedDataContainer = builder.build();
        if (!level.isClientSide) {
            this.updateAttributes();
        }
    }

    public HassanClone(Level level, Hassan entityHassan) {
        this((EntityType<? extends HassanClone>)((EntityType)FateEntities.HASSAN_COPY.get()), level);
        this.setOriginal(entityHassan);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MOVE_FLAGS, (Object)0);
    }

    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<HassanClone> builder) {
        builder.define(BaseServant.TARGET_POSITION, (SyncedEntityData)TenshilibSyncableEntityDatas.TARGET_POS.get(), null);
    }

    public SyncedDataContainer<?> getDataContainer() {
        return this.syncedDataContainer;
    }

    private void updateAttributes() {
        AttributeHolderProperties props = DatapackHandler.SERVANT_PROPS.getGeneric(this.getType());
        props.attributes().forEach((att, val) -> {
            AttributeInstance inst = this.getAttribute((Holder)att);
            if (inst != null) {
                inst.setBaseValue(val.doubleValue());
                if (att == Attributes.MAX_HEALTH) {
                    this.setHealth(this.getMaxHealth());
                }
            }
        });
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)FateItems.ASSASSIN_DAGGER.get()));
    }

    public List<? extends ExtendedSensor<? extends HassanClone>> getSensors() {
        return List.of(new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setPredicate((target, entity) -> entity.getOwner() != null && entity.getOwner().getTarget() == target).setScanRate(e -> 10), new HurtBySensor().setPredicate((source, entity) -> {
            Entity patt0$temp = source.getEntity();
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)patt0$temp;
                return !Utils.alliedTo((Entity)entity, (Entity)attacker);
            }
            return true;
        }));
    }

    public BrainActivityGroup<? extends HassanClone> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new FloatToSurfaceOfFluid(), new InteractWithDoor(), new FollowEntity().following(HassanClone::getOwner).teleportToTargetAfter(17.0).stopFollowingWithin(6.0).speedMod(1.1f), this.lookBehaviour(), new LookAtTarget().runFor(entity -> entity.getRandom().nextIntBetweenInclusive(40, 100)).whenStopping(m -> BrainUtils.clearMemory((LivingEntity)m, (MemoryModuleType)MemoryModuleType.LOOK_TARGET))});
    }

    protected ExtendedBehaviour<? extends HassanClone> lookBehaviour() {
        return new AllApplicableBehaviours(new ExtendedBehaviour[]{new LookAtAttackTarget(), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomLookTarget().lookChance((FloatProvider)ConstantFloat.of((float)1.0f)), new SetPlayerLookTarget()}).startCondition(m -> (double)m.getRandom().nextFloat() < 0.1 && !BrainUtils.hasMemory((LivingEntity)m, (MemoryModuleType)MemoryModuleType.WALK_TARGET))}).startCondition(e -> !BrainUtils.hasMemory((LivingEntity)e, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET) && !e.isSleeping() && !e.getAnimationHandler().hasAnimation());
    }

    public BrainActivityGroup<? extends HassanClone> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new MoveToWalkTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate(), new SetMoveToRestriction(), new SetRandomWalkTarget().startCondition(m -> m.getRandom().nextInt(120) == 0)})});
    }

    public BrainActivityGroup<? extends HassanClone> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), this.getCooldownAI().startCondition(BehaviourUtils::runCooldownBehaviour).stopIf(e -> !BehaviourUtils.runCooldownBehaviour(e)), this.getCombatAI().startCondition(BehaviourUtils::runCombatBehaviour)});
    }

    public ExtendedBehaviour<? extends HassanClone> getCombatAI() {
        return AttackBehaviourBuilder.create().start(BehaviourUtils.of(AnimationPlayHolder.builder((String)Hassan.DAGGER_1).start(Hassan.DAGGER_3, 2, 0.24f, 1).start(Hassan.DAGGER_4, 2, 0.24f, 1).start(Hassan.TOP_STAB, 2, 0.24f, 1).build())).play(BehaviourUtils.cooldownedPlay(true, 15, 26)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(8).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)Hassan.DAGGER_1).start(Hassan.DAGGER_3, 2, 0.24f, 1).start(Hassan.DAGGER_4, 2, 0.24f, 1).build())).play(BehaviourUtils.cooldownedPlay(true, 15, 26)).prepare(new ExtendedBehaviour[]{new MoveBehindBehaviour()}).end(7).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)Hassan.DAGGER_3).start(Hassan.DAGGER_1, 2, 0.24f, 1).chain(Hassan.DAGGER_2, 2, 0.24f).start(Hassan.DAGGER_1, 2, 0.24f, 1).chain(Hassan.DAGGER_4, 2, 0.24f).build())).play(BehaviourUtils.cooldownedPlay(true, 15, 26)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(8).start(new String[]{Hassan.TOP_STAB}).play(BehaviourUtils.cooldownedPlay(true, 15, 26)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(9).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)Hassan.DAGGER_4).start(Hassan.TOP_STAB, 2, 0.24f, 1).build())).play(BehaviourUtils.cooldownedPlay(true, 15, 26)).prepare(new ExtendedBehaviour[]{new MoveBehindBehaviour().speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(11).start(new String[]{Hassan.THROW}).play(BehaviourUtils.cooldownedPlay(false, 15, 26)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(7.0).max(14.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(9).start(new String[]{Hassan.THROW}).play(BehaviourUtils.cooldownedPlay(false, 15, 26)).condition(entity -> {
            if (BehaviourUtils.ifFurtherThan(8.0).test(entity)) {
                return true;
            }
            LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
            return target != null && target.getY() - entity.getY() > 4.0;
        }).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(7.0).max(14.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(11).build();
    }

    public ExtendedBehaviour<? extends HassanClone> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(6, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).add(3, new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().radius(7.0), BehaviourUtils.moveTo()}).build();
    }

    protected Brain.Provider<?> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    public void tick() {
        if (!this.level().isClientSide) {
            Mob mob;
            Entity entity;
            if (this.tickCount > 200 && this.isAlive() && (this.getOwner() == null || !this.getOwner().isAlive())) {
                this.hurt(this.damageSources().genericKill(), 2.1474836E9f);
                return;
            }
            if (this.getTarget() == null && (entity = this.getFirstPassenger()) instanceof Mob && (mob = (Mob)entity).getTarget() != this.getTarget()) {
                this.setTarget(mob.getTarget());
            }
            this.getAnimationHandler().runIfNotNull(this::handleAttack);
        }
        super.tick();
        this.getAnimationHandler().tick();
    }

    public void baseTick() {
        AnimationState anim;
        super.baseTick();
        if (this.level().isClientSide && (anim = this.getAnimationHandler().getAnimation()) != null && anim.isAt("weapon_swing_start")) {
            this.level().addParticle((ParticleOptions)new TrailParticleData((ParticleType<TrailParticleData>)((ParticleType)FateParticles.TRAIL.get()), TrailInfo.builder(EntityWeaponTrailProvider.EntityTrailData.create(this, anim.getID(), false)).setColor(0.26666668f, 0.26666668f, 0.26666668f, 0.6f).setColor2(0.26666668f, 0.26666668f, 0.26666668f, 0.2f).setType(TrailInfo.Visual.TEXTURE, 0).build()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.tickBrain((LivingEntity)this);
        if (!(this.getControllingPassenger() instanceof Player) && this.isMoving() && this.isAlive()) {
            double d0 = this.getMoveControl().getSpeedModifier();
            MoveType move = d0 > 1.0 ? MoveType.RUN : (d0 <= 0.8 ? MoveType.SNEAK : MoveType.WALK);
            if (this.isImmobile()) {
                move = MoveType.NONE;
            }
            this.setMovingFlag(move);
        } else {
            this.setMovingFlag(MoveType.NONE);
            this.setShiftKeyDown(false);
            this.setSprinting(false);
        }
    }

    protected boolean isMoving() {
        return this.getDeltaMovement().x != 0.0 || this.getDeltaMovement().z != 0.0;
    }

    @Override
    public float interpolatedMoveTick(float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTick(partialTicks);
    }

    @Override
    public float interpolatedMoveTickOf(MoveType moveType, float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTickOf(moveType, partialTicks);
    }

    public void setMovingFlag(MoveType type) {
        this.entityData.set(MOVE_FLAGS, (Object)((byte)type.ordinal()));
    }

    public MoveType getMoveFlag() {
        return MoveType.values()[(Byte)this.entityData.get(MOVE_FLAGS)];
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.ownerUUID != null) {
            tag.putUUID("Owner", this.ownerUUID);
        }
        tag.put("MainHandCache", this.mainHandCache.save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        tag.put("OffHandCache", this.offHandCache.save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.hasUUID("Owner")) {
            this.ownerUUID = tag.getUUID("Owner");
        }
        this.mainHandCache = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)tag.getCompound("MainHandCache"));
        this.offHandCache = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)tag.getCompound("OffHandCache"));
    }

    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{Hassan.THROW})) {
            if (anim.isAt("attack")) {
                this.throwItem(true);
            } else if (anim.isAt(0.84)) {
                this.throwItem(false);
            }
        } else {
            if (anim.is(new String[]{Hassan.SUMMON})) {
                return;
            }
            this.getNavigation().stop();
            if (this.getTarget() != null) {
                this.lookAt((Entity)this.getTarget(), 60.0f, 90.0f);
            }
            if (anim.isAt("attack")) {
                this.mobAttack(anim, this.getTarget(), this::doHurtTarget);
                this.targetPosition = null;
            }
        }
    }

    public boolean doHurtTarget(Entity entity) {
        return Utils.runWithInvulTimer((Entity)this, entity, this::runHurtTarget, 0);
    }

    private boolean runHurtTarget(Entity entity) {
        boolean behind;
        LivingEntity target;
        if (entity instanceof Mob && (target = ((Mob)entity).getTarget()) == this.getOwner()) {
            ((Mob)entity).setTarget((LivingEntity)this);
        }
        if (behind = Hassan.behind((Entity)this, entity)) {
            this.getAttribute(Attributes.ATTACK_DAMAGE).addTransientModifier(new AttributeModifier(BACKSTAB_MODIFIER, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        boolean hurt = super.doHurtTarget(entity);
        if (behind) {
            this.getAttribute(Attributes.ATTACK_DAMAGE).removeModifier(BACKSTAB_MODIFIER);
            if (hurt) {
                this.level().playSound(null, (Entity)this, SoundEvents.PLAYER_ATTACK_CRIT, this.getSoundSource(), 0.7f, 0.9f);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 15; ++i) {
                        serverLevel.sendParticles((ParticleOptions)DustParticleOptions.REDSTONE, entity.getRandomX(1.4), entity.getRandomY(), entity.getRandomZ(1.4), 0, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        return hurt;
    }

    public void mobAttack(AnimationState anim, LivingEntity target, Consumer<LivingEntity> cons) {
        OrientedBoundingBox obb = this.calculateAttackAABB(anim, this.targetPosition != null || target == null ? this.targetPosition : target.position(), 0.2);
        this.level().getEntitiesOfClass(LivingEntity.class, obb.getEncompassingBox(), entity -> this.targetPred.test((LivingEntity)entity) && obb.intersects(entity.getBoundingBox())).forEach(cons);
        if (!this.level().isClientSide) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)this);
        }
    }

    public OrientedBoundingBox prepareAttackBox(String anim, Entity target, double grow, boolean debug) {
        OrientedBoundingBox obb = this.calculateAttackAABB(this.getAnimationHandler().createDefaulted(anim), target != null ? target.position() : null, grow);
        if (debug) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTEMPT, (Entity)this);
        }
        return obb;
    }

    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, @Nullable Vec3 target, double grow) {
        float yRot = this.getYHeadRot();
        float xRot = this.getXRot();
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            yRot = player.getYHeadRot();
            xRot = player.getXRot();
        } else if (target != null) {
            Vec3 dir = target.subtract(this.position()).normalize();
            float[] yXRot = MathsHelper.YXRotFrom(dir);
            yRot = yXRot[0];
            xRot = -yXRot[1];
        }
        double off = (double)this.getBbHeight() * 0.5;
        return new OrientedBoundingBox(this.attackBB(anim).inflate(grow, 0.0, grow).move(0.0, -off, grow), yRot, Mth.clamp((float)xRot, (float)-15.0f, (float)15.0f), this.position().add(0.0, off, 0.0));
    }

    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() + 0.3;
        double length = 1.0;
        if (anim.is(new String[]{Hassan.DAGGER_1})) {
            width += 0.5;
            length += 0.4;
        }
        if (anim.is(new String[]{Hassan.DAGGER_2, Hassan.DAGGER_3})) {
            width += 0.7;
            length += 0.4;
        }
        if (anim.is(new String[]{Hassan.DAGGER_4})) {
            width += 0.3;
            length += 0.8;
        }
        if (anim.is(new String[]{Hassan.TOP_STAB})) {
            width += 0.2;
            length += 0.8;
        }
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    public AnimationHandler<HassanClone> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public Predicate<LivingEntity> validTargetPredicate() {
        return this.targetPred;
    }

    public boolean hurt(DamageSource damageSource, float damage) {
        if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(damageSource, damage);
        }
        if (damageSource.getEntity() == null || !damageSource.getEntity().getType().is(FateTags.EntityTypes.STRONG_MOB)) {
            damage = (float)((double)damage * 0.75);
        }
        if (damageSource.is(DamageTypeTags.IS_PROJECTILE) && !damageSource.is(DamageTypeTags.BYPASSES_ARMOR) && this.projectileBlockChance()) {
            this.level().playSound(null, this.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (damageSource.getDirectEntity() != null) {
                damageSource.getDirectEntity().remove(Entity.RemovalReason.KILLED);
            }
            return false;
        }
        return super.hurt(damageSource, Math.min(50.0f, damage));
    }

    public boolean projectileBlockChance() {
        return this.random.nextFloat() < (float)this.getAttributeValue(FateAttributes.PROJECTILE_BLOCK_CHANCE.asHolder());
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public Hassan getOwner() {
        if (!(this.owner != null && this.owner.isAlive() || this.getOwnerUUID() == null)) {
            this.owner = (Hassan)EntityUtils.findFromUUID(Hassan.class, (Level)this.level(), (UUID)this.getOwnerUUID());
        }
        return this.owner;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData data) {
        super.finalizeSpawn(world, difficulty, reason, data);
        this.populateDefaultEquipmentSlots(this.getRandom(), difficulty);
        for (EquipmentSlot type : EquipmentSlot.values()) {
            this.setDropChance(type, 0.0f);
        }
        if (reason == MobSpawnType.SPAWN_EGG || reason == MobSpawnType.MOB_SUMMONED) {
            this.getAnimationHandler().setAnimation(Hassan.SUMMON);
        }
        return data;
    }

    public void setOriginal(Hassan entityHassan) {
        this.ownerUUID = entityHassan.getUUID();
        this.owner = entityHassan;
    }

    protected void tickDeath() {
        Level level;
        if (this.level().isClientSide) {
            for (int i = 0; i < (int)(9.0f / (float)this.maxDeathTick() * (float)this.deathTime - 1.0f); ++i) {
                AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)FateParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.29803923f, 0.5019608f, 0.8117647f, 0.3f)).addData((AdvancedParticleData)new ScaleData(0.15f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.level(), this.getX(this.random.nextDouble() * 3.0 - 1.5), this.getY(this.random.nextDouble() * 3.0 - 1.5), this.getZ(this.random.nextDouble() * 3.0 - 1.5));
            }
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ++this.deathTime;
            if (this.deathTime == 1) {
                serverLevel.getServer().getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"fateubw.chat.servant.death").withStyle(ChatFormatting.RED), true);
                this.playSound(SoundEvents.WITHER_SPAWN, 1.0f, 1.0f);
            }
            if (this.deathTime == this.maxDeathTick()) {
                this.remove(Entity.RemovalReason.KILLED);
            }
        }
    }

    @Override
    public int maxDeathTick() {
        return 200;
    }

    public void throwItem(boolean main) {
        ThrownItemEntity item = new ThrownItemEntity(this.level(), (LivingEntity)this);
        item.setWeapon(this.getWeaponToThrowAndReplace(main));
        if (this.getTarget() != null) {
            item.shootAtEntity((Entity)this.getTarget(), 1.2f, 7 - this.level().getDifficulty().getId() * 2);
        } else {
            item.shootFromRotation((Entity)this, this.getXRot() + 5.0f, this.getYRot(), 0.0f, 1.2f, 1.0f);
        }
        this.playSound(SoundEvents.FISHING_BOBBER_THROW, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)item);
    }

    private ItemStack getWeaponToThrowAndReplace(boolean main) {
        ItemStack weapon;
        if (!main) {
            if (!this.getOffhandItem().isEmpty()) {
                this.offHandCache = this.getOffhandItem();
                this.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
                weapon = this.offHandCache;
            } else {
                weapon = this.getMainHandItem().isEmpty() ? this.mainHandCache.copy() : this.getMainHandItem();
            }
        } else {
            this.mainHandCache = this.getMainHandItem();
            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            weapon = this.mainHandCache;
        }
        return weapon.isEmpty() ? new ItemStack((ItemLike)FateItems.ASSASSIN_DAGGER.get()) : weapon.copy();
    }

    @Override
    public EntityWeaponTrailHolder<?> getTrailHolder() {
        return this.trailHolder;
    }

    @Override
    public EntityWeaponTrailHolderProvider.WeaponTrail weaponTrailEdge(boolean left) {
        return new EntityWeaponTrailHolderProvider.WeaponTrail(new Vector4f(0.0f, 0.0f, -0.2f, 1.0f), new Vector4f(0.0f, 0.0f, -0.6f, 1.0f));
    }
}

