/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.summons;

import io.github.flemmli97.fateubw.api.datapack.AttributeHolderProperties;
import io.github.flemmli97.fateubw.api.datapack.ServantExtraData;
import io.github.flemmli97.fateubw.common.datapack.DatapackHandler;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.misc.StarfishShot;
import io.github.flemmli97.fateubw.common.entity.utils.MoveStateTracker;
import io.github.flemmli97.fateubw.common.entity.utils.MoveType;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.fateubw.mixin.CombatTrackerAccessor;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetMoveToRestriction;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.AllApplicableBehaviours;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.util.BrainUtils;

public class LesserMonster
extends PathfinderMob
implements AnimatedEntity,
OwnableEntity,
SmartBrainOwner<LesserMonster> {
    protected static final EntityDataAccessor<Byte> MOVE_FLAGS = SynchedEntityData.defineId(LesserMonster.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String ATTACK = BUILDER.add("attack", AnimationsBuilder.definition((double)0.76).marker("attack", new double[]{0.52}));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private UUID ownerUUID;
    private LivingEntity owner;
    private int livingTicks;
    private final AnimationHandler<LesserMonster> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private final MoveStateTracker moveStateTracker = new MoveStateTracker(3, this::getMoveType);
    private final int maxLivingTicks;
    private boolean ranged;

    public LesserMonster(EntityType<? extends LesserMonster> type, Level level) {
        super(type, level);
        if (!level.isClientSide) {
            this.updateAttributes();
        }
        this.maxLivingTicks = DatapackHandler.SERVANT_PROPS.get((EntityType)FateEntities.GILLES.get()).getConfig(ServantExtraData.GILLES_MONSTER_DURATION);
    }

    public LesserMonster(Level level, LivingEntity owner) {
        this((EntityType<? extends LesserMonster>)((EntityType)FateEntities.LESSER_MONSTER.get()), level);
        this.owner = owner;
        this.ownerUUID = owner.getUUID();
    }

    protected void updateAttributes() {
        AttributeHolderProperties props = DatapackHandler.SERVANT_PROPS.getGeneric(this.getType());
        props.attributes().forEach((att, val) -> {
            AttributeInstance inst = this.getAttribute((Holder)att);
            if (inst != null) {
                inst.setBaseValue(val.doubleValue());
                if (att == Attributes.MAX_HEALTH) {
                    this.setHealth(this.getMaxHealth());
                }
            }
        });
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MOVE_FLAGS, (Object)0);
    }

    protected PathNavigation createNavigation(Level level) {
        return new SmoothGroundNavigation((Mob)this, level);
    }

    public void setRanged(boolean ranged) {
        this.ranged = ranged;
    }

    public List<? extends ExtendedSensor<? extends LesserMonster>> getSensors() {
        return List.of(new NearbyLivingEntitySensor().setPredicate((target, entity) -> !Utils.alliedTo((Entity)target, (Entity)entity)).setScanRate(e -> 10), new HurtBySensor().setPredicate((source, entity) -> {
            Entity patt0$temp = source.getEntity();
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)patt0$temp;
                return !Utils.alliedTo((Entity)entity, (Entity)attacker);
            }
            return true;
        }));
    }

    public BrainActivityGroup<? extends LesserMonster> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new FloatToSurfaceOfFluid(), this.lookBehaviour(), new LookAtTarget().runFor(entity -> entity.getRandom().nextIntBetweenInclusive(40, 100)).whenStopping(m -> BrainUtils.clearMemory((LivingEntity)m, (MemoryModuleType)MemoryModuleType.LOOK_TARGET))});
    }

    protected ExtendedBehaviour<? extends LesserMonster> lookBehaviour() {
        return new AllApplicableBehaviours(new ExtendedBehaviour[]{new LookAtAttackTarget(), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomLookTarget().lookChance((FloatProvider)ConstantFloat.of((float)1.0f)), new SetPlayerLookTarget()}).startCondition(m -> (double)m.getRandom().nextFloat() < 0.1 && !BrainUtils.hasMemory((LivingEntity)m, (MemoryModuleType)MemoryModuleType.WALK_TARGET))});
    }

    public BrainActivityGroup<? extends LesserMonster> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new MoveToWalkTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate(), new SetMoveToRestriction(), new SetRandomWalkTarget().startCondition(m -> m.getRandom().nextInt(120) == 0)})});
    }

    public BrainActivityGroup<? extends LesserMonster> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), SelectableBehaviourBuilder.builder().add(1, entity -> !entity.ranged, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).add(1, entity -> entity.ranged, new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(4.0).max(8.0), BehaviourUtils.moveTo()}).build().startCondition(BehaviourUtils::runCooldownBehaviour).stopIf(e -> !BehaviourUtils.runCooldownBehaviour(e)), AttackBehaviourBuilder.create().start(new String[]{ATTACK}).play(BehaviourUtils.cooldownedPlay(false, 10, 25)).condition(entity -> !entity.ranged).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveTo()}).end(1).start(new String[]{ATTACK}).play(BehaviourUtils.cooldownedPlay(false, 10, 25)).condition(entity -> entity.ranged).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(4.0).max(8.0)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveTo()}).end(1).build().startCondition(BehaviourUtils::runCombatBehaviour)});
    }

    protected Brain.Provider<?> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    public void baseTick() {
        super.baseTick();
        if (!this.level().isClientSide) {
            LivingEntity target;
            AnimationState anim;
            ++this.livingTicks;
            if (this.livingTicks > this.maxLivingTicks) {
                this.remove(Entity.RemovalReason.KILLED);
            }
            if ((anim = this.getAnimationHandler().getAnimation()) != null && anim.is(new String[]{ATTACK}) && anim.isAt("attack") && (target = this.getTarget()) != null) {
                if (this.ranged) {
                    this.shoot();
                } else if (this.getAttackBoundingBox().intersects(target.getBoundingBox())) {
                    this.doHurtTarget((Entity)target);
                }
            }
        }
        this.moveStateTracker.tick();
        this.getAnimationHandler().tick();
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        this.tickBrain((LivingEntity)this);
        if (this.getDeltaMovement().horizontalDistanceSqr() > 0.003 && this.isAlive() && !this.isImmobile()) {
            this.setMovingFlag(MoveType.RUN);
        } else {
            this.setMovingFlag(MoveType.NONE);
        }
    }

    public float interpolatedMoveTick(float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTick(partialTicks);
    }

    public void setMovingFlag(MoveType type) {
        this.entityData.set(MOVE_FLAGS, (Object)((byte)type.ordinal()));
    }

    public MoveType getMoveType() {
        return MoveType.values()[(Byte)this.entityData.get(MOVE_FLAGS)];
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Owner")) {
            this.ownerUUID = tag.getUUID("Owner");
        }
        this.ranged = tag.getBoolean("Ranged");
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.ownerUUID != null) {
            tag.putUUID("Owner", this.ownerUUID);
        }
        tag.putBoolean("Ranged", this.ranged);
    }

    public AnimationHandler<LesserMonster> getAnimationHandler() {
        return this.animationHandler;
    }

    public boolean doHurtTarget(Entity target) {
        float damage;
        LivingEntity living;
        List<CombatEntry> entries;
        boolean res = super.doHurtTarget(target);
        if (res && target instanceof LivingEntity && !(entries = ((CombatTrackerAccessor)(living = (LivingEntity)target).getCombatTracker()).getEntries()).isEmpty() && entries.getLast().source().getEntity() == this && (damage = Math.max(0.0f, entries.getLast().damage())) > 0.0f && this.getOwner() != null) {
            LivingEntity owner = this.getOwner();
            owner.heal(damage * 0.33f);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, owner.getX(), owner.getY() + (double)owner.getBbHeight() + 0.5, owner.getZ(), 0, 0.0, 0.1, 0.0, 0.0);
            }
        }
        return res;
    }

    public void shoot() {
        StarfishShot proj = new StarfishShot(this.level(), (LivingEntity)this);
        if (this.getTarget() != null) {
            Vec3 pos = this.getTarget().position();
            proj.shootAtPosition(pos.x(), this.getTarget().getY(0.5), pos.z(), 0.6f, 0.0f);
        } else {
            proj.shoot((Entity)this, this.getXRot() - 15.0f, this.getYRot(), 0.0f, 0.6f, 0.0f);
        }
        this.level().addFreshEntity((Entity)proj);
        this.playSound(SoundEvents.HONEY_BLOCK_BREAK, 1.0f, 1.0f);
    }

    public LivingEntity getOwner() {
        if (this.owner == null && this.ownerUUID != null) {
            this.owner = (LivingEntity)EntityUtils.findFromUUID(LivingEntity.class, (Level)this.level(), (UUID)this.ownerUUID);
        }
        return this.owner;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }
}

