/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.summons;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.api.datapack.AttributeHolderProperties;
import io.github.flemmli97.fateubw.common.datapack.DatapackHandler;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.SetTargetFromRider;
import io.github.flemmli97.fateubw.common.entity.utils.MoveStateTracker;
import io.github.flemmli97.fateubw.common.entity.utils.MoveType;
import io.github.flemmli97.fateubw.common.entity.utils.StandingVehicle;
import io.github.flemmli97.fateubw.common.network.S2CAttackDebug;
import io.github.flemmli97.fateubw.common.network.S2CScreenShake;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.TrailParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.ParticlePositionProvider;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.utils.MathsHelper;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.AOEAttackEntity;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetMoveToRestriction;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedMobDataHandler;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.AllApplicableBehaviours;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.SequentialBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomFlyingTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.navigation.SmoothFlyingPathNavigation;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class Pegasus
extends PathfinderMob
implements AnimatedEntity,
StandingVehicle,
AOEAttackEntity,
SyncedMobDataHandler,
SmartBrainOwner<Pegasus> {
    public static float PORTAL_SIZE = 2.0f;
    public static float PORTAL_OFFSET = 1.3f;
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(Pegasus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> MOVE_FLAGS = SynchedEntityData.defineId(Pegasus.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final TypedResource<Vec3> CHARGE_MOTION = new TypedResource(Fate.modRes("charge_motion"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String CHARGING = BUILDER.add("charge", AnimationsBuilder.definition((double)1.2).marker("charge_start", new double[]{0.36}).marker("charge_end", new double[]{1.0}));
    public static final String STOMP = BUILDER.add("stomp", AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.4}));
    public static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)2.04).marker("seated", new double[]{1.04}));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    public final Predicate<LivingEntity> targetPred = target -> {
        Mob mob;
        if (target == this) {
            return false;
        }
        if (this.getTarget() == target) {
            return true;
        }
        Entity patt0$temp = this.getFirstPassenger();
        if (patt0$temp instanceof Mob && target == (mob = (Mob)patt0$temp).getTarget()) {
            return true;
        }
        Entity patt1$temp = this.getFirstPassenger();
        if (patt1$temp instanceof BaseServant) {
            BaseServant servant = (BaseServant)patt1$temp;
            return servant.targetPred.test((LivingEntity)target);
        }
        return this.canAttack((LivingEntity)target) && !this.hasPassenger((Entity)target);
    };
    private final AnimationHandler<Pegasus> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (!this.level().isClientSide && anim != null && anim.is(new String[]{CHARGING})) {
            this.hitEntities = new ArrayList<Entity>();
            this.setChargeMotion(null);
        }
        return false;
    });
    private final PathNavigation main;
    private final PathNavigation flyingNavigator;
    private int flyTimer;
    private final SyncedDataContainer<Pegasus> syncedDataContainer = SyncedDataContainer.builder((Entity)this).define(CHARGE_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null).build();
    private List<Entity> hitEntities = new ArrayList<Entity>();
    private final MoveStateTracker moveStateTracker = new MoveStateTracker(2, this::getMoveType);

    public Pegasus(EntityType<? extends Pegasus> type, Level level) {
        super(type, level);
        if (!level.isClientSide) {
            this.updateAttributes();
        }
        this.main = this.navigation;
        this.flyingNavigator = this.createFlyNavigator(level);
        this.moveControl = new PegasusMoveController(this);
    }

    private void updateAttributes() {
        AttributeHolderProperties props = DatapackHandler.SERVANT_PROPS.getGeneric(this.getType());
        props.attributes().forEach((att, val) -> {
            AttributeInstance inst = this.getAttribute((Holder)att);
            if (inst != null) {
                inst.setBaseValue(val.doubleValue());
                if (att == Attributes.MAX_HEALTH) {
                    this.setHealth(this.getMaxHealth());
                }
            }
        });
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLYING, (Object)false);
        builder.define(MOVE_FLAGS, (Object)0);
    }

    public SyncedDataContainer<?> getDataContainer() {
        return this.syncedDataContainer;
    }

    protected PathNavigation createFlyNavigator(Level level) {
        return new SmoothFlyingPathNavigation(this, (Mob)this, level){

            public boolean isStableDestination(BlockPos pos) {
                return true;
            }
        };
    }

    protected PathNavigation createNavigation(Level level) {
        return new SmoothGroundNavigation((Mob)this, level);
    }

    public List<? extends ExtendedSensor<? extends Pegasus>> getSensors() {
        return List.of();
    }

    public BrainActivityGroup<? extends Pegasus> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new FloatToSurfaceOfFluid(), new SetTargetFromRider()});
    }

    public BrainActivityGroup<? extends Pegasus> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new MoveToWalkTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate(), new SetMoveToRestriction(), new SetRandomWalkTarget().startCondition(m -> m.getRandom().nextInt(120) == 0)})});
    }

    public BrainActivityGroup<? extends Pegasus> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), this.getCooldownAI().startCondition(BehaviourUtils::runCooldownBehaviour).stopIf(e -> !BehaviourUtils.runCooldownBehaviour(e)), this.getCombatAI().startCondition(BehaviourUtils::runCombatBehaviour)});
    }

    public ExtendedBehaviour<? extends Pegasus> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{STOMP}).play(BehaviourUtils.cooldownedPlay(true, 20, 45)).condition(entity -> !entity.canFly()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(6).start(new String[]{CHARGING}).play(BehaviourUtils.cooldownedPlay(false, 20, 50)).condition(entity -> !entity.canFly()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(10.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack(40, 70)}).prepare(new ExtendedBehaviour[]{new ChargeBehaviour()}).end(6).start(new String[]{CHARGING}).play(BehaviourUtils.cooldownedPlay(false, 20, 50)).condition(entity -> !entity.canFly() && BehaviourUtils.ifFurtherThan(7.0).test(entity)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(10.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack(40, 70)}).prepare(new ExtendedBehaviour[]{new ChargeBehaviour()}).end(7).start(new String[]{CHARGING}).play(BehaviourUtils.cooldownedPlay(false, 80, 160)).condition(Pegasus::canFly).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(10.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack(40, 70)}).prepare(new ExtendedBehaviour[]{new ChargeBehaviour()}).end(5).build();
    }

    public ExtendedBehaviour<? extends Pegasus> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(7, BehaviourUtils.withCondition(entity -> !entity.canFly()), new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).add(5, BehaviourUtils.withCondition(entity -> !entity.canFly() && BehaviourUtils.ifCloserThan(7.0).test(entity)), new ExtendedBehaviour[]{new SetRandomWalkTarget().setRadius(12.0, 5.0), BehaviourUtils.moveTo()}).add(4, BehaviourUtils.withCondition(entity -> !entity.canFly() && BehaviourUtils.ifCloserThan(4.0).test(entity)), new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().radius(6.0), BehaviourUtils.moveTo()}).add(5, BehaviourUtils.withCondition(Pegasus::canFly), new ExtendedBehaviour[]{new AllApplicableBehaviours(new ExtendedBehaviour[]{new SequentialBehaviour(new ExtendedBehaviour[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(BehaviourUtils.closeEnough(8)).startCondition(BehaviourUtils.ifFurtherThan(8.0)), new RandomPositionAroundTarget()}), BehaviourUtils.moveTo()}), new LookAtTarget(), new LookAtAttackTarget()})}).build();
    }

    protected Brain.Provider<?> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    public void tick() {
        super.tick();
        this.getAnimationHandler().tick();
        if (this.level().isClientSide) {
            Vec3 pos;
            double upScale;
            double sideScale;
            int i;
            Vec3 base;
            if (this.getAnimationHandler().isCurrent(new String[]{SUMMON})) {
                base = Vec3.directionFromRotation((float)0.0f, (float)this.yBodyRot).scale((double)(-PORTAL_OFFSET));
                Vec3 base2 = base.yRot(1.5707964f).normalize();
                for (i = 0; i < 4; ++i) {
                    sideScale = (this.random.nextDouble() - this.random.nextDouble()) * (double)PORTAL_SIZE;
                    upScale = (this.random.nextDouble() - this.random.nextDouble()) * (double)PORTAL_SIZE + (double)PORTAL_SIZE;
                    pos = this.position().add(base).add(base2.scale(sideScale)).add(new Vec3(0.0, 1.0, 0.0).scale(upScale));
                    AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)FateParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.9607843f, 0.039215688f, 0.039215688f, 0.5f)).addData((AdvancedParticleData)new ScaleData(0.5f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.01, this.random.nextGaussian() * 0.01, this.random.nextGaussian() * 0.01)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.level(), pos.x(), pos.y(), pos.z());
                }
            }
            if (this.getAnimationHandler().isCurrent(new String[]{CHARGING}) && this.getAnimationHandler().getAnimation().isPast("attack")) {
                base = Vec3.directionFromRotation((float)0.0f, (float)this.yBodyRot).yRot(1.5707964f).normalize();
                Vec3 dir = this.getDeltaMovement().scale(-0.23);
                for (i = 0; i < 9; ++i) {
                    sideScale = (this.random.nextDouble() * 2.0 - 1.0) * 3.0;
                    upScale = this.random.nextDouble() * 2.0 - 1.0;
                    pos = this.position().add(base.scale(sideScale)).add(new Vec3(0.0, 1.0, 0.0).scale(upScale));
                    float r = (float)(235 + this.getRandom().nextInt(10)) / 255.0f;
                    float g = (float)(235 + this.getRandom().nextInt(10)) / 255.0f;
                    float b = 0.9607843f;
                    float scale = (float)(0.01 + this.getRandom().nextDouble() * 0.01);
                    AdvancedParticleContainer.make((ParticleOptions)new TrailParticleData((ParticleType<TrailParticleData>)((ParticleType)FateParticles.TRAIL.get()), TrailInfo.builder(new ParticlePositionProvider.ParticlePositionData(8)).setColor(r, g, b, 0.4f).setColor2(r, g, b, 0.4f).setWidth(scale).setWidth2(scale).build())).addData((AdvancedParticleData)new MotionData(dir)).addData((AdvancedParticleData)new ParticleMetaData(8 + this.getRandom().nextInt(8), false, 0.0f)).add(this.level(), pos.x(), pos.y(), pos.z());
                }
            }
        }
        if (!this.level().isClientSide) {
            this.getAnimationHandler().runIfNotNull(this::handleAttack);
            if (this.getTarget() == null || !this.getTarget().isAlive()) {
                if (this.canFly()) {
                    this.setCanFly(false);
                }
            } else if (--this.flyTimer <= 0) {
                if (this.canFly()) {
                    this.flyTimer = 400 + this.getRandom().nextInt(300);
                    this.setCanFly(false);
                } else {
                    this.flyTimer = 250 + this.getRandom().nextInt(350);
                    this.setCanFly(true);
                }
            }
        }
        this.moveStateTracker.tick();
        Vec3 lookDir = this.directionToLookAt();
        if (lookDir != null) {
            float[] yxRot = MathsHelper.YXRotFrom(lookDir);
            this.setYRot(MathsHelper.rotlerp(this.getYRot(), yxRot[0], 30.0f));
            this.setXRot(MathsHelper.rotlerp(this.getXRot(), yxRot[1], 30.0f));
            this.setYBodyRot(this.getYRot());
            this.setYHeadRot(this.getYRot());
        }
    }

    private Vec3 directionToLookAt() {
        if (this.isCharging()) {
            return this.getChargeMotion();
        }
        return null;
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        this.tickBrain((LivingEntity)this);
        if (!this.onGround()) {
            this.setMovingFlag(MoveType.FLY);
        } else if (!(this.getControllingPassenger() instanceof Player) && this.getDeltaMovement().horizontalDistanceSqr() > 0.003 && this.isAlive()) {
            double speedMod = this.getMoveControl().getSpeedModifier();
            MoveType move = speedMod > 1.0 || speedMod >= 1.0 && this.getTarget() != null ? MoveType.RUN : (speedMod <= 0.8 ? MoveType.SNEAK : MoveType.WALK);
            if (this.isImmobile()) {
                move = MoveType.NONE;
            }
            this.setMovingFlag(move);
        } else {
            this.setMovingFlag(MoveType.NONE);
            this.setShiftKeyDown(false);
            this.setSprinting(false);
        }
    }

    public void setMovingFlag(MoveType type) {
        this.entityData.set(MOVE_FLAGS, (Object)((byte)type.ordinal()));
    }

    public MoveType getMoveType() {
        return MoveType.values()[(Byte)this.entityData.get(MOVE_FLAGS)];
    }

    public float interpolatedMoveTick(float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTick(partialTicks);
    }

    public float interpolatedMoveTickOf(MoveType type, float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTickOf(type, partialTicks);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Flying", this.canFly());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setCanFly(compound.getBoolean("Flying"));
    }

    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{CHARGING})) {
            if (anim.isPast("charge_start") && !anim.isPast("charge_end")) {
                boolean hit;
                Vec3 dir = this.getChargeMotion();
                if (dir == null) {
                    this.setChargeTo(this.position().add(this.getViewVector(1.0f).scale(10.0)));
                    dir = this.getChargeMotion();
                }
                this.setDeltaMovement(dir);
                OrientedBoundingBox obb = this.prepareAttackBox(anim.getAnimation(), null, 0.2, false);
                List list = this.level().getEntitiesOfClass(LivingEntity.class, obb.getEncompassingBox(), entity -> this.targetPred.test((LivingEntity)entity) && obb.intersects(entity.getBoundingBox()));
                boolean bl = hit = this.canFly() && this.verticalCollision;
                if (hit) {
                    this.setChargeMotion(new Vec3(dir.x() * 0.4, Math.abs(dir.y()) * 0.7, dir.z() * 0.4));
                }
                for (LivingEntity e : list) {
                    if (this.hitEntities.contains(e) || !e.hurt(FateDamageTypes.direct(FateDamageTypes.PEGASUS_CHARGE, (Entity)this), (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE))) continue;
                    if (this.hitEntities.isEmpty()) {
                        hit = true;
                    }
                    this.hitEntities.add((Entity)e);
                }
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)this);
                if (hit) {
                    S2CScreenShake.sendAround((Entity)this, 14.0, 8, 2.0f);
                }
            }
        } else if (!anim.is(new String[]{SUMMON})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                this.mobAttack(anim, this.getTarget(), this::doHurtTarget);
                S2CScreenShake.sendAround((Entity)this, 6.0, 8, 2.0f);
            }
        }
    }

    public void mobAttack(AnimationState anim, LivingEntity target, Consumer<LivingEntity> cons) {
        OrientedBoundingBox obb = this.prepareAttackBox(anim.getAnimation(), (Entity)target, 0.2, false);
        this.level().getEntitiesOfClass(LivingEntity.class, obb.getEncompassingBox(), entity -> this.targetPred.test((LivingEntity)entity) && obb.intersects(entity.getBoundingBox())).forEach(cons);
        if (!this.level().isClientSide) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)this);
        }
    }

    public OrientedBoundingBox prepareAttackBox(String anim, Entity target, double grow, boolean debug) {
        OrientedBoundingBox obb = this.calculateAttackAABB(this.getAnimationHandler().createDefaulted(anim), target != null ? target.position() : null, grow);
        if (debug) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTEMPT, (Entity)this);
        }
        return obb;
    }

    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, @Nullable Vec3 target, double grow) {
        if (anim.is(new String[]{CHARGING})) {
            AABB aabb = OrientedBoundingBox.originAABB((Entity)this).inflate(grow).expandTowards(this.getDeltaMovement());
            return new OrientedBoundingBox(aabb, this.getYRot(), 0.0f, this.position());
        }
        double width = (double)this.getBbWidth() * 0.5 + 1.5;
        AABB aabb = new AABB(-width * 0.8, -0.02, -width * 0.5, width * 0.8, (double)this.getBbHeight() * 0.5, width * 1.2).inflate(grow);
        return new OrientedBoundingBox(aabb, this.getYRot(), 0.0f, this.position());
    }

    public boolean doHurtTarget(Entity entity) {
        return Utils.runWithInvulTimer((Entity)this, entity, x$0 -> super.doHurtTarget(x$0), 0);
    }

    public AnimationHandler<Pegasus> getAnimationHandler() {
        return this.animationHandler;
    }

    public boolean isCharging() {
        if (this.getAnimationHandler() == null) {
            return false;
        }
        AnimationState anim = this.getAnimationHandler().getAnimation();
        return anim != null && anim.is(new String[]{CHARGING}) && anim.isPast("attack");
    }

    public Vec3 getChargeMotion() {
        return (Vec3)this.getDataContainer().get(CHARGE_MOTION);
    }

    public void setChargeTo(Vec3 pos) {
        Vec3 dir = pos.subtract(this.position());
        if (!this.canFly()) {
            if ((dir = new Vec3(dir.x(), 0.0, dir.z())).lengthSqr() > 1.6900000000000002) {
                dir = dir.normalize().scale(1.3);
            }
        } else if ((dir = dir.scale(0.21)).lengthSqr() > 2.8899999999999997) {
            dir = dir.normalize().scale(1.7);
        }
        this.setChargeMotion(dir);
    }

    public void setChargeMotion(Vec3 chargeMotion) {
        this.getDataContainer().set(CHARGE_MOTION, (Object)chargeMotion);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean hurt(DamageSource damageSource, float damage) {
        if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(damageSource, damage);
        }
        if (this.getAnimationHandler().isCurrent(new String[]{SUMMON})) {
            return false;
        }
        if (this.isCharging()) {
            damage *= 0.5f;
        }
        return super.hurt(damageSource, damage);
    }

    protected boolean isImmobile() {
        return super.isImmobile() | this.getAnimationHandler().isCurrent(new String[]{SUMMON});
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        SpawnGroupData data = super.finalizeSpawn(level, difficulty, reason, spawnData);
        if (reason == MobSpawnType.SPAWN_EGG || reason == MobSpawnType.MOB_SUMMONED) {
            this.getAnimationHandler().setAnimation(SUMMON);
        }
        return data;
    }

    public void setCanFly(boolean flag) {
        this.entityData.set(FLYING, (Object)flag);
        this.setNoGravity(flag);
        this.navigation.stop();
        this.navigation = flag ? this.flyingNavigator : this.main;
        this.setDeltaMovement(this.getDeltaMovement().scale(0.3));
    }

    public boolean canFly() {
        return (Boolean)this.entityData.get(FLYING);
    }

    @Override
    public boolean shouldStand() {
        AnimationState anim = this.getAnimationHandler().getAnimation();
        return anim != null && anim.is(new String[]{SUMMON}) && !anim.isPast(1.0);
    }

    class PegasusMoveController
    extends MoveControl {
        public PegasusMoveController(Pegasus pegasus) {
            super((Mob)pegasus);
        }

        public void tick() {
            LivingEntity target;
            MoveControl.Operation op = this.operation;
            if (this.operation == MoveControl.Operation.MOVE_TO && Pegasus.this.canFly()) {
                this.operation = MoveControl.Operation.WAIT;
                BlockPos targetPos = this.mob.getNavigation().getTargetPos();
                if (targetPos == null) {
                    return;
                }
                float speed = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.FLYING_SPEED));
                Vec3 target2 = Vec3.atCenterOf((Vec3i)targetPos);
                double dX = target2.x() - this.mob.getX();
                double dY = target2.y() - this.mob.getY();
                double dZ = target2.z() - this.mob.getZ();
                double horDist = Math.sqrt(dX * dX + dZ * dZ);
                if (Math.abs(horDist) > 0.5) {
                    double h = 1.0 - Math.abs(dY * (double)0.7f) / horDist;
                    horDist = Math.sqrt((dX *= h) * dX + (dZ *= h) * dZ);
                    double dist = Math.sqrt(dX * dX + dZ * dZ + dY * dY);
                    float targetYRot = (float)Mth.wrapDegrees((double)(Mth.atan2((double)dZ, (double)dX) * 57.2957763671875)) - 90.0f;
                    float targetXRot = (float)Mth.wrapDegrees((double)(Mth.atan2((double)dY, (double)horDist) * 57.2957763671875));
                    this.mob.setYRot(targetYRot);
                    this.mob.yBodyRot = this.mob.getYRot();
                    this.mob.setXRot(targetXRot);
                    float yRot = this.mob.getYRot() + 90.0f;
                    double x = (double)(speed * Mth.cos((float)(yRot * ((float)Math.PI / 180)))) * Math.abs(dX / dist);
                    double y = (double)(speed * Mth.sin((float)(targetXRot * ((float)Math.PI / 180)))) * Math.abs(dY / dist);
                    double z = (double)(speed * Mth.sin((float)(yRot * ((float)Math.PI / 180)))) * Math.abs(dZ / dist);
                    Vec3 vec3 = this.mob.getDeltaMovement();
                    this.mob.setDeltaMovement(vec3.add(new Vec3(x, y, z).subtract(vec3).scale(0.1)));
                }
            } else {
                super.tick();
            }
            if (Pegasus.this.canFly() && (target = this.mob.getTarget()) != null) {
                if (target.distanceToSqr((Entity)this.mob) < 576.0) {
                    this.mob.lookAt((Entity)target, 60.0f, 30.0f);
                }
                if (op == MoveControl.Operation.WAIT) {
                    if (!Pegasus.this.getAnimationHandler().hasAnimation() && this.mob.getY() < target.getY() + (double)target.getBbHeight() + 2.5) {
                        Vec3 delta = this.mob.getDeltaMovement().add(0.0, 0.02, 0.0);
                        if (delta.y() > 0.14) {
                            delta = new Vec3(delta.x(), 0.14, delta.z());
                        }
                        this.mob.setDeltaMovement(delta);
                    } else {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().scale(0.98));
                    }
                }
            }
        }
    }

    public static class ChargeBehaviour
    extends ExtendedBehaviour<Pegasus> {
        private static final MemoryTest MEMORIES = MemoryTest.builder((int)1).hasMemories(new MemoryModuleType[]{MemoryModuleType.ATTACK_TARGET});
        private Vec3 targetPos;

        protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return MEMORIES;
        }

        protected boolean shouldKeepRunning(Pegasus entity) {
            double dX = this.targetPos.x() - entity.getX();
            double dZ = this.targetPos.z() - entity.getZ();
            float yRot = MathsHelper.YRotFrom(dX, dZ);
            float diffY = Mth.degreesDifference((float)entity.getYRot(), (float)yRot);
            if (Math.abs(diffY) < 32.0f) {
                entity.setChargeTo(this.targetPos);
                return false;
            }
            return true;
        }

        protected void start(Pegasus entity) {
            this.targetPos = BrainUtils.getTargetOfEntity((LivingEntity)entity).getEyePosition();
        }

        protected void tick(Pegasus entity) {
            super.tick((LivingEntity)entity);
            double dY = this.targetPos.y() - entity.getEyeY();
            double dX = this.targetPos.x() - entity.getX();
            double dZ = this.targetPos.z() - entity.getZ();
            float[] yXRot = MathsHelper.YXRotFrom(dX, dY, dZ);
            entity.setYRot(MathsHelper.rotlerp(entity.getYRot(), yXRot[0], 20.0f));
            entity.setXRot(MathsHelper.rotlerp(entity.getXRot(), yXRot[1], 30.0f));
            entity.setYBodyRot(entity.getYRot());
            entity.setYHeadRot(entity.getYRot());
        }
    }

    public static class RandomPositionAroundTarget<E extends PathfinderMob>
    extends SetRandomFlyingTarget<E> {
        private static final MemoryTest MEMORIES = MemoryTest.builder((int)2).noMemory(MemoryModuleType.WALK_TARGET).hasMemories(new MemoryModuleType[]{MemoryModuleType.ATTACK_TARGET});

        protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return MEMORIES;
        }

        protected Vec3 getTargetPos(E entity) {
            LivingEntity target = BrainUtils.getTargetOfEntity(entity);
            if (target == null) {
                return null;
            }
            for (int i = 0; i < 10; ++i) {
                double x = target.getX() + entity.getRandom().nextDouble() * 10.0 - 5.0;
                double y = target.getEyeY() + 3.0 + entity.getRandom().nextDouble() * 4.0;
                double z = target.getZ() + entity.getRandom().nextDouble() * 10.0 - 5.0;
                BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
                if (GoalUtils.isOutsideLimits((BlockPos)(blockPos = RandomPos.moveUpOutOfSolid((BlockPos)blockPos, (int)entity.level().getMaxBuildHeight(), pos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)pos))), entity) || GoalUtils.isRestricted((boolean)true, entity, (BlockPos)blockPos) || GoalUtils.hasMalus(entity, (BlockPos)blockPos)) continue;
                return new Vec3(x, y, z);
            }
            return null;
        }
    }
}

