/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.summons;

import io.github.flemmli97.fateubw.api.datapack.ServantExtraData;
import io.github.flemmli97.fateubw.common.datapack.DatapackHandler;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.network.S2CAttackDebug;
import io.github.flemmli97.fateubw.common.network.S2CScreenShake;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Tentacle
extends Entity
implements AnimatedEntity,
TraceableEntity {
    public static final float SCALE = 1.75f;
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String SLAM = BUILDER.add("slam", AnimationsBuilder.definition((double)2.4).marker("attack", new double[]{1.56}).marker("can_despawn", new double[]{1.84}));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Tentacle> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private UUID ownerUuid;
    private LivingEntity owner;

    public Tentacle(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
    }

    public Tentacle setOwner(LivingEntity owner) {
        this.owner = owner;
        this.ownerUuid = this.owner != null ? this.owner.getUUID() : null;
        return this;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("Owner")) {
            this.ownerUuid = compound.getUUID("Owner");
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (this.ownerUuid != null) {
            compound.putUUID("Shooter", this.ownerUuid);
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d = this.getBoundingBoxForCulling().getSize();
        if (Double.isNaN(d)) {
            d = 1.0;
        }
        return distance < (d *= 64.0 * Tentacle.getViewScale()) * d;
    }

    public AABB getBoundingBoxForCulling() {
        return super.getBoundingBoxForCulling().inflate(3.5, 7.0, 3.5);
    }

    public void baseTick() {
        AnimationState anim;
        if (!this.level().isClientSide && !this.getAnimationHandler().hasAnimation()) {
            this.remove(Entity.RemovalReason.KILLED);
            return;
        }
        super.baseTick();
        this.getAnimationHandler().tick();
        if (!this.level().isClientSide && (anim = this.getAnimationHandler().getAnimation()) != null && anim.is(new String[]{SLAM}) && anim.isAt("attack")) {
            Predicate<LivingEntity> predicate;
            double width = 2.975;
            double len = 7.875;
            double height = 3.8500000000000005;
            AABB aabb = new AABB(-width * 0.5, -0.03, 0.0, width * 0.5, height + 0.003, len);
            OrientedBoundingBox obb = new OrientedBoundingBox(aabb, -this.getYRot(), 0.0f, this.position());
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, this);
            float damage = DatapackHandler.SERVANT_PROPS.get((EntityType)FateEntities.GILLES.get()).getConfig(ServantExtraData.GILLES_TENTACLE_DAMAGE).floatValue();
            LivingEntity livingEntity = this.getOwner();
            if (livingEntity instanceof BaseServant) {
                BaseServant servant = (BaseServant)livingEntity;
                predicate = servant.targetPred;
            } else {
                predicate = e -> true;
            }
            Predicate<LivingEntity> pred = predicate;
            this.level().getEntitiesOfClass(LivingEntity.class, obb.getEncompassingBox(), entity -> pred.test((LivingEntity)entity) && obb.intersects(entity.getBoundingBox())).forEach(e -> e.hurt(this.damageSources().mobProjectile((Entity)this, this.getOwner()), damage));
            S2CScreenShake.sendAround(this, 16.0, 8, 4.0f);
            this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.0f, 0.7f);
        }
    }

    public LivingEntity getOwner() {
        if (this.owner != null && !this.owner.isRemoved()) {
            return this.owner;
        }
        if (this.ownerUuid != null) {
            this.owner = (LivingEntity)EntityUtils.findFromUUID(LivingEntity.class, (Level)this.level(), (UUID)this.ownerUuid);
        }
        return this.owner;
    }

    public AnimationHandler<?> getAnimationHandler() {
        return this.animationHandler;
    }

    public void setup(Vec3 target) {
        this.getAnimationHandler().setAnimation(SLAM);
        Vec3 dir = target.subtract(this.position());
        dir = dir.lengthSqr() < 1.0E-4 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(dir.x(), 0.0, dir.z()).normalize();
        dir = dir.scale(3.0).yRot(this.getRandom().nextFloat() * ((float)Math.PI * 2));
        this.setPos(this.position().add(dir));
        this.setDeltaMovement(dir);
        double f = Math.sqrt(dir.horizontalDistance());
        this.setYRot((float)(Mth.atan2((double)dir.x, (double)dir.z) * 57.29577951308232) - 180.0f);
        this.setXRot((float)(Mth.atan2((double)dir.y, (double)f) * 57.29577951308232));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public float getDespawnProgress(float partialTicks) {
        AnimationState anim = this.getAnimationHandler().getAnimation();
        if (anim == null) {
            return 1.0f;
        }
        if (!anim.isPast("can_despawn")) {
            return -1.0f;
        }
        return (float)anim.progress(anim.getMarker("can_despawn", 0) * 20.0, anim.getLength(), partialTicks, 0);
    }
}

