/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.utils;

import io.github.flemmli97.fateubw.common.entity.utils.MoveType;
import java.util.function.Supplier;
import net.minecraft.util.Mth;

public class MoveStateTracker {
    private final int transitionTime;
    private final Supplier<MoveType> currentState;
    private final int[] states = new int[MoveType.values().length];
    private int genericMoveTick;

    public MoveStateTracker(int transitionTime, Supplier<MoveType> currentState) {
        this.transitionTime = transitionTime;
        this.currentState = currentState;
    }

    public void tick() {
        MoveType current = this.currentState.get();
        for (int i = 0; i < this.states.length; ++i) {
            if (i == current.ordinal()) {
                int n = i;
                int n2 = this.states[n] + 1;
                this.states[n] = n2;
                this.states[i] = Math.min(this.transitionTime, n2);
                continue;
            }
            int n = i;
            int n3 = this.states[n] - 1;
            this.states[n] = n3;
            this.states[i] = Math.max(-1, n3);
        }
        this.genericMoveTick = current != MoveType.NONE ? Math.min(this.transitionTime, ++this.genericMoveTick) : Math.max(-1, --this.genericMoveTick);
    }

    public float interpolatedMoveTickOf(MoveType moveType, float partialTicks) {
        int tick = this.states[moveType.ordinal()];
        if (tick == -1) {
            return 0.0f;
        }
        MoveType current = this.currentState.get();
        return Mth.clamp((float)(((float)tick + (current == moveType ? partialTicks : -partialTicks)) / (float)this.transitionTime), (float)0.0f, (float)1.0f);
    }

    public float interpolatedMoveTick(float partialTicks) {
        if (this.genericMoveTick == -1) {
            return 0.0f;
        }
        MoveType current = this.currentState.get();
        return Mth.clamp((float)(((float)this.genericMoveTick + (current != MoveType.NONE ? partialTicks : -partialTicks)) / (float)this.transitionTime), (float)0.0f, (float)1.0f);
    }
}

