/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.event;

import io.github.flemmli97.fateubw.common.attachment.PlayerData;
import io.github.flemmli97.fateubw.common.effects.PetrificationEffect;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.lib.FateTags;
import io.github.flemmli97.fateubw.common.network.S2CPlayerCap;
import io.github.flemmli97.fateubw.common.registry.FateAttributes;
import io.github.flemmli97.fateubw.common.registry.FateMobEffects;
import io.github.flemmli97.fateubw.common.utils.ExtendedCombatRules;
import io.github.flemmli97.fateubw.common.world.GrailTeam;
import io.github.flemmli97.fateubw.common.world.TeamHandler;
import io.github.flemmli97.fateubw.mixin.CombatTrackerAccessor;
import io.github.flemmli97.fateubw.platform.Platform;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;

public class EventCalls {
    public static void joinWorld(ServerPlayer player) {
        List<GrailTeam.ShortTeamInfo> requests;
        LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CPlayerCap(Platform.INSTANCE.getPlayerData((Player)player)), player);
        TeamHandler teamHandler = TeamHandler.get(player.getServer());
        List<GrailTeam.ShortTeamInfo> invites = teamHandler.fetchInvitesFor((Player)player);
        if (!invites.isEmpty()) {
            player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.team.invite.pending", (Object[])new Object[]{String.join((CharSequence)",", invites.stream().map(GrailTeam.ShortTeamInfo::name).toList())}).withStyle(ChatFormatting.GOLD));
        }
        if (!(requests = teamHandler.fetchRequestsFor((Player)player, teamHandler.getTeamFor((Player)player))).isEmpty()) {
            player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.team.alliance.pending", (Object[])new Object[]{String.join((CharSequence)",", requests.stream().map(GrailTeam.ShortTeamInfo::name).toList())}).withStyle(ChatFormatting.GOLD));
        }
    }

    public static void tick(LivingEntity entity) {
        Mob mob;
        boolean target;
        AttributeInstance att;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Platform.INSTANCE.getPlayerData((Player)player).tick();
        }
        if (!entity.level().isClientSide && entity.isAlive() && entity.tickCount % 20 == 0 && (att = entity.getAttribute((target = entity instanceof Mob && (mob = (Mob)entity).getTarget() != null) || ((CombatTrackerAccessor)entity.getCombatTracker()).getInCombat() ? FateAttributes.COMBAT_REGEN.asHolder() : FateAttributes.PASSIVE_REGEN.asHolder())) != null) {
            entity.heal((float)att.getValue());
        }
    }

    public static void clone(Player origin, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerData data = Platform.INSTANCE.getPlayerData(origin);
            Platform.INSTANCE.getPlayerData(player).load(data.save(new CompoundTag()));
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CPlayerCap(Platform.INSTANCE.getPlayerData((Player)serverPlayer)), serverPlayer);
        }
    }

    public static boolean canHeal(LivingEntity entity) {
        return !entity.hasEffect(FateMobEffects.GAE_BUIDHE.asHolder());
    }

    public static boolean onHurt(LivingEntity entity, DamageSource damageSource, float damage) {
        AttributeInstance att;
        MobEffectInstance eff;
        if (damageSource.getEntity() instanceof LivingEntity && (eff = entity.getEffect(FateMobEffects.PETRIFICATION.asHolder())) != null && eff.getAmplifier() >= PetrificationEffect.MAX_PROGRESS) {
            entity.removeEffect(eff.getEffect());
            entity.hurt(damageSource, damage * 2.0f);
            return true;
        }
        if (damageSource.is(DamageTypeTags.IS_PROJECTILE) && !damageSource.is(DamageTypeTags.BYPASSES_ARMOR) && (att = entity.getAttribute(FateAttributes.PROJECTILE_BLOCK_CHANCE.asHolder())) != null && (double)entity.getRandom().nextFloat() < att.getValue()) {
            entity.level().playSound(null, entity.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (damageSource.getDirectEntity() != null) {
                damageSource.getDirectEntity().remove(Entity.RemovalReason.KILLED);
            }
            return true;
        }
        return false;
    }

    public static float damageCalculation(LivingEntity livingEntity, DamageSource damageSrc, float damageAmount) {
        if (damageSrc.is(DamageTypeTags.IS_PROJECTILE)) {
            damageAmount = ExtendedCombatRules.projectileReduce(livingEntity, damageAmount);
        }
        if (damageSrc.is(FateTags.DamageTypes.IS_MAGIC)) {
            damageAmount = ExtendedCombatRules.getDamageAfterMagicProtection(livingEntity, damageAmount);
        }
        return damageAmount;
    }

    public static void damagePost(LivingEntity livingEntity, DamageSource damageSrc, float damageAmount) {
        if (damageAmount > 0.0f) {
            Entity entity = damageSrc.getEntity();
            if (entity instanceof BaseServant) {
                BaseServant servant = (BaseServant)entity;
                if (damageSrc.getDirectEntity() != null && (damageSrc.getEntity() == damageSrc.getDirectEntity() || damageSrc.getDirectEntity().getType().is(FateTags.EntityTypes.MANA_LEECHING_PROJECTILE))) {
                    servant.regenMana(damageSrc.getDirectEntity());
                }
            }
            if (damageSrc.getEntity() != null && (entity = damageSrc.getEntity()) instanceof OwnableEntity) {
                LivingEntity livingEntity2;
                OwnableEntity ownable = (OwnableEntity)entity;
                if (damageSrc.getEntity().getType().is(FateTags.EntityTypes.MANA_LEECHING_SUMMONS) && (livingEntity2 = ownable.getOwner()) instanceof BaseServant) {
                    BaseServant servant = (BaseServant)livingEntity2;
                    servant.regenMana(damageSrc.getDirectEntity());
                }
            }
        }
    }

    public static boolean preventEffectApply(LivingEntity entity, MobEffectInstance instance) {
        return ((MobEffect)instance.getEffect().value()).getCategory() != MobEffectCategory.HARMFUL && entity.hasEffect(FateMobEffects.RULE_BREAKER.asHolder());
    }
}

