/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.items;

import io.github.flemmli97.fateubw.common.blocks.ChalkBlock;
import io.github.flemmli97.fateubw.common.registry.FateBlocks;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;

public class ChalkItem
extends Item {
    public ChalkItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState state;
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPlaceContext ctx = new BlockPlaceContext(context);
        ItemStack stack = ctx.getItemInHand();
        if (ctx.canPlace() && this.canPlace(ctx, state = ((ChalkBlock)((Object)FateBlocks.CHALK.get())).defaultBlockState()) && level.setBlockAndUpdate(ctx.getClickedPos(), state)) {
            level.playSound(null, ctx.getClickedPos(), SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 0.5f, 1.0f);
            if (ctx.getPlayer() != null && !ctx.getPlayer().isCreative()) {
                stack.hurtAndBreak(1, (LivingEntity)ctx.getPlayer(), LivingEntity.getSlotForHand((InteractionHand)ctx.getHand()));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean canPlace(BlockPlaceContext ctx, BlockState state) {
        Player playerentity = ctx.getPlayer();
        CollisionContext iselectioncontext = playerentity == null ? CollisionContext.empty() : CollisionContext.of((Entity)playerentity);
        return state.canSurvive((LevelReader)ctx.getLevel(), ctx.getClickedPos()) && ctx.getLevel().isUnobstructed(state, ctx.getClickedPos(), iselectioncontext);
    }
}

