/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.items;

import io.github.flemmli97.fateubw.common.components.ServantSpawneggData;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.network.S2CSpawnEggScreen;
import io.github.flemmli97.fateubw.common.registry.FateDataComponents;
import io.github.flemmli97.fateubw.common.world.GrailWarHandler;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class FateEgg
extends SpawnEgg {
    public FateEgg(Supplier<? extends EntityType<? extends BaseServant>> type, int primary, int secondary, Item.Properties props) {
        super(new SpawnEgg.EntityTypeHolder(BaseServant.class, type), primary, secondary, props);
    }

    public boolean addToDefaultSpawneggs() {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"fateubw.tooltip.item.spawn").withStyle(ChatFormatting.GOLD));
    }

    public boolean onEntitySpawned(Entity e, ItemStack stack, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (e instanceof BaseServant) {
                BaseServant servant = (BaseServant)e;
                ServantSpawneggData data = (ServantSpawneggData)stack.getOrDefault((DataComponentType)FateDataComponents.SERVANT_EGG_DATA.get(), (Object)ServantSpawneggData.DEFAULT);
                if (data.withMaster()) {
                    servant.setOwner(player);
                    if (data.joinGrailwar()) {
                        GrailWarHandler track = GrailWarHandler.get(serverPlayer.getServer());
                        GrailWarHandler.JoinResult res = track.checkJoining((Player)serverPlayer);
                        if (res != GrailWarHandler.JoinResult.SUCCESS) {
                            player.sendSystemMessage((Component)Component.translatable((String)res.translationKey).withStyle(ChatFormatting.RED));
                        } else {
                            track.join(servant);
                        }
                    }
                }
            }
        }
        return super.onEntitySpawned(e, stack, player);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        InteractionResultHolder res = super.use(level, player, hand);
        if (res.getResult() == InteractionResult.PASS) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CSpawnEggScreen(hand), serverPlayer);
            }
            return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
        }
        return res;
    }
}

