/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.items.weapons;

import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.misc.ArcherArrow;
import io.github.flemmli97.fateubw.common.entity.misc.CaladBolg;
import io.github.flemmli97.fateubw.common.items.SwingItem;
import io.github.flemmli97.fateubw.common.registry.FateDataComponents;
import io.github.flemmli97.fateubw.platform.Platform;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ArcherBowItem
extends BowItem
implements SwingItem {
    public ArcherBowItem(Item.Properties props) {
        super(props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        if (CommonConfig.archerBowMana > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"fateubw.tooltip.item.bow.arrow", (Object[])new Object[]{CommonConfig.archerBowMana}).withStyle(ChatFormatting.AQUA));
        }
        if (CommonConfig.caladbolgMana > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"fateubw.tooltip.item.caladbolg", (Object[])new Object[]{CommonConfig.caladbolgMana}).withStyle(ChatFormatting.AQUA));
        }
    }

    @Override
    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (!this.charged(stack) && !entity.level().isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            if (player.isCreative()) {
                this.setCharged(stack, true);
            } else if (player.isCreative() || Platform.INSTANCE.getPlayerData(player).useMana(CommonConfig.caladbolgMana)) {
                this.setCharged(stack, true);
            }
        }
        return false;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (this.charged(stack)) {
            this.spawnCaladBolg(level, entity, stack, timeLeft);
        } else {
            this.spawnNormalArrow(stack, level, entity, timeLeft);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.isCreative() || this.charged(player.getItemInHand(hand)) || Platform.INSTANCE.getPlayerData(player).getMana() >= CommonConfig.archerBowMana) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
    }

    public boolean isFoil(ItemStack stack) {
        return this.charged(stack) || super.isFoil(stack);
    }

    public void spawnCaladBolg(Level level, LivingEntity entity, ItemStack stack, int timeLeft) {
        int i;
        float f;
        CaladBolg bolg = new CaladBolg(level, entity);
        if (!level.isClientSide && (double)(f = ArcherBowItem.getPowerForTime((int)((i = this.getUseDuration(stack, entity) - timeLeft) * 2))) >= 0.1) {
            bolg.shoot((Entity)entity, entity.getXRot(), entity.getYRot(), 0.0f, f, 0.0f);
            level.addFreshEntity((Entity)bolg);
            this.setCharged(stack, false);
        }
    }

    public void spawnNormalArrow(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof ServerPlayer) {
            float f;
            ServerPlayer player = (ServerPlayer)entity;
            int ammoCount = player.hasInfiniteMaterials() ? 0 : EnchantmentHelper.processAmmoUse((ServerLevel)player.serverLevel(), (ItemStack)stack, (ItemStack)new ItemStack((ItemLike)Items.ARROW), (int)1);
            boolean flag = ammoCount <= 0 || Platform.INSTANCE.getPlayerData((Player)player).useMana(CommonConfig.archerBowMana * ammoCount);
            int i = this.getUseDuration(stack, entity) - timeLeft;
            if (flag && (double)(f = ArcherBowItem.getPowerForTime((int)(i * 2))) >= 0.1) {
                if (!level.isClientSide) {
                    AbstractArrow arrow = this.customArrow(new ArcherArrow(player.level(), (LivingEntity)player, stack), ItemStack.EMPTY, stack);
                    arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, f * 2.5f, 1.0f);
                    if (f == 1.0f) {
                        arrow.setCritArrow(true);
                    }
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
                    level.addFreshEntity((Entity)arrow);
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (player.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    public boolean charged(ItemStack stack) {
        return stack.has((DataComponentType)FateDataComponents.ARCHER_BOW_CHARGED.get());
    }

    private void setCharged(ItemStack stack, boolean flag) {
        if (flag) {
            stack.set((DataComponentType)FateDataComponents.ARCHER_BOW_CHARGED.get(), (Object)Unit.INSTANCE);
        } else {
            stack.remove((DataComponentType)FateDataComponents.ARCHER_BOW_CHARGED.get());
        }
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectile, ItemStack weaponStack) {
        LivingEntity owner;
        Entity entity;
        if (arrow instanceof ArcherArrow) {
            return arrow;
        }
        return new ArcherArrow(arrow.level(), (entity = arrow.getOwner()) instanceof LivingEntity ? (owner = (LivingEntity)entity) : null, weaponStack);
    }
}

