/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.items.weapons;

import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.misc.ThrownItemEntity;
import io.github.flemmli97.fateubw.platform.Platform;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class DaggerItem
extends SwordItem {
    public DaggerItem(Tier tier, Item.Properties props) {
        super(tier, props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        if (CommonConfig.daggerThrowMana > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"fateubw.tooltip.item.mana", (Object[])new Object[]{CommonConfig.daggerThrowMana}).withStyle(ChatFormatting.AQUA));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            ItemStack stack = player.getItemInHand(hand);
            if (player.isCreative() || Platform.INSTANCE.getPlayerData(player).useMana(CommonConfig.daggerThrowMana)) {
                ThrownItemEntity dagger = new ThrownItemEntity(level, (LivingEntity)player);
                dagger.setWeapon(stack.copy());
                dagger.shoot((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 0.0f);
                level.addFreshEntity((Entity)dagger);
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, player.getSoundSource(), 1.0f, 1.0f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
                return InteractionResultHolder.success((Object)stack);
            }
            player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.mana.missing").withStyle(ChatFormatting.AQUA));
            return InteractionResultHolder.fail((Object)stack);
        }
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }
}

