/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.items.weapons;

import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.misc.Excalibur;
import io.github.flemmli97.fateubw.common.lib.ItemTiers;
import io.github.flemmli97.fateubw.common.registry.FateDataComponents;
import io.github.flemmli97.fateubw.platform.Platform;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ExcaliburItem
extends SwordItem {
    public ExcaliburItem(Item.Properties props) {
        super((Tier)ItemTiers.EXCALIBUR, props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        if (CommonConfig.excaliburMana > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"fateubw.tooltip.item.mana", (Object[])new Object[]{CommonConfig.excaliburMana}).withStyle(ChatFormatting.AQUA));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            if (player.isCreative() || Platform.INSTANCE.getPlayerData(player).getMana() >= CommonConfig.excaliburMana) {
                player.startUsingItem(hand);
                stack.set((DataComponentType)FateDataComponents.GLOWING_ITEM.get(), (Object)Unit.INSTANCE);
                return InteractionResultHolder.consume((Object)stack);
            }
            player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.mana.missing").withStyle(ChatFormatting.AQUA));
            return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        stack.remove((DataComponentType)FateDataComponents.GLOWING_ITEM.get());
        int duration = this.getUseDuration(stack, entity) - timeLeft;
        if (duration < 40) {
            return;
        }
        if (!level.isClientSide) {
            Player player;
            if (!(entity instanceof Player) || (player = (Player)entity).isCreative() || Platform.INSTANCE.getPlayerData(player).useMana(CommonConfig.excaliburMana)) {
                Excalibur excalibur = new Excalibur(level, entity);
                level.addFreshEntity((Entity)excalibur);
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.mana.missing").withStyle(ChatFormatting.AQUA));
            }
        }
        super.releaseUsing(stack, level, entity, timeLeft);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        LivingEntity living;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getUseItem() != stack && stack.has((DataComponentType)FateDataComponents.GLOWING_ITEM.get())) {
            stack.remove((DataComponentType)FateDataComponents.GLOWING_ITEM.get());
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }
}

