/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.items.weapons;

import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.misc.GaeBolg;
import io.github.flemmli97.fateubw.common.lib.ItemTiers;
import io.github.flemmli97.fateubw.platform.Platform;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;

public class GaeBolgItem
extends TieredItem {
    public GaeBolgItem(Item.Properties props) {
        super((Tier)ItemTiers.GAE_BOLG, props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        if (CommonConfig.gaeBolgMana > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"fateubw.tooltip.item.mana", (Object[])new Object[]{CommonConfig.gaeBolgMana}).withStyle(ChatFormatting.AQUA));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            if (player.isCreative() || Platform.INSTANCE.getPlayerData(player).useMana(CommonConfig.gaeBolgMana)) {
                GaeBolg gaeBolg = new GaeBolg(level, (LivingEntity)player);
                gaeBolg.shoot((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.0f, 0.0f);
                EntityHitResult res = HitResultUtils.calculateEntityFromLook((LivingEntity)player, (double)32.0);
                if (res != null) {
                    gaeBolg.setTarget(res.getEntity());
                } else {
                    OrientedBoundingBox obb = new OrientedBoundingBox(new AABB(-8.0, -2.0, 0.0, 8.0, (double)(player.getBbHeight() + 4.0f), 32.0).move(0.0, (double)(-player.getBbHeight()) * 0.5, 0.0), player.getYRot(), -player.getXRot(), player.position().add(0.0, (double)player.getBbHeight() * 0.5, 0.0));
                    List entities = player.level().getEntitiesOfClass(LivingEntity.class, obb.getEncompassingBox());
                    double d0 = Double.MAX_VALUE;
                    LivingEntity target = null;
                    for (LivingEntity entity : entities) {
                        double dist;
                        if (entity == player) continue;
                        if (entities instanceof OwnableEntity) {
                            OwnableEntity ownable = (OwnableEntity)entities;
                            if (player.getUUID().equals(ownable.getOwnerUUID())) continue;
                        }
                        if (!obb.intersects(entity.getBoundingBox()) || !((dist = entity.distanceToSqr((Entity)player)) < d0)) continue;
                        target = entity;
                        d0 = dist;
                    }
                    if (target != null) {
                        gaeBolg.setTarget((Entity)target);
                    }
                }
                level.addFreshEntity((Entity)gaeBolg);
                if (!player.hasInfiniteMaterials()) {
                    stack.shrink(1);
                }
                return InteractionResultHolder.consume((Object)stack);
            }
            player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.mana.missing").withStyle(ChatFormatting.AQUA));
            return InteractionResultHolder.fail((Object)stack);
        }
        return InteractionResultHolder.success((Object)stack);
    }
}

