/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.items.weapons;

import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.summons.LesserMonster;
import io.github.flemmli97.fateubw.platform.Platform;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class GrimoireItem
extends Item {
    public GrimoireItem(Item.Properties props) {
        super(props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        if (CommonConfig.grimoireMana > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"fateubw.tooltip.item.mana", (Object[])new Object[]{CommonConfig.grimoireMana}).withStyle(ChatFormatting.AQUA));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            if (player.isCreative() || Platform.INSTANCE.getPlayerData(player).useMana(CommonConfig.grimoireMana)) {
                this.spawn(player, player.getItemInHand(hand));
                return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
            }
            player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.mana.missing").withStyle(ChatFormatting.AQUA));
            return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    private void spawn(Player player, ItemStack stack) {
        int tries;
        LesserMonster monster = new LesserMonster(player.level(), (LivingEntity)player);
        double x = player.getX() + (double)player.getRandom().nextInt(8) - 4.0;
        double y = player.getY() + (double)player.getRandom().nextInt(2) - 1.0;
        double z = player.getZ() + (double)player.getRandom().nextInt(8) - 4.0;
        monster.setPos(x, y, z);
        for (tries = 0; tries < 10 && !player.level().noCollision((Entity)monster); ++tries) {
            x = player.getX() + (double)player.getRandom().nextInt(8) - 4.0;
            y = player.getY() + (double)player.getRandom().nextInt(2) - 1.0;
            z = player.getZ() + (double)player.getRandom().nextInt(8) - 4.0;
            monster.setPos(x, y, z);
        }
        if (tries == 10 && !player.level().noCollision((Entity)monster)) {
            return;
        }
        player.level().addFreshEntity((Entity)monster);
        if (player.getLastHurtMob() != null) {
            monster.setTarget(player.getLastHurtMob());
        }
        player.getCooldowns().addCooldown(stack.getItem(), 50);
    }
}

