/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.items.weapons;

import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.misc.MagicBeam;
import io.github.flemmli97.fateubw.platform.Platform;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MedeasStaffItem
extends Item {
    public MedeasStaffItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        if (CommonConfig.daggerThrowMana > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"fateubw.tooltip.item.mana", (Object[])new Object[]{CommonConfig.staffMana}).withStyle(ChatFormatting.AQUA));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            if (player.isCreative() || Platform.INSTANCE.getPlayerData(player).getMana() >= CommonConfig.staffMana) {
                player.startUsingItem(hand);
                return InteractionResultHolder.consume((Object)stack);
            }
            player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.mana.missing").withStyle(ChatFormatting.AQUA));
            return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        int i = this.getUseDuration(stack, entity) - timeLeft;
        if (i < 15) {
            return;
        }
        if (!level.isClientSide) {
            Player player;
            if (!(entity instanceof Player) || (player = (Player)entity).isCreative() || Platform.INSTANCE.getPlayerData(player).useMana(CommonConfig.staffMana)) {
                MagicBeam beam = new MagicBeam(level, entity);
                beam.setPos(entity.getEyePosition().add(0.0, 2.0, 0.0));
                Vec3 target = entity.position().add(entity.getLookAngle().scale(16.0));
                beam.setRotationTo(target.x(), target.y(), target.z(), 0.0f);
                level.addFreshEntity((Entity)beam);
                level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, entity.getSoundSource(), 1.0f, 1.0f / (entity.getRandom().nextFloat() * 0.4f + 0.8f));
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.mana.missing").withStyle(ChatFormatting.AQUA));
            }
        }
        super.releaseUsing(stack, level, entity, timeLeft);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }
}

