/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.items.weapons;

import io.github.flemmli97.fateubw.common.attachment.PlayerData;
import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.misc.ChainDagger;
import io.github.flemmli97.fateubw.platform.Platform;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class MedusasDaggerItem
extends SwordItem {
    public MedusasDaggerItem(Tier tier, Item.Properties props) {
        super(tier, props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        if (CommonConfig.chainMana > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"fateubw.tooltip.item.mana", (Object[])new Object[]{CommonConfig.chainMana}).withStyle(ChatFormatting.AQUA));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            PlayerData data = Platform.INSTANCE.getPlayerData(player);
            ChainDagger thrownDagger = data.getThrownDagger();
            if (thrownDagger == null) {
                if (player.isCreative() || data.useMana(CommonConfig.chainMana)) {
                    ChainDagger dagger = new ChainDagger(level, (LivingEntity)player, hand == InteractionHand.MAIN_HAND);
                    dagger.shoot((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 0.0f);
                    level.addFreshEntity((Entity)dagger);
                    data.setThrownDagger(dagger);
                    return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
                }
                player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.mana.missing").withStyle(ChatFormatting.AQUA));
                return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
            }
            thrownDagger.retractHook();
            return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }
}

