/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.loot.entry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.fateubw.common.loot.GrailLootEntry;
import io.github.flemmli97.fateubw.common.loot.LootSerializerType;
import io.github.flemmli97.fateubw.common.registry.FateGrailLootSerializer;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootTableEntry
extends GrailLootEntry<LootTableEntry> {
    public static final MapCodec<LootTableEntry> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).listOf().fieldOf("loot_tables").forGetter(d -> d.lootTables), (App)LootItemCondition.DIRECT_CODEC.listOf().optionalFieldOf("conditions").forGetter(d -> d.conditions.isEmpty() ? Optional.empty() : Optional.of(d.conditions))).apply((Applicative)inst, (command, cond) -> new LootTableEntry((List<ResourceKey<LootTable>>)command, cond.orElse(List.of()))));
    private final List<ResourceKey<LootTable>> lootTables;

    public LootTableEntry(List<ResourceKey<LootTable>> lootTables, LootItemCondition ... conditions) {
        this(lootTables, List.of(conditions));
    }

    public LootTableEntry(List<ResourceKey<LootTable>> lootTables, List<LootItemCondition> conditions) {
        super(conditions);
        this.lootTables = lootTables;
    }

    @Override
    public Supplier<LootSerializerType<LootTableEntry>> getType() {
        return FateGrailLootSerializer.LOOT_TABLE;
    }

    @Override
    public void accept(ServerPlayer player, LootContext context) {
        ResourceKey<LootTable> lootTable = this.lootTables.get(context.getRandom().nextInt(this.lootTables.size()));
        LootTable table = player.getServer().reloadableRegistries().getLootTable(lootTable);
        table.getRandomItems(context, arg_0 -> ((ServerPlayer)player).addItem(arg_0));
    }
}

