/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.loot.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.fateubw.common.registry.FateGrailLootSerializer;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class EnchantMaxFunction
extends LootItemConditionalFunction {
    public static final MapCodec<EnchantMaxFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> EnchantMaxFunction.commonFields((RecordCodecBuilder.Instance)instance).and((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENCHANTMENT).fieldOf("enchantments").forGetter(d -> d.enchantments)).apply((Applicative)instance, EnchantMaxFunction::new));
    private final HolderSet<Enchantment> enchantments;

    private EnchantMaxFunction(List<LootItemCondition> conditions, HolderSet<Enchantment> possibleEnchantments) {
        super(conditions);
        this.enchantments = possibleEnchantments;
    }

    public LootItemFunctionType<EnchantMaxFunction> getType() {
        return (LootItemFunctionType)FateGrailLootSerializer.MAX_ENCHANT.get();
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        if (this.enchantments.size() == 0) {
            return stack;
        }
        return EnchantMaxFunction.enchantItem(stack, (Holder<Enchantment>)this.enchantments.get(context.getRandom().nextInt(this.enchantments.size())));
    }

    private static ItemStack enchantItem(ItemStack stack, Holder<Enchantment> enchantment) {
        if (stack.is(Items.BOOK)) {
            stack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantment, ((Enchantment)enchantment.value()).getMaxLevel()));
        } else {
            stack.enchant(enchantment, ((Enchantment)enchantment.value()).getMaxLevel());
        }
        return stack;
    }

    public static Builder builder(HolderLookup.Provider provider) {
        return new Builder(provider);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final HolderGetter<Enchantment> getter;
        private HolderSet<Enchantment> enchantments = HolderSet.empty();

        private Builder(HolderLookup.Provider provider) {
            this.getter = provider.lookupOrThrow(Registries.ENCHANTMENT);
        }

        @SafeVarargs
        public final Builder withEnchantment(ResourceKey<Enchantment> ... enchantment) {
            this.enchantments = HolderSet.direct(arg_0 -> this.getter.getOrThrow(arg_0), (Object[])enchantment);
            return this;
        }

        public Builder withEnchants(HolderSet<Enchantment> options) {
            this.enchantments = options;
            return this;
        }

        public LootItemFunction build() {
            return new EnchantMaxFunction(this.getConditions(), this.enchantments);
        }

        protected Builder getThis() {
            return this;
        }
    }
}

