/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.network;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.api.entity.CommandType;
import io.github.flemmli97.fateubw.api.entity.ServantLike;
import io.github.flemmli97.fateubw.common.attachment.PlayerData;
import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.fateubw.common.world.GrailWarHandler;
import io.github.flemmli97.fateubw.platform.Platform;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;

public record C2SServantCommand(ActionType command, int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<C2SServantCommand> TYPE = new CustomPacketPayload.Type(Fate.modRes("c2s_servant_command"));
    public static final StreamCodec<RegistryFriendlyByteBuf, C2SServantCommand> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, C2SServantCommand>(){

        public C2SServantCommand decode(RegistryFriendlyByteBuf buf) {
            return new C2SServantCommand((ActionType)buf.readEnum(ActionType.class), buf.readInt());
        }

        public void encode(RegistryFriendlyByteBuf buf, C2SServantCommand pkt) {
            buf.writeEnum((Enum)pkt.command);
            buf.writeInt(pkt.entityId);
        }
    };

    public static void handle(C2SServantCommand pkt, ServerPlayer sender) {
        if (sender == null) {
            return;
        }
        PlayerData data = Platform.INSTANCE.getPlayerData((Player)sender);
        ServantLike<?> servant = C2SServantCommand.getServant(sender, pkt.entityId);
        if (servant == null) {
            return;
        }
        switch (pkt.command.ordinal()) {
            case 0: {
                servant.onPlayerCommand(sender, pkt.command.as());
                sender.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.command.attackservant").withStyle(ChatFormatting.RED));
                break;
            }
            case 1: {
                servant.onPlayerCommand(sender, pkt.command.as());
                sender.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.command.attackall").withStyle(ChatFormatting.RED));
                break;
            }
            case 2: {
                servant.onPlayerCommand(sender, pkt.command.as());
                sender.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.command.defensive").withStyle(ChatFormatting.RED));
                break;
            }
            case 3: {
                servant.onPlayerCommand(sender, pkt.command.as());
                sender.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.command.follow").withStyle(ChatFormatting.RED));
                break;
            }
            case 4: {
                servant.onPlayerCommand(sender, pkt.command.as());
                sender.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.command.stay").withStyle(ChatFormatting.RED));
                break;
            }
            case 5: {
                servant.onPlayerCommand(sender, pkt.command.as());
                sender.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.command.patrol").withStyle(ChatFormatting.RED));
                break;
            }
            case 6: {
                servant.onPlayerCommand(sender, pkt.command.as());
                break;
            }
            case 7: {
                servant.onPlayerCommand(sender, pkt.command.as());
                sender.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.command.kill").withStyle(ChatFormatting.RED));
                break;
            }
            case 9: {
                servant.get().randomTeleport(sender.getX(), sender.getY(), sender.getZ(), false);
                servant.get().setTarget(null);
                if (!CommonConfig.punishTeleport) break;
                for (BaseServant others : sender.level().getEntitiesOfClass(BaseServant.class, sender.getBoundingBox().inflate(32.0))) {
                    if (others == servant || Utils.alliedTo((Entity)sender, (Entity)others)) continue;
                    others.setTarget((LivingEntity)sender);
                    others.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1200, 1));
                    others.addEffect(new MobEffectInstance(MobEffects.HEAL, 2, 3));
                }
                sender.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 1200, 1));
                sender.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 600, 1));
                break;
            }
            case 8: {
                if (data.useCommandSeal()) {
                    for (MobEffectInstance effect : CommonConfig.npBoostEffect.potions()) {
                        servant.get().addEffect(effect);
                    }
                    sender.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.command.spell.success").withStyle(ChatFormatting.RED));
                    break;
                }
                sender.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.command.spell.fail").withStyle(ChatFormatting.RED));
                break;
            }
            case 10: {
                LivingEntity target;
                Object object;
                EntityHitResult res = HitResultUtils.calculateEntityFromLook((LivingEntity)sender, (double)16.0);
                if (res == null || !((object = res.getEntity()) instanceof LivingEntity) || Utils.alliedTo((Entity)sender, (Entity)(target = (LivingEntity)object))) break;
                servant.get().setTarget(target);
                for (BaseServant others : sender.level().getEntitiesOfClass(BaseServant.class, sender.getBoundingBox().inflate(32.0), s -> sender.getUUID().equals(s.getOwnerUUID()))) {
                    others.setTarget(target);
                }
                break;
            }
            case 11: {
                servant.shouldScheduleEntityDataSync(false);
            }
        }
    }

    public static ServantLike<?> getServant(ServerPlayer sender, int entityId) {
        ServantLike servant;
        block6: {
            block5: {
                if (entityId == -1) {
                    ServantLike servantLike = GrailWarHandler.get(sender.getServer()).getServant(sender).orElse(null);
                    if (servantLike != null && sender.getUUID().equals(servantLike.getOwnerUUID())) {
                        return servantLike;
                    }
                    return null;
                }
                Entity entity = sender.level().getEntity(entityId);
                if (!(entity instanceof ServantLike)) break block5;
                servant = (ServantLike)entity;
                if (sender.getUUID().equals(servant.getOwnerUUID())) break block6;
            }
            return null;
        }
        return servant;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum ActionType {
        NORMAL,
        AGGRESSIVE,
        DEFENSIVE,
        FOLLOW,
        STAY,
        GUARD,
        NP,
        KILL,
        BOOST,
        TELEPORT,
        TARGET,
        CLOSE;


        public CommandType as() {
            return switch (this.ordinal()) {
                case 0 -> CommandType.NORMAL;
                case 1 -> CommandType.AGGRESSIVE;
                case 2 -> CommandType.DEFENSIVE;
                case 3 -> CommandType.FOLLOW;
                case 4 -> CommandType.STAY;
                case 5 -> CommandType.GUARD;
                case 6 -> CommandType.NP;
                case 7 -> CommandType.KILL;
                default -> null;
            };
        }
    }
}

