/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.network;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.world.TeamHandler;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class C2STeamMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<C2STeamMessage> TYPE = new CustomPacketPayload.Type(Fate.modRes("c2s_team_message"));
    public static final StreamCodec<RegistryFriendlyByteBuf, C2STeamMessage> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, C2STeamMessage>(){

        public C2STeamMessage decode(RegistryFriendlyByteBuf buf) {
            return new C2STeamMessage((Type)buf.readEnum(Type.class), buf.readUtf());
        }

        public void encode(RegistryFriendlyByteBuf buf, C2STeamMessage pkt) {
            buf.writeEnum((Enum)pkt.type);
            buf.writeUtf(pkt.name);
        }
    };
    private final Type type;
    private final String name;

    public C2STeamMessage(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public static void handle(C2STeamMessage pkt, ServerPlayer sender) {
        if (sender == null) {
            return;
        }
        TeamHandler handler = TeamHandler.get(sender.getServer());
        switch (pkt.type.ordinal()) {
            case 0: {
                handler.createTeam((Player)sender, pkt.name);
                break;
            }
            case 1: {
                handler.removeFromTeam((Player)sender, sender.getUUID());
                break;
            }
            case 2: {
                handler.rename((Player)sender, pkt.name);
                break;
            }
            case 3: {
                handler.removeListener((Player)sender);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum Type {
        CREATE,
        LEAVE,
        RENAME,
        CLOSE;

    }
}

