/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.network;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.world.TeamHandler;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class C2STeamUuidMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<C2STeamUuidMessage> TYPE = new CustomPacketPayload.Type(Fate.modRes("c2s_team_message_uuid"));
    public static final StreamCodec<RegistryFriendlyByteBuf, C2STeamUuidMessage> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, C2STeamUuidMessage>(){

        public C2STeamUuidMessage decode(RegistryFriendlyByteBuf buf) {
            return new C2STeamUuidMessage((Type)buf.readEnum(Type.class), buf.readUUID());
        }

        public void encode(RegistryFriendlyByteBuf buf, C2STeamUuidMessage pkt) {
            buf.writeEnum((Enum)pkt.type);
            buf.writeUUID(pkt.value);
        }
    };
    private final Type type;
    private final UUID value;

    public C2STeamUuidMessage(Type type, UUID value) {
        this.type = type;
        this.value = value;
    }

    public static void handle(C2STeamUuidMessage pkt, ServerPlayer sender) {
        if (sender == null) {
            return;
        }
        TeamHandler handler = TeamHandler.get(sender.getServer());
        switch (pkt.type.ordinal()) {
            case 0: {
                handler.invite((Player)sender, pkt.value);
                break;
            }
            case 1: {
                handler.retractInvite((Player)sender, pkt.value);
                break;
            }
            case 2: {
                handler.requestAlliance((Player)sender, pkt.value);
                break;
            }
            case 3: {
                handler.retractRequest((Player)sender, pkt.value);
                break;
            }
            case 4: {
                handler.acceptAlliance((Player)sender, pkt.value);
                break;
            }
            case 5: {
                handler.denyAlliance((Player)sender, pkt.value);
                break;
            }
            case 6: {
                handler.dissolveAlliance((Player)sender, pkt.value);
                break;
            }
            case 7: {
                handler.givePerms((Player)sender, pkt.value);
                break;
            }
            case 8: {
                handler.revokePerms((Player)sender, pkt.value);
                break;
            }
            case 9: {
                handler.removeFromTeam((Player)sender, pkt.value);
                break;
            }
            case 10: {
                handler.joinTeam((Player)sender, pkt.value);
                break;
            }
            case 11: {
                handler.denyInvite((Player)sender, pkt.value);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum Type {
        INVITE,
        RETRACT_INVITE,
        REQUEST_ALLY,
        RETRACT_REQUEST,
        ACCEPT_ALLY,
        DENY_ALLY,
        DISSOLVE_ALLY,
        PROMOTE,
        DEMOTE,
        KICK,
        ACCEPT_INVITE,
        DENY_INVITE;

    }
}

