/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.particles;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record RingParticleData(float rotY, float rotX) implements ParticleOptions
{
    public static final MapCodec<RingParticleData> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.FLOAT.fieldOf("y_rot").forGetter(RingParticleData::rotY), (App)Codec.FLOAT.fieldOf("x_rot").forGetter(RingParticleData::rotX)).apply((Applicative)builder, RingParticleData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RingParticleData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, RingParticleData>(){

        public RingParticleData decode(RegistryFriendlyByteBuf buf) {
            return new RingParticleData(buf.readFloat(), buf.readFloat());
        }

        public void encode(RegistryFriendlyByteBuf buffer, RingParticleData data) {
            buffer.writeFloat(data.rotY());
            buffer.writeFloat(data.rotX());
        }
    };

    public ParticleType<?> getType() {
        return (ParticleType)FateParticles.RING.get();
    }
}

