/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.registry;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.lib.FateTags;
import io.github.flemmli97.fateubw.common.registry.FateBlocks;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.OreFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import org.jetbrains.annotations.Nullable;

public class FateFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_CLASS_ARTIFACT_ORE = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Fate.modRes("class_artifact_ore"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_GEM_ORES = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Fate.modRes("gem_ores"));
    public static final ResourceKey<PlacedFeature> CLASS_ARTIFACT_ORE = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Fate.modRes("class_artifact_ore"));
    public static final ResourceKey<PlacedFeature> GEM_ORES = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Fate.modRes("gem_ores"));

    public static void createFeatures(@Nullable FeatureRegister register, Consumer<FeatureBiomeModifier> placedFeatureHandler) {
        if (register != null) {
            register.registerConfigured(CONFIGURED_CLASS_ARTIFACT_ORE, provider -> new ConfiguredFeature(OreFeature.ORE, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES), (BlockState)((DropExperienceBlock)FateBlocks.ARTIFACT_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES), (BlockState)((DropExperienceBlock)FateBlocks.DEEP_SLATE_ARTIFACT_ORE.get()).defaultBlockState())), 2)));
            register.registerConfigured(CONFIGURED_GEM_ORES, provider -> new ConfiguredFeature(OreFeature.ORE, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES), (BlockState)((DropExperienceBlock)FateBlocks.GEM_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES), (BlockState)((DropExperienceBlock)FateBlocks.DEEP_SLATE_GEM_ORE.get()).defaultBlockState())), 9)));
            register.registerPlaced(CLASS_ARTIFACT_ORE, provider -> new PlacedFeature(provider.get(CONFIGURED_CLASS_ARTIFACT_ORE), List.of(CountPlacement.of((int)4), InSquarePlacement.spread(), BiomeFilter.biome(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-80), (VerticalAnchor)VerticalAnchor.absolute((int)32)))));
            register.registerPlaced(GEM_ORES, provider -> new PlacedFeature(provider.get(CONFIGURED_GEM_ORES), List.of(CountPlacement.of((int)9), InSquarePlacement.spread(), BiomeFilter.biome(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-33), (VerticalAnchor)VerticalAnchor.absolute((int)50)))));
        }
        placedFeatureHandler.accept(new FeatureBiomeModifier(FateTags.Biomes.FATE_ORE_GEN, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)CLASS_ARTIFACT_ORE.location())));
        placedFeatureHandler.accept(new FeatureBiomeModifier(FateTags.Biomes.FATE_ORE_GEN, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)GEM_ORES.location())));
    }

    public static interface FeatureRegister {
        public void registerConfigured(ResourceKey<ConfiguredFeature<?, ?>> var1, Function<HolderGetterLookup, ConfiguredFeature<?, ?>> var2);

        public void registerPlaced(ResourceKey<PlacedFeature> var1, Function<HolderGetterLookup, PlacedFeature> var2);
    }

    public record FeatureBiomeModifier(TagKey<Biome> tag, GenerationStep.Decoration decoration, ResourceKey<PlacedFeature> placedFeature) {
    }

    public static interface HolderGetterLookup {
        default public <S> Holder<S> get(ResourceKey<S> key) {
            return this.lookup(key.registryKey()).getOrThrow(key);
        }

        public <S> HolderGetter<S> lookup(ResourceKey<? extends Registry<? extends S>> var1);
    }
}

