/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.registry;

import io.github.flemmli97.fateubw.common.items.ChalkItem;
import io.github.flemmli97.fateubw.common.items.CrystalItem;
import io.github.flemmli97.fateubw.common.items.HolyGrailItem;
import io.github.flemmli97.fateubw.common.items.ManaBottleItem;
import io.github.flemmli97.fateubw.common.items.weapons.ArcherBowItem;
import io.github.flemmli97.fateubw.common.items.weapons.DaggerItem;
import io.github.flemmli97.fateubw.common.items.weapons.EnumaElishItem;
import io.github.flemmli97.fateubw.common.items.weapons.ExcaliburItem;
import io.github.flemmli97.fateubw.common.items.weapons.GaeBolgItem;
import io.github.flemmli97.fateubw.common.items.weapons.GrimoireItem;
import io.github.flemmli97.fateubw.common.items.weapons.KanshouBakuyaItem;
import io.github.flemmli97.fateubw.common.items.weapons.MedeasStaffItem;
import io.github.flemmli97.fateubw.common.items.weapons.MedusasDaggerItem;
import io.github.flemmli97.fateubw.common.lib.BuiltinServantClasses;
import io.github.flemmli97.fateubw.common.lib.ItemTiers;
import io.github.flemmli97.fateubw.common.lib.LibAttributeModifiers;
import io.github.flemmli97.fateubw.common.registry.FateBlocks;
import io.github.flemmli97.fateubw.common.registry.FateCreativeTab;
import io.github.flemmli97.fateubw.common.registry.FateDataComponents;
import io.github.flemmli97.tenshilib.common.item.AnimationDebugger;
import io.github.flemmli97.tenshilib.loader.LoaderRegistryAccess;
import io.github.flemmli97.tenshilib.loader.registry.LoaderRegister;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.block.Block;

public class FateItems {
    public static final LoaderRegister<Item> ITEMS = LoaderRegistryAccess.INSTANCE.of(Registries.ITEM, "fateubw");
    public static final RegistryEntrySupplier<Item, SwordItem> INVISEXCALIBUR = FateItems.register("invis_excalibur", () -> new SwordItem((Tier)ItemTiers.INVIS_EXCALIBUR, new Item.Properties().attributes(FateItems.createAttributes(ItemTiers.INVIS_EXCALIBUR, -2.4f)).component(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true)), false);
    public static final RegistryEntrySupplier<Item, ExcaliburItem> EXCALIBUR = FateItems.register("excalibur", () -> new ExcaliburItem(new Item.Properties().attributes(FateItems.createAttributes(ItemTiers.EXCALIBUR, -2.4f))));
    public static final RegistryEntrySupplier<Item, GaeBolgItem> GAEBOLG = FateItems.register("gae_bolg", () -> new GaeBolgItem(new Item.Properties().attributes(FateItems.createAttributes(ItemTiers.GAE_BOLG, -2.0, 5.0))));
    public static final RegistryEntrySupplier<Item, TieredItem> GAEDEARG = FateItems.register("gae_dearg", () -> new TieredItem((Tier)ItemTiers.GAE_DEARG, new Item.Properties().attributes(FateItems.createAttributes(ItemTiers.GAE_DEARG, -1.5, 5.0))));
    public static final RegistryEntrySupplier<Item, TieredItem> GAEBUIDHE = FateItems.register("gae_buidhe", () -> new TieredItem((Tier)ItemTiers.GAE_BUIDHE, new Item.Properties().attributes(FateItems.createAttributes(ItemTiers.GAE_BUIDHE, -1.5, 4.0))));
    public static final RegistryEntrySupplier<Item, KanshouBakuyaItem> KANSHOU = FateItems.register("kanshou", FateItems::kanshou);
    public static final RegistryEntrySupplier<Item, KanshouBakuyaItem> BAKUYA = FateItems.register("bakuya", () -> new KanshouBakuyaItem(ItemTiers.KANSHOU_BAKUYA, new Item.Properties().attributes(FateItems.createAttributes(ItemTiers.KANSHOU_BAKUYA, -2.0)), () -> KANSHOU));
    public static final RegistryEntrySupplier<Item, ArcherBowItem> EMIYAS_BOW = FateItems.register("emiyas_bow", () -> new ArcherBowItem(new Item.Properties().stacksTo(1)));
    public static final RegistryEntrySupplier<Item, EnumaElishItem> ENUMAELISH = FateItems.register("enuma_elish", () -> new EnumaElishItem(new Item.Properties().attributes(FateItems.createAttributes(ItemTiers.ENUMA_ELISH, -2.4f))));
    public static final RegistryEntrySupplier<Item, MedeasStaffItem> STAFF = FateItems.register("medeas_staff", () -> new MedeasStaffItem(new Item.Properties().stacksTo(1)));
    public static final RegistryEntrySupplier<Item, SwordItem> RULE_BREAKER = FateItems.register("rule_breaker", () -> new SwordItem((Tier)ItemTiers.RULE_BREAKER, new Item.Properties().attributes(FateItems.createAttributes(ItemTiers.RULE_BREAKER, -2.4f))));
    public static final RegistryEntrySupplier<Item, GrimoireItem> GRIMOIRE = FateItems.register("prelatis_spellbook", () -> new GrimoireItem(new Item.Properties().stacksTo(1)));
    public static final RegistryEntrySupplier<Item, AxeItem> HERACLES_AXE = FateItems.register("heracles_axe", () -> new AxeItem((Tier)ItemTiers.HERACLES_AXE, new Item.Properties().attributes(FateItems.createAttributes(ItemTiers.HERACLES_AXE, -3.2f))));
    public static final RegistryEntrySupplier<Item, SwordItem> ARONDIGHT = FateItems.register("arondight", () -> new SwordItem((Tier)ItemTiers.ARONDIGHT, new Item.Properties().attributes(FateItems.createAttributes(ItemTiers.ARONDIGHT, -2.4f))));
    public static final RegistryEntrySupplier<Item, SwordItem> KUPRIOTS = FateItems.register("kupriots", () -> new SwordItem((Tier)ItemTiers.KUPRIOTS, new Item.Properties().attributes(FateItems.createAttributes(ItemTiers.KUPRIOTS, -2.4f))));
    public static final RegistryEntrySupplier<Item, MedusasDaggerItem> MEDUSA_DAGGER = FateItems.register("medusas_dagger", () -> new MedusasDaggerItem(ItemTiers.DAGGER, new Item.Properties().attributes(FateItems.createAttributes(ItemTiers.DAGGER, -2.0))));
    public static final RegistryEntrySupplier<Item, DaggerItem> ASSASSIN_DAGGER = FateItems.register("assassin_dagger", () -> new DaggerItem(ItemTiers.ASSASSIN_DAGGER, new Item.Properties().attributes(FateItems.createAttributes(ItemTiers.ASSASSIN_DAGGER, -1.5))));
    public static final RegistryEntrySupplier<Item, SwordItem> MONOHOSHI_ZAO = FateItems.register("monohoshi_zao", () -> new SwordItem((Tier)ItemTiers.KATANA, new Item.Properties().attributes(FateItems.createAttributes(ItemTiers.KATANA, -2.6f, 4.5))));
    public static final RegistryEntrySupplier<Item, BlockItem> ALTAR = FateItems.register("summoning_altar", () -> new BlockItem((Block)FateBlocks.ALTAR.get(), new Item.Properties()));
    public static final RegistryEntrySupplier<Item, BlockItem> GEM_ORE = FateItems.register("gem_ore", () -> new BlockItem((Block)FateBlocks.GEM_ORE.get(), new Item.Properties()));
    public static final RegistryEntrySupplier<Item, BlockItem> ARTIFACT_ORE = FateItems.register("artifact_ore", () -> new BlockItem((Block)FateBlocks.ARTIFACT_ORE.get(), new Item.Properties()));
    public static final RegistryEntrySupplier<Item, BlockItem> DEEP_SLATE_GEM_ORE = FateItems.register("deepslate_gem_ore", () -> new BlockItem((Block)FateBlocks.DEEP_SLATE_GEM_ORE.get(), new Item.Properties()));
    public static final RegistryEntrySupplier<Item, BlockItem> DEEP_SLATE_ARTIFACT_ORE = FateItems.register("deepslate_artifact_ore", () -> new BlockItem((Block)FateBlocks.DEEP_SLATE_ARTIFACT_ORE.get(), new Item.Properties()));
    public static final RegistryEntrySupplier<Item, Item> ARTIFACT_SABER = FateItems.registerArtifact(BuiltinServantClasses.SABER);
    public static final RegistryEntrySupplier<Item, Item> ARTIFACT_ARCHER = FateItems.registerArtifact(BuiltinServantClasses.ARCHER);
    public static final RegistryEntrySupplier<Item, Item> ARTIFACT_LANCER = FateItems.registerArtifact(BuiltinServantClasses.LANCER);
    public static final RegistryEntrySupplier<Item, Item> ARTIFACT_CASTER = FateItems.registerArtifact(BuiltinServantClasses.CASTER);
    public static final RegistryEntrySupplier<Item, Item> ARTIFACT_BERSERKER = FateItems.registerArtifact(BuiltinServantClasses.BERSERKER);
    public static final RegistryEntrySupplier<Item, Item> ARTIFACT_RIDER = FateItems.registerArtifact(BuiltinServantClasses.RIDER);
    public static final RegistryEntrySupplier<Item, Item> ARTIFACT_ASSASSIN = FateItems.registerArtifact(BuiltinServantClasses.ASSASSIN);
    public static final RegistryEntrySupplier<Item, Item> CRYSTAL_RED = FateItems.register("gem_shard_red", () -> new Item(new Item.Properties()));
    public static final RegistryEntrySupplier<Item, Item> CRYSTAL_GREEN = FateItems.register("gem_shard_green", () -> new Item(new Item.Properties()));
    public static final RegistryEntrySupplier<Item, Item> CRYSTAL_YELLOW = FateItems.register("gem_shard_yellow", () -> new Item(new Item.Properties()));
    public static final RegistryEntrySupplier<Item, Item> CRYSTAL_BLUE = FateItems.register("gem_shard_blue", () -> new Item(new Item.Properties()));
    public static final RegistryEntrySupplier<Item, Item> CRYSTAL_BLACK = FateItems.register("gem_shard_black", () -> new Item(new Item.Properties()));
    public static final RegistryEntrySupplier<Item, CrystalItem> MANA_GEM = FateItems.register("mana_gem", () -> new CrystalItem(new Item.Properties()));
    public static final RegistryEntrySupplier<Item, ChalkItem> CHALK = FateItems.register("chalk", () -> new ChalkItem(new Item.Properties().durability(32)));
    public static final RegistryEntrySupplier<Item, ManaBottleItem> MANA_BOTTLE = FateItems.register("mana_bottle", () -> new ManaBottleItem(new Item.Properties()));
    public static final RegistryEntrySupplier<Item, HolyGrailItem> GRAIL = FateItems.register("holy_grail", () -> new HolyGrailItem(new Item.Properties()));
    public static final RegistryEntrySupplier<Item, Item> ICON_0 = FateItems.register("icon_0", () -> new Item(new Item.Properties()), false);
    public static final RegistryEntrySupplier<Item, Item> ICON_1 = FateItems.register("icon_1", () -> new Item(new Item.Properties()), false);
    public static final RegistryEntrySupplier<Item, Item> ICON_2 = FateItems.register("icon_2", () -> new Item(new Item.Properties()), false);
    public static final RegistryEntrySupplier<Item, Item> ICON_3 = FateItems.register("icon_3", () -> new Item(new Item.Properties()), false);
    public static final RegistryEntrySupplier<Item, AnimationDebugger> ANIMATION_DEBUG = FateItems.register("animation_debugger", () -> new AnimationDebugger(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC), FateDataComponents.SELECTED_UUID, FateDataComponents.SELECTED_ANIMATION), false);
    public static final Supplier<Item> RANDOM_ICON = () -> {
        int i = new Random().nextInt(4);
        return switch (i) {
            case 0 -> (Item)ICON_0.get();
            case 1 -> (Item)ICON_1.get();
            case 2 -> (Item)ICON_2.get();
            default -> (Item)ICON_3.get();
        };
    };

    private static RegistryEntrySupplier<Item, Item> registerArtifact(ResourceLocation type) {
        return FateItems.register("artifact_" + type.getPath(), () -> new Item(new Item.Properties().stacksTo(8).rarity(Rarity.RARE).component((DataComponentType)FateDataComponents.CLASS_RELIC.get(), (Object)type)));
    }

    private static <T extends Item> RegistryEntrySupplier<Item, T> register(String name, Supplier<T> sup) {
        return FateItems.register(name, sup, true);
    }

    private static <T extends Item> RegistryEntrySupplier<Item, T> register(String name, Supplier<T> sup, boolean withTab) {
        RegistryEntrySupplier item = ITEMS.register(name, sup);
        if (withTab) {
            FateCreativeTab.addToTab(item);
        }
        return item;
    }

    private static KanshouBakuyaItem kanshou() {
        return new KanshouBakuyaItem(ItemTiers.KANSHOU_BAKUYA, new Item.Properties().attributes(FateItems.createAttributes(ItemTiers.KANSHOU_BAKUYA, -2.0)), () -> BAKUYA);
    }

    public static ItemAttributeModifiers createAttributes(Tier tier, double attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)tier.getAttackDamageBonus(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static ItemAttributeModifiers createAttributes(Tier tier, double attackSpeed, double range) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)tier.getAttackDamageBonus(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(LibAttributeModifiers.BASE_ATTACK_RANGE_ID, range - 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }
}

