/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.utils;

import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.registry.FateAttributes;
import io.github.flemmli97.tenshilib.common.utils.math.parser.VariableMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class ExtendedCombatRules {
    public static float getDamageAfterArmor(LivingEntity entity, float damage, DamageSource damageSource, double armorValue, double armorToughness) {
        Level level;
        VariableMap map = new VariableMap();
        map.setVariable("damage", (double)damage);
        map.setVariable("armor", armorValue);
        map.setVariable("armor_toughness", armorToughness);
        map.setVariable("effective_armor", CommonConfig.effectiveArmor.get(map));
        float reduction = (float)Mth.clamp((double)CommonConfig.armorReduction.get(map), (double)0.0, (double)1.0);
        ItemStack itemStack = damageSource.getWeaponItem();
        if (itemStack != null && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            reduction = Mth.clamp((float)EnchantmentHelper.modifyArmorEffectiveness((ServerLevel)serverLevel, (ItemStack)itemStack, (Entity)entity, (DamageSource)damageSource, (float)reduction), (float)0.0f, (float)1.0f);
        }
        return damage * (1.0f - reduction);
    }

    public static float projectileReduce(LivingEntity entity, float damage) {
        AttributeInstance inst = entity.getAttribute(FateAttributes.PROJECTILE_RESISTANCE.asHolder());
        if (inst == null) {
            return damage;
        }
        VariableMap map = new VariableMap();
        map.setVariable("damage", (double)damage);
        map.setVariable("projectile_protection", inst.getValue());
        float reduction = (float)Mth.clamp((double)CommonConfig.projectileReduction.get(map), (double)0.0, (double)1.0);
        return damage * (1.0f - reduction);
    }

    public static float getDamageAfterMagicProtection(LivingEntity entity, float damage) {
        AttributeInstance inst = entity.getAttribute(FateAttributes.MAGIC_RESISTANCE.asHolder());
        if (inst == null) {
            return damage;
        }
        VariableMap map = new VariableMap();
        map.setVariable("damage", (double)damage);
        map.setVariable("magic_protection", inst.getValue());
        float reduction = (float)Mth.clamp((double)CommonConfig.magicReduction.get(map), (double)0.0, (double)1.0);
        return damage * (1.0f - reduction);
    }
}

