/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.utils;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class MathsHelper {
    public static float[] YXRotFrom(Vec3 direction) {
        return new float[]{MathsHelper.YRotFrom(direction.x(), direction.z()), MathsHelper.XRotFrom(direction.x(), direction.y(), direction.z())};
    }

    public static float[] YXRotFrom(double x, double y, double z) {
        return new float[]{MathsHelper.YRotFrom(x, z), MathsHelper.XRotFrom(x, y, z)};
    }

    public static float XRotFrom(Vec3 direction) {
        return MathsHelper.XRotFrom(direction.x(), direction.y(), direction.z());
    }

    public static float XRotFrom(double x, double y, double z) {
        double horDist = Math.sqrt(x * x + z * z);
        return (float)(-(Mth.atan2((double)y, (double)horDist) * 57.2957763671875));
    }

    public static float YRotFrom(Vec3 direction) {
        return MathsHelper.YRotFrom(direction.x(), direction.z());
    }

    public static float YRotFrom(double x, double z) {
        return (float)(Mth.atan2((double)z, (double)x) * 57.2957763671875) - 90.0f;
    }

    public static float rotlerp(float angle, float targetAngle, float maxIncrease) {
        float f = Mth.wrapDegrees((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }
}

