/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.utils;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TeleportUtils {
    public static boolean safeDimensionTeleport(Mob entity, ServerLevel newLevel, BlockPos target) {
        BlockPos safe = null;
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = entity.getRandom().nextInt(-3, 3);
            BlockPos pos = TeleportUtils.isSafePos(entity, (Level)newLevel, target.offset(x, y = entity.getRandom().nextInt(-2, 3), z = entity.getRandom().nextInt(-3, 3)), s -> true);
            if (pos == null) continue;
            safe = pos;
            break;
        }
        if (safe == null) {
            return false;
        }
        float yaw = entity.getYRot();
        float pitch = entity.getXRot();
        entity.unRide();
        Mob old = entity;
        entity = (Mob)old.getType().create((Level)newLevel);
        if (entity == null) {
            return false;
        }
        entity.restoreFrom((Entity)old);
        entity.moveTo((double)safe.getX(), (double)safe.getY(), (double)safe.getZ(), yaw, pitch);
        old.setRemoved(Entity.RemovalReason.CHANGED_DIMENSION);
        newLevel.addDuringTeleport((Entity)entity);
        newLevel.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.MASTER, 1.0f, 1.0f);
        for (int i = 0; i < 32; ++i) {
            newLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, entity.getX(), entity.getY() + newLevel.random.nextDouble() * 2.0, entity.getZ(), 0, newLevel.random.nextGaussian(), 0.0, newLevel.random.nextGaussian(), 1.0);
        }
        return true;
    }

    public static BlockPos isSafePos(Mob entity, Level level, BlockPos pos, Predicate<BlockState> validPos) {
        PathType blockPathTypes = entity.getNavigation().getNodeEvaluator().getPathType(new PathfindingContext((CollisionGetter)entity.level(), entity), pos.getX(), pos.getY(), pos.getZ());
        if (blockPathTypes == PathType.OPEN ? !entity.isNoGravity() : blockPathTypes != PathType.WALKABLE) {
            return null;
        }
        BlockState blockState = level.getBlockState(pos.below());
        if (!validPos.test(blockState)) {
            return null;
        }
        for (VoxelShape voxelShape : level.getBlockCollisions((Entity)entity, entity.getBoundingBox().move((double)pos.getX() + 0.5 - entity.getX(), (double)pos.getY() - entity.getY(), (double)pos.getZ() + 0.5 - entity.getZ()))) {
            if (voxelShape.isEmpty()) continue;
            return null;
        }
        return pos;
    }

    public static void teleportTo(LivingEntity entity, double x, double y, double z, @Nullable SoundEvent soundEvent, @Nullable ParticleOptions particle) {
        Vec3 prev = entity.position();
        entity.teleportTo(x, y, z);
        if (soundEvent != null) {
            entity.level().playSound(null, entity.xo, entity.yo, entity.zo, soundEvent, entity.getSoundSource(), 1.0f, 1.0f);
            entity.playSound(soundEvent, 1.0f, 1.0f);
        }
        if (particle != null) {
            ServerLevel serverLevel;
            Level level;
            int i;
            for (i = 0; i < 10; ++i) {
                level = entity.level();
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles(particle, prev.x() + (double)entity.getBbWidth() * TeleportUtils.randomUniform(entity.getRandom()), prev.y() + (double)entity.getBbHeight() * TeleportUtils.randomUniform(entity.getRandom()), prev.z() + (double)entity.getBbWidth() * TeleportUtils.randomUniform(entity.getRandom()), 0, TeleportUtils.randomUniform(entity.getRandom()) * 0.1, TeleportUtils.randomUniform(entity.getRandom()) * 0.1, TeleportUtils.randomUniform(entity.getRandom()) * 0.1, 1.0);
                    continue;
                }
                entity.level().addParticle(particle, prev.x() + (double)entity.getBbWidth() * TeleportUtils.randomUniform(entity.getRandom()), prev.y() + (double)entity.getBbHeight() * TeleportUtils.randomUniform(entity.getRandom()), prev.z() + (double)entity.getBbWidth() * TeleportUtils.randomUniform(entity.getRandom()), TeleportUtils.randomUniform(entity.getRandom()) * 0.1, TeleportUtils.randomUniform(entity.getRandom()) * 0.1, TeleportUtils.randomUniform(entity.getRandom()) * 0.1);
            }
            for (i = 0; i < 10; ++i) {
                level = entity.level();
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles(particle, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 0, TeleportUtils.randomUniform(entity.getRandom()) * 0.1, TeleportUtils.randomUniform(entity.getRandom()) * 0.1, TeleportUtils.randomUniform(entity.getRandom()) * 0.1, 1.0);
                    continue;
                }
                entity.level().addParticle(particle, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), TeleportUtils.randomUniform(entity.getRandom()) * 0.1, TeleportUtils.randomUniform(entity.getRandom()) * 0.1, TeleportUtils.randomUniform(entity.getRandom()) * 0.1);
            }
        }
    }

    private static double randomUniform(RandomSource random) {
        return random.nextDouble() - 0.5;
    }
}

