/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.utils;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.fateubw.api.entity.ServantLike;
import io.github.flemmli97.fateubw.common.registry.FateAttributes;
import io.github.flemmli97.fateubw.common.world.GrailWarHandler;
import io.github.flemmli97.fateubw.common.world.TeamHandler;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static Vec3 fromRelativeVector(Entity entity, Vec3 relative) {
        return Utils.fromRelativeVector(entity.getYRot(), relative);
    }

    public static Vec3 fromRelativeVector(float yRot, Vec3 relative) {
        Vec3 vec3 = relative.normalize();
        float f = Mth.sin((float)(yRot * ((float)Math.PI / 180)));
        float g = Mth.cos((float)(yRot * ((float)Math.PI / 180)));
        return new Vec3(vec3.x * (double)g - vec3.z * (double)f, vec3.y, vec3.z * (double)g + vec3.x * (double)f);
    }

    public static float magicDamage(@Nullable Entity entity) {
        LivingEntity living;
        if (!(entity instanceof LivingEntity) || (living = (LivingEntity)entity).getAttribute(FateAttributes.MAGIC_ATTACK.asHolder()) == null) {
            return 0.0f;
        }
        return (float)living.getAttributeValue(FateAttributes.MAGIC_ATTACK.asHolder());
    }

    public static boolean runWithInvulTimer(@Nullable Entity source, Entity target, Predicate<Entity> attack, int invulnerability) {
        boolean success;
        int invul = target.invulnerableTime;
        boolean modified = false;
        boolean sourceCheck = true;
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            if (source != null && living.getLastHurtByMob() != source) {
                sourceCheck = false;
            }
        }
        if (target.invulnerableTime + invulnerability <= 20 && sourceCheck) {
            target.invulnerableTime = Math.min(target.invulnerableTime, 10);
            modified = true;
        }
        if (!(success = attack.test(target)) && modified) {
            target.invulnerableTime = invul;
        }
        return success;
    }

    public static boolean alliedTo(@Nullable Entity entity, @Nullable Entity other) {
        OwnableEntity ownable;
        if (entity == null || other == null) {
            return false;
        }
        if (entity == other) {
            return false;
        }
        if (entity.getServer() == null) {
            return false;
        }
        if (entity instanceof OwnableEntity) {
            ownable = (OwnableEntity)entity;
            if (other.getUUID().equals(ownable.getOwnerUUID())) {
                return true;
            }
            if (Utils.alliedTo((Entity)ownable.getOwner(), other)) {
                return true;
            }
        }
        if (other instanceof OwnableEntity) {
            ownable = (OwnableEntity)other;
            if (entity.getUUID().equals(ownable.getOwnerUUID())) {
                if (entity.getUUID().equals(ownable.getOwnerUUID())) {
                    return true;
                }
                if (Utils.alliedTo(entity, (Entity)ownable.getOwner())) {
                    return true;
                }
            }
        }
        return TeamHandler.get(entity.getServer()).areAllies(entity, other);
    }

    public static Predicate<LivingEntity> servantTargetPredicate(Mob entity) {
        return target -> {
            Mob mob;
            if (target == entity || !entity.canAttack(target) || !target.canBeSeenAsEnemy() || Utils.alliedTo((Entity)entity, (Entity)target)) {
                return false;
            }
            if (target == entity.getTarget() || target instanceof Mob && (mob = (Mob)target).getTarget() == entity) {
                return true;
            }
            if (entity.hasPassenger((Entity)target) || entity.getVehicle() == target) {
                return false;
            }
            if (entity instanceof ServantLike) {
                if (target instanceof ServerPlayer) {
                    return GrailWarHandler.get(target.getServer()).isParticipant((Entity)entity);
                }
                if (target instanceof ServantLike) {
                    return true;
                }
            }
            return target instanceof Enemy;
        };
    }

    public static List<Vec3> randomSidedPositions(LivingEntity thrower, int amount, int range) {
        Vec3 pos = thrower.position();
        Vec3 look = thrower.getLookAngle();
        Vec3 vert = new Vec3(0.0, 1.0, 0.0);
        if (-20.0f < thrower.getXRot() && thrower.getXRot() > 20.0f) {
            vert.xRot(thrower.getXRot());
        }
        if (-20.0f > thrower.getXRot()) {
            vert.xRot(-20.0f);
        }
        if (20.0f < thrower.getXRot()) {
            vert.xRot(20.0f);
        }
        Vec3 hor = look.cross(vert);
        vert.normalize();
        hor.normalize();
        float rangeSq = ((float)range - 1.0f) / 2.0f * ((float)range - 1.0f) / 2.0f;
        HashSet<Pair> offsets = new HashSet<Pair>();
        for (int i = 0; i < amount; ++i) {
            Pair offset = Pair.of((Object)(thrower.getRandom().nextInt(range) - (range - 1) / 2), (Object)thrower.getRandom().nextInt((range + 1) / 2));
            double distance = (Integer)offset.getFirst() * (Integer)offset.getFirst() + (Integer)offset.getSecond() * (Integer)offset.getSecond();
            int retry = 0;
            while (distance > (double)rangeSq || offsets.contains(offset) || (Integer)offset.getFirst() == 0 && (Integer)offset.getSecond() == 0) {
                offset = Pair.of((Object)(thrower.getRandom().nextInt(range) - (range - 1) / 2), (Object)thrower.getRandom().nextInt((range + 1) / 2));
                distance = (Integer)offset.getFirst() * (Integer)offset.getFirst() + (Integer)offset.getSecond() * (Integer)offset.getSecond();
                if (++retry <= 10) continue;
            }
            offsets.add(offset);
        }
        return offsets.stream().map(p -> pos.add(hor.scale((double)((Integer)p.getFirst() * 2))).add(vert.scale((double)((Integer)p.getSecond() * 2 + 1)))).toList();
    }

    public static boolean isInView(Entity looking, Entity entity, double degrees) {
        Vec3 view = looking.getViewVector(1.0f).normalize();
        Vec3 dir = new Vec3(entity.getX() - looking.getX(), entity.getEyeY() - looking.getEyeY(), entity.getZ() - looking.getZ());
        double len = dir.length();
        double dot = view.dot(dir = dir.normalize());
        return dot > 1.0 - degrees / len;
    }
}

