/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.world;

import com.google.common.collect.ImmutableSet;
import io.github.flemmli97.fateubw.api.entity.ServantLike;
import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.datapack.DatapackHandler;
import io.github.flemmli97.fateubw.common.datapack.EntityPropsManager;
import io.github.flemmli97.fateubw.common.registry.FateCriterionTriggers;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.world.Participant;
import io.github.flemmli97.fateubw.platform.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GrailWarHandler
extends SavedData {
    private static final String IDENTIFIER = "FateGrailWar";
    private static final Function<MinecraftServer, SavedData.Factory<GrailWarHandler>> FACTORY = server -> new SavedData.Factory(() -> new GrailWarHandler((MinecraftServer)server), (tag, provider) -> new GrailWarHandler((MinecraftServer)server, (CompoundTag)tag, (HolderLookup.Provider)provider), DataFixTypes.LEVEL);
    private final MinecraftServer server;
    private final Map<UUID, Participant<?>> participants = new HashMap();
    private Set<UUID> joinedParticipants = new HashSet<UUID>();
    private final Set<ResourceLocation> servantsTypes = new HashSet<ResourceLocation>();
    private final Set<ResourceLocation> servantClasses = new HashSet<ResourceLocation>();
    private Phase phase = Phase.NONE;
    private int lastGrailEndDay;
    private int joinTime;
    private int timeToNextServant;
    private Map<ChunkPos, ResourceKey<Level>> servantTickets;

    private GrailWarHandler(MinecraftServer server) {
        this.server = server;
    }

    private GrailWarHandler(MinecraftServer server, CompoundTag tag, HolderLookup.Provider provider) {
        this.server = server;
        this.load(tag);
    }

    public static GrailWarHandler get(MinecraftServer server) {
        return (GrailWarHandler)server.overworld().getDataStorage().computeIfAbsent(FACTORY.apply(server), IDENTIFIER);
    }

    private static int day(Level level) {
        return (int)(level.getDayTime() / 24000L % Integer.MAX_VALUE);
    }

    public boolean join(ServantLike<?> servant) {
        JoinResult res;
        Player player = servant.getOwner();
        if (player != null && (res = this.checkJoining(player)) != JoinResult.SUCCESS) {
            player.sendSystemMessage((Component)Component.translatable((String)res.translationKey));
            return false;
        }
        if (!this.joinInternal(player, servant)) {
            if (player != null) {
                player.sendSystemMessage((Component)Component.translatable((String)JoinResult.WRONG_SERVANT.translationKey));
            }
            return false;
        }
        this.setDirty();
        return true;
    }

    public boolean forceStartGrailWar() {
        if (this.phase == Phase.NONE) {
            this.setupStart();
            return true;
        }
        return false;
    }

    private boolean joinInternal(@Nullable Player player, ServantLike<?> servant) {
        Participant participant = new Participant(servant, player);
        if (!this.participants.containsKey(participant.getId()) && this.canSpawnServant(servant)) {
            this.participants.put(participant.getId(), participant);
            this.servantClasses.add(servant.props().servantClass());
            this.servantsTypes.add(BuiltInRegistries.ENTITY_TYPE.getKey((Object)servant.get().getType()));
            this.joinedParticipants.add(participant.getId());
            return true;
        }
        return false;
    }

    public JoinResult checkJoining(Player player) {
        if (this.phase != Phase.JOIN) {
            return JoinResult.WRONG_STATE;
        }
        if (this.isFull()) {
            return JoinResult.FULL;
        }
        if (this.joinedParticipants.contains(player.getUUID())) {
            return JoinResult.JOINED;
        }
        if (!this.canSpawnMoreServants(player.level())) {
            return JoinResult.NO_MORE_SERVANTS;
        }
        return JoinResult.SUCCESS;
    }

    public boolean isFull() {
        if (this.phase == Phase.JOIN) {
            return this.participants.size() >= CommonConfig.maxPlayer;
        }
        return this.joinedParticipants.size() >= CommonConfig.maxPlayer;
    }

    public boolean isParticipant(Entity entity) {
        ServantLike servant;
        if (entity instanceof ServantLike && (servant = (ServantLike)entity).getOwnerUUID() != null) {
            return this.participants.containsKey(servant.getOwnerUUID());
        }
        return this.participants.containsKey(entity.getUUID());
    }

    public Optional<ServantLike<?>> getServant(ServerPlayer player) {
        Participant<?> participant = this.participants.get(player.getUUID());
        if (participant != null) {
            return Optional.ofNullable((ServantLike)participant.getServant(this.server));
        }
        return Optional.empty();
    }

    public Set<UUID> players(boolean valid) {
        return ImmutableSet.copyOf(this.participants.entrySet().stream().filter(p -> ((Participant)p.getValue()).isPlayerParticipant() && (!valid || ((Participant)p.getValue()).valid(this.server))).map(Map.Entry::getKey).toList());
    }

    public void tick(ServerLevel level) {
        this.loadTickets(level);
        switch (this.phase.ordinal()) {
            case 0: {
                if (Math.abs(GrailWarHandler.day((Level)level) - this.lastGrailEndDay) <= CommonConfig.grailWarCooldown || level.getDayTime() % 24000L != 1L) break;
                this.setupStart();
                break;
            }
            case 1: {
                if (--this.joinTime <= 0) {
                    this.start();
                }
                HashSet invalid = new HashSet();
                this.participants.forEach((id, participant) -> {
                    if (!participant.valid(this.server)) {
                        invalid.add(id);
                        Object servant = participant.getServant(this.server);
                        if (servant != null) {
                            servant.hurt(FateDamageTypes.grail(servant.registryAccess()), 2.1474836E9f);
                        }
                    }
                });
                invalid.forEach(this.participants::remove);
                break;
            }
            case 2: {
                if (CommonConfig.fillMissingSlots && --this.timeToNextServant <= 0) {
                    this.trySpawnNPCServant(level);
                }
                this.runGrailWar();
            }
        }
        this.setDirty();
    }

    private void loadTickets(ServerLevel level) {
        if (this.servantTickets != null) {
            this.servantTickets.forEach((c, r) -> {
                if (level.dimension().equals(r)) {
                    level.getChunkSource().addRegionTicket(ServantLike.TRACKINGTICKET, c, 2, c);
                } else {
                    ServerLevel w = this.server.getLevel(r);
                    w.getChunkSource().addRegionTicket(ServantLike.TRACKINGTICKET, c, 2, c);
                }
            });
            this.servantTickets = null;
        }
    }

    private void setupStart() {
        this.joinTime = CommonConfig.joinTime;
        this.phase = Phase.JOIN;
        this.server.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"fateubw.chat.grailwar.init", (Object[])new Object[]{this.joinTime / 20}).withStyle(ChatFormatting.LIGHT_PURPLE), true);
    }

    private void start() {
        this.phase = Phase.ACTIVE;
        Set<UUID> players = this.players(true);
        if (players.size() >= CommonConfig.minPlayer) {
            this.server.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"fateubw.chat.grailwar.start").withStyle(ChatFormatting.GOLD), true);
            this.joinedParticipants = new HashSet<UUID>(this.participants.keySet());
        } else if (players.isEmpty()) {
            this.server.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"fateubw.chat.grailwar.players.none").withStyle(ChatFormatting.RED), true);
            this.reset(false);
        } else {
            this.joinTime = CommonConfig.joinTime;
            this.phase = Phase.JOIN;
            this.server.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"fateubw.chat.grailwar.players.missing").withStyle(ChatFormatting.RED), true);
        }
        this.setDirty();
    }

    private void runGrailWar() {
        HashSet invalid = new HashSet();
        this.participants.forEach((id, participant) -> {
            if (!participant.valid(this.server) && invalid.size() + 1 < this.participants.size()) {
                Object servant;
                invalid.add(id);
                if (participant.isPlayerParticipant()) {
                    this.server.getProfileCache().get(participant.getId()).ifPresent(prof -> this.broadcastParticipants((Component)Component.translatable((String)"fateubw.chat.grailwar.player.out", (Object[])new Object[]{prof.getName()}).withStyle(ChatFormatting.RED)));
                }
                if ((servant = participant.getServant(this.server)) != null) {
                    servant.hurt(FateDamageTypes.grail(servant.registryAccess()), 2.1474836E9f);
                }
            }
        });
        invalid.forEach(this.participants::remove);
        if (this.players(false).isEmpty()) {
            this.reset(false);
            this.server.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"fateubw.chat.grailwar.players.dead").withStyle(ChatFormatting.RED), true);
        } else if (this.isFull()) {
            if (this.participants.isEmpty()) {
                this.reset(true);
            } else if (this.participants.size() == 1) {
                Participant<?> participant2 = this.participants.values().iterator().next();
                ServerPlayer player = participant2.getAsPlayer(this.server);
                if (player != null) {
                    String name = player.getGameProfile().getName();
                    ((PlayerTrigger)FateCriterionTriggers.WIN_GRAIL_WAR.get()).trigger(player);
                    this.server.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"fateubw.chat.grailwar.win", (Object[])new Object[]{name}).withStyle(ChatFormatting.GOLD), true);
                    ItemEntity holyGrail = new ItemEntity(player.level(), player.getX() + (double)player.getRandom().nextInt(7) - 3.0, player.getY() + 3.0, player.getZ() + (double)player.getRandom().nextInt(7) - 3.0, new ItemStack((ItemLike)FateItems.GRAIL.get()));
                    holyGrail.setExtendedLifetime();
                    holyGrail.setThrower((Entity)player);
                    holyGrail.setInvulnerable(true);
                    holyGrail.setGlowingTag(true);
                    holyGrail.setNoGravity(true);
                    player.level().addFreshEntity((Entity)holyGrail);
                    player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.grailwar.win.spawn").withStyle(ChatFormatting.GRAY));
                    Platform.INSTANCE.getPlayerData((Player)player).saveServant((ServantLike)participant2.getServant(this.server));
                } else {
                    this.server.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"fateubw.chat.grailwar.win.none").withStyle(ChatFormatting.RED), true);
                }
                this.reset(false);
            }
        }
    }

    public void reset(boolean notify) {
        this.participants.values().forEach(participant -> {
            Object servant = participant.getServant(this.server);
            if (servant != null) {
                servant.hurt(FateDamageTypes.grail(servant.registryAccess()), 2.1474836E9f);
            }
        });
        this.participants.clear();
        this.servantsTypes.clear();
        this.servantClasses.clear();
        this.joinedParticipants.clear();
        this.phase = Phase.NONE;
        this.lastGrailEndDay = GrailWarHandler.day((Level)this.server.overworld());
        this.joinTime = 0;
        this.timeToNextServant = 0;
        if (notify) {
            this.server.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"fateubw.chat.grailwar.end").withStyle(ChatFormatting.RED), true);
        }
        this.setDirty();
    }

    public boolean canSpawnMoreServants(Level level) {
        for (EntityPropsManager.EntityTypeAndID entry : DatapackHandler.SERVANT_PROPS.getServants()) {
            boolean canSpawn = CommonConfig.allowDuplicateServant || !this.servantsTypes.contains(entry.id());
            if (!canSpawn || !CommonConfig.allowDuplicateClass && this.servantClasses.contains(DatapackHandler.SERVANT_PROPS.get((EntityType)entry.type().value()).servantClass())) continue;
            return true;
        }
        return false;
    }

    public boolean canSpawnServant(ServantLike<?> servant) {
        if (this.isFull()) {
            return false;
        }
        if (!this.canSpawnServantType(BuiltInRegistries.ENTITY_TYPE.getKey((Object)servant.get().getType()))) {
            return false;
        }
        return this.canSpawnServantClass(servant.props().servantClass());
    }

    public boolean canSpawnServantType(ResourceLocation entityType) {
        if (this.isFull()) {
            return false;
        }
        return CommonConfig.allowDuplicateServant || !this.servantsTypes.contains(entityType);
    }

    public boolean canSpawnServantClass(ResourceLocation servantClass) {
        if (this.isFull()) {
            return false;
        }
        return CommonConfig.allowDuplicateClass || !this.servantClasses.contains(servantClass);
    }

    private void trySpawnNPCServant(ServerLevel level) {
        if (this.isFull()) {
            return;
        }
        ArrayList players = new ArrayList();
        Set<UUID> playerParticipant = this.players(false);
        this.server.getPlayerList().getPlayers().forEach(player -> {
            if (playerParticipant.contains(player.getUUID())) {
                players.add(player);
            }
        });
        int spawns = Math.min(level.random.nextInt(CommonConfig.maxServantCircle) + 1, CommonConfig.maxPlayer - this.joinedParticipants.size());
        for (int i = 0; i < spawns; ++i) {
            if (players.isEmpty()) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)players.remove(level.random.nextInt(players.size()));
            double xR = player2.serverLevel().random.nextDouble() - 0.5;
            double zR = player2.serverLevel().random.nextDouble() - 0.5;
            int x = (int)(player2.getX() + xR * 128.0 + (double)(xR <= 0.0 ? -24 : 24));
            int z = (int)(player2.getZ() + zR * 128.0 + (double)(zR <= 0.0 ? -24 : 24));
            ChunkPos cpos = new ChunkPos(x >> 4, z >> 4);
            LevelChunk chunk = player2.serverLevel().getChunk(cpos.x, cpos.z);
            int y = chunk.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z) + 1;
            ServantLike<?> servant = this.summonRandomServant(player2.serverLevel(), new Vec3((double)x, (double)y, (double)z), null, null, true, true);
            if (servant == null) continue;
            player2.serverLevel().getChunkSource().addRegionTicket(ServantLike.TRACKINGTICKET, cpos, 2, (Object)cpos);
            this.timeToNextServant = Mth.nextInt((RandomSource)player2.serverLevel().random, (int)CommonConfig.servantMinSpawnDelay, (int)CommonConfig.servantMaxSpawnDelay);
            if (!this.notify(BuiltInRegistries.ENTITY_TYPE.getKey((Object)servant.get().getType()))) continue;
            if (CommonConfig.notifyAll) {
                this.broadcastParticipants((Component)Component.translatable((String)"fateubw.chat.grailwar.spawn", (Object[])new Object[]{player2.getName()}).withStyle(ChatFormatting.GRAY));
                continue;
            }
            player2.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.grailwar.spawn", (Object[])new Object[]{player2.getName()}).withStyle(ChatFormatting.GRAY));
        }
    }

    private boolean notify(ResourceLocation loc) {
        return CommonConfig.notificationWhitelist == CommonConfig.notifyBlacklist.contains(loc.toString());
    }

    public void broadcastParticipants(Component message) {
        this.server.getPlayerList().broadcastSystemMessage(message, player -> this.isParticipant((Entity)player) ? message : null, true);
    }

    public ServantLike<?> summonRandomServant(ServerLevel level, Vec3 pos, @Nullable ServerPlayer player, @Nullable ItemStack stack, boolean event, boolean addToLevel) {
        Entity entity = DatapackHandler.SERVANT_PROPS.getRandom(level.getRandom(), entry -> this.canSpawnServantClass(entry.servantClass()) && this.canSpawnServantType(entry.id()), stack).map(t -> ((EntityType)t.type().value()).create(level, null, BlockPos.containing((Position)pos), MobSpawnType.MOB_SUMMONED, false, false)).orElse(null);
        if (!(entity instanceof ServantLike)) {
            return null;
        }
        ServantLike servant = (ServantLike)entity;
        Object mob = servant.get();
        mob.moveTo(pos.x(), pos.y(), pos.z(), level.random.nextFloat() * 360.0f, 0.0f);
        if (player != null) {
            mob.lookAt(EntityAnchorArgument.Anchor.EYES, player.position());
        }
        servant.setOwner((Player)player);
        if (!mob.checkSpawnObstruction((LevelReader)level) || event && !Platform.INSTANCE.canSpawnEvent((Mob)mob, (ServerLevelAccessor)level, MobSpawnType.TRIGGERED)) {
            return null;
        }
        this.join(servant);
        mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.TRIGGERED, null);
        if (addToLevel) {
            level.addFreshEntity(mob);
        }
        return servant;
    }

    public void moveToPlayer(ServantLike<?> servantLike) {
        if (servantLike.getOwnerUUID() != null || servantLike.get().getServer() == null) {
            return;
        }
        Object servant = servantLike.get();
        if (!this.hasPlayersNearby((Entity)servant)) {
            List<ServerPlayer> players = servant.getServer().getPlayerList().getPlayers().stream().filter(this::isParticipant).toList();
            ServerPlayer player = players.get(servant.getRandom().nextInt(players.size()));
            for (int i = 0; i < 10; ++i) {
                double xR = servant.getRandom().nextDouble() - 0.5;
                double zR = servant.getRandom().nextDouble() - 0.5;
                double x = player.getX() + xR * 128.0 + (double)(xR <= 0.0 ? -24 : 24);
                double z = player.getZ() + zR * 128.0 + (double)(zR <= 0.0 ? -24 : 24);
                double y = player.getY() + (double)(servant.getRandom().nextInt(64) - 32);
                if (servant.randomTeleport(x, y, z, false)) break;
            }
        }
    }

    private boolean hasPlayersNearby(Entity entity) {
        for (Player player : entity.level().players()) {
            double dist;
            if (!this.isParticipant((Entity)player) || !((dist = player.distanceToSqr(entity.getX(), player.getY(), entity.getZ())) < 65536.0)) continue;
            return true;
        }
        return false;
    }

    public void load(CompoundTag compound) {
        ListTag tag = compound.getList("Participants", 10);
        tag.forEach(cT -> {
            Participant participant = new Participant((CompoundTag)cT);
            this.participants.put(participant.getId(), participant);
        });
        ListTag joined = compound.getList("JoinedParticipants", 11);
        joined.forEach(s -> this.joinedParticipants.add(NbtUtils.loadUUID((Tag)s)));
        ListTag list = compound.getList("Servants", 8);
        list.forEach(s -> this.servantsTypes.add(ResourceLocation.parse((String)s.getAsString())));
        ListTag list2 = compound.getList("ServantClasses", 8);
        list2.forEach(s -> this.servantClasses.add(ResourceLocation.parse((String)s.getAsString())));
        this.phase = Phase.valueOf(compound.getString("Phase"));
        this.lastGrailEndDay = compound.getInt("LastGrailWarDay");
        this.joinTime = compound.getInt("JoinTime");
        this.timeToNextServant = compound.getInt("NextServantSpawnTick");
        CompoundTag tickets = compound.getCompound("ToLoadChunks");
        tickets.getAllKeys().forEach(id -> {
            CompoundTag entryTag = tickets.getCompound(id);
            this.servantTickets.put(new ChunkPos(entryTag.getLong("Position")), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)entryTag.getString("Level"))));
        });
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        ListTag tag = new ListTag();
        this.participants.values().forEach(p -> tag.add((Object)p.save()));
        compound.put("Participants", (Tag)tag);
        ListTag joined = new ListTag();
        this.joinedParticipants.forEach(id -> joined.add((Object)NbtUtils.createUUID((UUID)id)));
        compound.put("JoinedParticipants", (Tag)joined);
        ListTag list = new ListTag();
        this.servantsTypes.forEach(res -> list.add((Object)StringTag.valueOf((String)res.toString())));
        compound.put("Servants", (Tag)list);
        ListTag list2 = new ListTag();
        this.servantClasses.forEach(e -> list2.add((Object)StringTag.valueOf((String)e.toString())));
        compound.put("ServantClasses", (Tag)list2);
        compound.putString("Phase", this.phase.toString());
        compound.putInt("LastGrailWarDay", this.lastGrailEndDay);
        compound.putInt("JoinTime", this.joinTime);
        compound.putInt("NextServantSpawnTick", this.timeToNextServant);
        CompoundTag tickets = new CompoundTag();
        this.participants.forEach((uuid, participant) -> {
            Object servant = participant.getServant(this.server);
            if (servant != null) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putLong("Position", ChunkPos.asLong((BlockPos)servant.blockPosition()));
                entryTag.putString("Level", servant.level().dimension().location().toString());
                tickets.put(uuid.toString(), (Tag)entryTag);
            }
        });
        compound.put("ToLoadChunks", (Tag)tickets);
        return compound;
    }

    static enum Phase {
        NONE,
        JOIN,
        ACTIVE;

    }

    public static enum JoinResult {
        WRONG_STATE("fateubw.war.join.result.fail"),
        FULL("fateubw.war.join.result.full"),
        JOINED("fateubw.war.join.result.joined"),
        WRONG_SERVANT("fateubw.war.join.servant.fail"),
        NO_MORE_SERVANTS("fateubw.war.join.servant.full"),
        SUCCESS("fateubw.war.join.success");

        public final String translationKey;

        private JoinResult(String translationKey) {
            this.translationKey = translationKey;
        }
    }
}

