/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.world;

import io.github.flemmli97.fateubw.api.entity.ServantLike;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Participant<T extends Mob> {
    private final ParticipantId uuid;
    private ResourceKey<Level> levelCache;
    private WeakReference<T> servant;

    public Participant(ServantLike<T> servant, @Nullable Player player) {
        this(servant.get(), player != null ? player.getUUID() : null);
    }

    public Participant(ServantLike<T> servant, @Nullable UUID player) {
        this(servant.get(), player);
    }

    private Participant(T servant, @Nullable UUID player) {
        this.uuid = new ParticipantId(player != null ? player : servant.getUUID(), servant.getUUID());
        this.servant = new WeakReference<T>(servant);
    }

    public Participant(CompoundTag tag) {
        this.uuid = new ParticipantId(tag.getUUID("UUID"), tag.getUUID("Servant"));
        if (tag.contains("CachedLevel")) {
            this.levelCache = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString("CachedLevel")));
        }
    }

    public boolean isPlayerParticipant() {
        return !this.uuid.participant().equals(this.uuid.servant());
    }

    public UUID getId() {
        return this.uuid.participant();
    }

    @Nullable
    public ServerPlayer getAsPlayer(MinecraftServer server) {
        if (!this.isPlayerParticipant()) {
            return null;
        }
        return server.getPlayerList().getPlayer(this.uuid.participant());
    }

    public T getServant(MinecraftServer server) {
        Mob servant;
        Mob mob = servant = this.servant == null ? null : (Mob)this.servant.get();
        if (servant == null || !servant.isAlive()) {
            Entity entity;
            ServerLevel level;
            if (this.levelCache != null && (level = server.getLevel(this.levelCache)) != null && (entity = EntityUtils.findFromUUID(Entity.class, (Level)level, (UUID)this.uuid.servant())) instanceof ServantLike) {
                this.servant = new WeakReference<Mob>((Mob)entity);
                return (T)((Mob)this.servant.get());
            }
            for (ServerLevel level2 : server.getAllLevels()) {
                Entity entity2 = EntityUtils.findFromUUID(BaseServant.class, (Level)level2, (UUID)this.uuid.servant());
                if (!(entity2 instanceof ServantLike)) continue;
                this.servant = new WeakReference<Mob>((Mob)entity2);
                this.levelCache = entity2.level().dimension();
                break;
            }
        }
        return (T)servant;
    }

    public boolean valid(MinecraftServer server) {
        T servant = this.getServant(server);
        return servant != null && servant.isAlive();
    }

    private ResourceKey<Level> cachedLevel() {
        Mob servant = this.servant == null ? null : (Mob)this.servant.get();
        return servant != null ? servant.level().dimension() : null;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Participant)) {
            return false;
        }
        Participant participant = (Participant)obj;
        return this.getId().equals(participant.getId());
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.putUUID("UUID", this.uuid.participant());
        tag.putUUID("Servant", this.uuid.servant());
        ResourceKey<Level> cache = this.cachedLevel();
        if (cache != null) {
            tag.putString("CachedLevel", cache.location().toString());
        }
        return tag;
    }

    private record ParticipantId(UUID participant, UUID servant) {
    }
}

