/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.neoforge.data;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.client.ItemModelProps;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.SwordItem;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemModels
extends ItemModelProvider {
    public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "fateubw", existingFileHelper);
    }

    protected void registerModels() {
        int sealid = 1;
        for (RegistryEntrySupplier reg : FateItems.ITEMS.getEntries()) {
            if (reg == FateItems.ENUMAELISH || reg == FateItems.HERACLES_AXE) continue;
            if (reg == FateItems.MEDUSA_DAGGER) {
                this.withInventoryVariant(reg, ModelLocationUtils.decorateItemModelLocation((String)"handheld")).override().predicate(ItemModelProps.THROWN_DAGGER_ID, 1.0f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(reg.getID().getPath() + "_thrown", ModelLocationUtils.decorateItemModelLocation((String)"handheld"))).texture("layer0", this.itemTexture(reg.getID().getPath() + "_thrown"))).transforms().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(1.13f, 6.3f, 1.13f).scale(0.68f, 0.68f, 0.68f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(1.13f, 6.3f, 1.13f).scale(0.68f, 0.68f, 0.68f).end().end()).end();
                continue;
            }
            if (reg == FateItems.EMIYAS_BOW) {
                ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(reg.getID().getPath(), ModelLocationUtils.decorateItemModelLocation((String)"generated"))).texture("layer0", Fate.modRes(this.folder + "/emiyas_bow"))).override().predicate(ItemModelProps.BOW_PULL_ID, 0.05f).predicate(ItemModelProps.CALADBOLG_ID, 0.0f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(reg.getID().getPath() + "_pull_0", Fate.modRes("item/" + reg.getID().getPath()))).texture("layer0", Fate.modRes(this.folder + "/emiyas_bow_pull_0"))).end().override().predicate(ItemModelProps.BOW_PULL_ID, 0.65f).predicate(ItemModelProps.CALADBOLG_ID, 0.0f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(reg.getID().getPath() + "_pull_1", Fate.modRes("item/" + reg.getID().getPath()))).texture("layer0", Fate.modRes(this.folder + "/emiyas_bow_pull_1"))).end().override().predicate(ItemModelProps.BOW_PULL_ID, 0.9f).predicate(ItemModelProps.CALADBOLG_ID, 0.0f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(reg.getID().getPath() + "_pull_2", Fate.modRes("item/" + reg.getID().getPath()))).texture("layer0", Fate.modRes(this.folder + "/emiyas_bow_pull_2"))).end().override().predicate(ItemModelProps.BOW_PULL_ID, 0.05f).predicate(ItemModelProps.CALADBOLG_ID, 1.0f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(reg.getID().getPath() + "_caladbolg_pull_0", Fate.modRes("item/" + reg.getID().getPath()))).texture("layer0", Fate.modRes(this.folder + "/emiyas_bow_caladbolg_pull_0"))).end().override().predicate(ItemModelProps.BOW_PULL_ID, 0.65f).predicate(ItemModelProps.CALADBOLG_ID, 1.0f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(reg.getID().getPath() + "_caladbolg_pull_1", Fate.modRes("item/" + reg.getID().getPath()))).texture("layer0", Fate.modRes(this.folder + "/emiyas_bow_caladbolg_pull_1"))).end().override().predicate(ItemModelProps.BOW_PULL_ID, 0.9f).predicate(ItemModelProps.CALADBOLG_ID, 1.0f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(reg.getID().getPath() + "_caladbolg_pull_2", Fate.modRes("item/" + reg.getID().getPath()))).texture("layer0", Fate.modRes(this.folder + "/emiyas_bow_caladbolg_pull_2"))).end().transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(-80.0f, 260.0f, -40.0f).translation(-1.0f, -2.0f, 2.5f).scale(0.9f, 0.9f, 0.9f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(-80.0f, -280.0f, 40.0f).translation(-1.0f, -2.0f, 2.5f).scale(0.9f, 0.9f, 0.9f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f, 0.68f, 0.68f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f, 0.68f, 0.68f).end();
                continue;
            }
            if (reg == FateItems.GAEBOLG) {
                this.withInventoryVariant(reg, "spear_item");
                continue;
            }
            if (reg == FateItems.GAEBUIDHE || reg == FateItems.GAEDEARG) {
                this.withInventoryVariant(reg, "spear_item").override().predicate(ItemModelProps.UNSEALED_ID, 1.0f).model((ModelFile)((SeparateTransformsModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(reg.getID().getPath() + "_unsealed")).guiLight(BlockModel.GuiLight.FRONT)).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(Fate.modRes(this.folder + "/spear_item")))).texture("layer0", this.itemTexture(reg.getID().withPath(p -> p + "_unsealed"))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.mcLoc(this.folder + "/handheld")))).texture("layer0", this.itemTexture(reg.getID().withPath(s -> s + "_inventory"))))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.mcLoc(this.folder + "/handheld")))).texture("layer0", this.itemTexture(reg.getID().withPath(s -> s + "_inventory"))))).end()).end();
                continue;
            }
            if (reg == FateItems.ARONDIGHT || reg == FateItems.MONOHOSHI_ZAO || reg == FateItems.STAFF) {
                this.withInventoryVariant(reg, "handheld_32x32");
                continue;
            }
            if (reg.get() instanceof SpawnEgg) {
                this.withExistingParent(reg.getID().getPath(), ModelLocationUtils.decorateItemModelLocation((String)"template_spawn_egg"));
                continue;
            }
            if (reg == FateItems.INVISEXCALIBUR) {
                ((ItemModelBuilder)this.withExistingParent(reg.getID().getPath(), Fate.modRes(this.folder + "/handheld_32x32"))).texture("layer0", this.itemTexture(reg.getID()));
                continue;
            }
            if (reg == FateItems.EXCALIBUR) {
                this.withInventoryVariant(reg, "handheld_32x32").override().predicate(ItemModelProps.ACTIVE_ID, 1.0f).model((ModelFile)this.getExistingFile(Fate.modRes("excalibur_active"))).end();
                continue;
            }
            Object object = reg.get();
            if (object instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)object;
                this.simpleBlockItem(blockItem.getBlock());
                continue;
            }
            if (reg.get() instanceof SwordItem) {
                ((ItemModelBuilder)this.withExistingParent(reg.getID().getPath(), ModelLocationUtils.decorateItemModelLocation((String)"handheld"))).texture("layer0", this.itemTexture(reg.getID()));
                continue;
            }
            if (reg == FateItems.ICON_0 || reg == FateItems.ICON_1 || reg == FateItems.ICON_2 || reg == FateItems.ICON_3) {
                ((ItemModelBuilder)this.withExistingParent(reg.getID().getPath(), ModelLocationUtils.decorateItemModelLocation((String)"generated"))).texture("layer0", Fate.modRes(this.folder + "/command_seal_" + sealid));
                ++sealid;
                continue;
            }
            if (reg == FateItems.CRYSTAL_RED || reg == FateItems.CRYSTAL_YELLOW || reg == FateItems.CRYSTAL_BLACK || reg == FateItems.CRYSTAL_BLUE || reg == FateItems.CRYSTAL_GREEN) {
                ((ItemModelBuilder)this.withExistingParent(reg.getID().getPath(), Fate.modRes(this.folder + "/gem_shard"))).texture("layer0", this.itemTexture(reg.getID()));
                continue;
            }
            if (reg == FateItems.ANIMATION_DEBUG) {
                this.singleTexture(reg.getID().getPath(), this.mcLoc(this.folder + "/generated"), "layer0", ResourceLocation.withDefaultNamespace((String)"item/stick"));
                continue;
            }
            ((ItemModelBuilder)this.withExistingParent(reg.getID().getPath(), ModelLocationUtils.decorateItemModelLocation((String)"generated"))).texture("layer0", this.itemTexture(reg.getID()));
        }
    }

    private ItemModelBuilder withInventoryVariant(RegistryEntrySupplier<Item, ?> reg, String parent) {
        return this.withInventoryVariant(reg, Fate.modRes(this.folder + "/" + parent));
    }

    private ItemModelBuilder withInventoryVariant(RegistryEntrySupplier<Item, ?> reg, ResourceLocation parent) {
        return (ItemModelBuilder)((SeparateTransformsModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(reg.getID().getPath())).guiLight(BlockModel.GuiLight.FRONT)).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(parent))).texture("layer0", this.itemTexture(reg.getID())))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.mcLoc(this.folder + "/handheld")))).texture("layer0", this.itemTexture(reg.getID().withPath(s -> s + "_inventory"))))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.mcLoc(this.folder + "/handheld")))).texture("layer0", this.itemTexture(reg.getID().withPath(s -> s + "_inventory"))))).end();
    }

    private ResourceLocation itemTexture(ResourceLocation item) {
        return ResourceLocation.fromNamespaceAndPath((String)item.getNamespace(), (String)(this.folder + "/" + item.getPath()));
    }

    private ResourceLocation itemTexture(String texture) {
        return Fate.modRes(this.folder + "/" + texture);
    }
}

