/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.neoforge.data;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.registry.FateBlocks;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class Loottables
extends LootTableProvider {
    public Loottables(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(EntityLoot::new, LootContextParamSets.ENTITY), new LootTableProvider.SubProviderEntry(BlockLoot::new, LootContextParamSets.BLOCK)), registries);
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
    }

    static class BlockLoot
    extends BlockLootSubProvider {
        private final Map<ResourceKey<LootTable>, LootTable.Builder> loots = new HashMap<ResourceKey<LootTable>, LootTable.Builder>();

        BlockLoot(HolderLookup.Provider registries) {
            super(Set.of(), FeatureFlagSet.of(), registries);
        }

        protected void generate() {
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
            this.dropSelf((Block)FateBlocks.ALTAR.get());
            ResourceKey artifacts = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Fate.modRes("blocks/artifacts"));
            this.registerLootTable((ResourceKey<LootTable>)artifacts, this.artifactLoot());
            this.add((Block)FateBlocks.ARTIFACT_ORE.get(), (Block drop) -> this.createSilkTouchDispatchTable((Block)drop, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)drop, (ConditionUserBuilder)NestedLootTable.lootTableReference((ResourceKey)artifacts))));
            this.add((Block)FateBlocks.DEEP_SLATE_ARTIFACT_ORE.get(), (Block drop) -> this.createSilkTouchDispatchTable((Block)drop, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)drop, (ConditionUserBuilder)NestedLootTable.lootTableReference((ResourceKey)artifacts))));
            ResourceKey crystal = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Fate.modRes("blocks/crystals"));
            this.registerLootTable((ResourceKey<LootTable>)crystal, this.createOreLootPool(5, (ItemLike)FateItems.CRYSTAL_YELLOW.get(), (ItemLike)FateItems.CRYSTAL_GREEN.get(), (ItemLike)FateItems.CRYSTAL_BLUE.get(), (ItemLike)FateItems.CRYSTAL_BLACK.get(), (ItemLike)FateItems.CRYSTAL_RED.get()));
            this.add((Block)FateBlocks.GEM_ORE.get(), (Block drop) -> this.createSilkTouchDispatchTable((Block)drop, (LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)crystal)));
            this.add((Block)FateBlocks.DEEP_SLATE_GEM_ORE.get(), (Block drop) -> this.createSilkTouchDispatchTable((Block)drop, (LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)crystal)));
            this.loots.forEach(output);
        }

        protected LootTable.Builder artifactLoot() {
            LootPool.Builder build = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
            build.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)FateItems.ARTIFACT_SABER.get())));
            build.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)FateItems.ARTIFACT_ARCHER.get())));
            build.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)FateItems.ARTIFACT_LANCER.get())));
            build.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)FateItems.ARTIFACT_CASTER.get())));
            build.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)FateItems.ARTIFACT_BERSERKER.get())));
            build.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)FateItems.ARTIFACT_RIDER.get())));
            build.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)FateItems.ARTIFACT_ASSASSIN.get())));
            return LootTable.lootTable().withPool(build);
        }

        protected LootTable.Builder createOreLootPool(int weight, ItemLike ... items) {
            LootPool.Builder build = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
            for (ItemLike item : items) {
                build.add(this.ore(weight, item));
            }
            return LootTable.lootTable().withPool(build);
        }

        private LootPoolSingletonContainer.Builder<?> ore(int weight, ItemLike item) {
            return LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE))).setWeight(weight);
        }

        public void add(Block block, Function<Block, LootTable.Builder> function) {
            this.add(block, function.apply(block));
        }

        public void add(Block block, LootTable.Builder builder) {
            this.loots.put((ResourceKey<LootTable>)block.getLootTable(), builder);
        }

        protected void registerLootTable(ResourceKey<LootTable> id, LootTable.Builder builder) {
            this.loots.put(id, builder);
        }
    }

    static class EntityLoot
    implements LootTableSubProvider {
        protected final Map<ResourceKey<LootTable>, LootTable.Builder> lootTables = new HashMap<ResourceKey<LootTable>, LootTable.Builder>();
        protected final HolderLookup.Provider provider;

        EntityLoot(HolderLookup.Provider provider) {
            this.provider = provider;
        }

        private void init() {
            this.registerLootTable((EntityType)FateEntities.ARTHUR.get(), this.getDefault((ItemLike)FateItems.EXCALIBUR.get()));
            this.registerLootTable((EntityType)FateEntities.CUCHULAINN.get(), this.getDefault((ItemLike)FateItems.GAEBOLG.get()));
            this.registerLootTable((EntityType)FateEntities.DIARMUID.get(), this.getDefault((ItemLike)FateItems.GAEBUIDHE.get(), (ItemLike)FateItems.GAEDEARG.get()));
            this.registerLootTable((EntityType)FateEntities.EMIYA.get(), this.getDefault((ItemLike)FateItems.EMIYAS_BOW.get(), (ItemLike)FateItems.KANSHOU.get(), (ItemLike)FateItems.BAKUYA.get()));
            this.registerLootTable((EntityType)FateEntities.GILGAMESH.get(), this.getDefault((ItemLike)FateItems.ENUMAELISH.get()));
            this.registerLootTable((EntityType)FateEntities.MEDEA.get(), this.getDefault((ItemLike)FateItems.STAFF.get(), (ItemLike)FateItems.RULE_BREAKER.get()));
            this.registerLootTable((EntityType)FateEntities.GILLES.get(), this.getDefault((ItemLike)FateItems.GRIMOIRE.get()));
            this.registerLootTable((EntityType)FateEntities.HERACLES.get(), this.getDefault((ItemLike)FateItems.HERACLES_AXE.get()));
            this.registerLootTable((EntityType)FateEntities.LANCELOT.get(), this.getDefault((ItemLike)FateItems.ARONDIGHT.get()));
            this.registerLootTable((EntityType)FateEntities.ISKANDER.get(), this.getDefault((ItemLike)FateItems.KUPRIOTS.get()));
            this.registerLootTable((EntityType)FateEntities.MEDUSA.get(), this.getDefault((ItemLike)FateItems.MEDUSA_DAGGER.get()));
            this.registerLootTable((EntityType)FateEntities.HASSAN.get(), this.getDefault((ItemLike)FateItems.ASSASSIN_DAGGER.get()));
            this.registerLootTable((EntityType)FateEntities.SASAKI.get(), this.getDefault((ItemLike)FateItems.MONOHOSHI_ZAO.get()));
        }

        private LootTable.Builder getDefault(ItemLike ... items) {
            LootPool.Builder build = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
            for (ItemLike item : items) {
                build.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item));
            }
            return LootTable.lootTable().withPool(build);
        }

        protected void registerLootTable(EntityType<?> type, LootTable.Builder builder) {
            this.lootTables.put((ResourceKey<LootTable>)type.getDefaultLootTable(), builder);
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
            this.init();
            this.lootTables.forEach(output);
        }
    }
}

