/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.neoforge.data;

import io.github.flemmli97.fateubw.common.registry.FateSounds;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.SoundDefinition;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;

public class SoundGen
extends SoundDefinitionsProvider {
    public SoundGen(PackOutput packOutput, ExistingFileHelper helper) {
        super(packOutput, "fateubw", helper);
    }

    public void registerSounds() {
        this.add((SoundEvent)FateSounds.ENTITY_BABYLON_SPAWN.get(), SoundGen.fromEvent(SoundEvents.BEACON_ACTIVATE.getLocation()));
        this.add((SoundEvent)FateSounds.ENTITY_BABYLON_SHOOT.get(), SoundGen.fromEvent(SoundEvents.PLAYER_ATTACK_SWEEP.getLocation()), 7, false);
        this.add((SoundEvent)FateSounds.ENTITY_EXCALIBUR_SHOOT.get(), ResourceLocation.withDefaultNamespace((String)"random/explode"), 4, false);
        this.add((SoundEvent)FateSounds.ENTITY_EA_SHOOT.get(), ResourceLocation.withDefaultNamespace((String)"random/explode"), 4, false);
        this.add((SoundEvent)FateSounds.HERACLES_ROAR.get());
    }

    private void add(SoundEvent event) {
        this.add(event, ResourceLocation.fromNamespaceAndPath((String)event.getLocation().getNamespace(), (String)event.getLocation().getPath().replace(".", "/")));
    }

    private void add(SoundEvent event, ResourceLocation sound) {
        this.add(event, SoundGen.definition().subtitle(event.getLocation().toString()).with(SoundDefinition.Sound.sound((ResourceLocation)sound, (SoundDefinition.SoundType)SoundDefinition.SoundType.SOUND)));
    }

    private void add(SoundEvent event, ResourceLocation sound, int num, boolean underscore) {
        SoundDefinition def = SoundGen.definition().subtitle(event.getLocation().toString());
        for (int i = 0; i < num; ++i) {
            def.with(SoundDefinition.Sound.sound((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)sound.getNamespace(), (String)(sound.getPath() + (underscore ? "_" : "") + (i + 1))), (SoundDefinition.SoundType)SoundDefinition.SoundType.SOUND));
        }
        this.add(event, def);
    }

    private static ResourceLocation fromEvent(ResourceLocation res) {
        return ResourceLocation.fromNamespaceAndPath((String)res.getNamespace(), (String)res.getPath().replace(".", "/"));
    }
}

