/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.api.datapack;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.fateubw.api.datapack.ServantExtraData;
import io.github.flemmli97.fateubw.common.lib.BuiltinServantClasses;
import io.github.flemmli97.fateubw.common.registry.FateAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1320;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public record ServantProperties(Map<class_6880<class_1320>, Double> attributes, int manaCost, int weight, class_2960 servantClass, Optional<ServantExtraData> extraData) {
    public static final Codec<ServantProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_7923.field_41190.method_40294(), (Codec)Codec.DOUBLE).fieldOf("attributes").forGetter(d -> d.attributes), (App)Codec.INT.fieldOf("nobel_phantasm_cost").forGetter(ServantProperties::manaCost), (App)Codec.INT.fieldOf("weight").forGetter(ServantProperties::weight), (App)class_2960.field_25139.fieldOf("class").forGetter(ServantProperties::servantClass), (App)ServantExtraData.CODEC.optionalFieldOf("configs").forGetter(d -> d.extraData.flatMap(ex -> ex.empty() ? Optional.empty() : Optional.of(ex)))).apply((Applicative)instance, ServantProperties::new));
    public static final ServantProperties DEFAULT = new Builder(BuiltinServantClasses.NONE).putAttributes((class_6880<class_1320>)class_5134.field_23716, 20.0).putAttributes((class_6880<class_1320>)class_5134.field_23721, 1.0).putAttributes((class_6880<class_1320>)class_5134.field_23719, 0.2).putAttributes((class_6880<class_1320>)FateAttributes.MAGIC_ATTACK.asHolder(), 1.0).build();

    public ServantProperties(Map<class_6880<class_1320>, Double> attributes, int manaCost, int weight, class_2960 servantClass, Optional<ServantExtraData> extraData) {
        this.attributes = ImmutableMap.copyOf(attributes);
        this.manaCost = manaCost;
        this.weight = weight;
        this.servantClass = servantClass;
        this.extraData = extraData;
    }

    public <T> T getConfig(ServantExtraData.DataType<T> type) {
        return (T)this.extraData.map(d -> d.get(type)).orElse(type.defaultValue());
    }

    public static class Builder {
        private final Map<class_6880<class_1320>, Double> attributes = new HashMap<class_6880<class_1320>, Double>();
        private int manaCost;
        private int weight = 1;
        private final class_2960 servantClass;
        private final Map<ServantExtraData.DataType<?>, Object> values = new HashMap();

        public Builder(class_2960 servantClass) {
            this.servantClass = servantClass;
        }

        public Builder putAttributes(class_6880<class_1320> att, double val) {
            this.attributes.put(att, val);
            return this;
        }

        public Builder npCost(int manaCost) {
            this.manaCost = manaCost;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public <T> Builder withConfigData(ServantExtraData.DataType<T> type) {
            return this.withConfigData(type, type.defaultValue());
        }

        public <T> Builder withConfigData(ServantExtraData.DataType<T> type, T value) {
            this.values.put(type, value);
            return this;
        }

        public ServantProperties build() {
            return new ServantProperties(this.attributes, this.manaCost, this.weight, this.servantClass, this.values.isEmpty() ? Optional.empty() : Optional.of(new ServantExtraData(this.values)));
        }
    }
}

