/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.gui;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.api.entity.ServantLike;
import io.github.flemmli97.fateubw.common.attachment.PlayerData;
import io.github.flemmli97.fateubw.common.network.C2SMessageGui;
import io.github.flemmli97.fateubw.common.network.C2SServantCommand;
import io.github.flemmli97.fateubw.common.network.C2SServantSpecial;
import io.github.flemmli97.fateubw.common.network.S2CServantGui;
import io.github.flemmli97.fateubw.platform.Platform;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class CommandGui
extends class_437 {
    private static final class_2960 GUI_BACK_GROUND = Fate.modRes("textures/gui/command_gui.png");
    private static final class_2960 SEAL_1 = Fate.modRes("icon/command_seal_1");
    private static final class_2960 SEAL_2 = Fate.modRes("icon/command_seal_2");
    private static final class_2960 SEAL_3 = Fate.modRes("icon/command_seal_3");
    private static final class_2960 SEAL_4 = Fate.modRes("icon/command_seal_4");
    private final Map<String, class_2561> translationCache = new HashMap<String, class_2561>();
    private final int sizeX = 222;
    private final int sizeY = 200;
    private int leftPos;
    private int topPos;
    private Pages currentPage = Pages.MENU;
    private final Random rand = new Random();
    private final int command1;
    private final int command2;
    private final int command3;
    private final ServantLike<?> servant;
    private S2CServantGui.ServantMetaData data;

    public CommandGui(S2CServantGui.ServantMetaData data) {
        super((class_2561)class_2561.method_43471((String)"fateubw.gui.command"));
        this.servant = this.createFrom(data);
        this.rand.setSeed(class_310.method_1551().field_1724.method_5667().getLeastSignificantBits());
        this.command1 = this.rand.nextInt(3);
        this.command2 = this.rand.nextInt(3);
        this.command3 = this.rand.nextInt(3);
        this.update(data);
    }

    private class_2561 getComponent(String key, Consumer<class_5250> otherwise) {
        class_2561 cache = this.translationCache.get(key);
        if (cache == null) {
            class_5250 comp = class_2561.method_43471((String)key).method_27695(new class_124[0]);
            otherwise.accept(comp);
            cache = comp;
            this.translationCache.put(key, (class_2561)comp);
        }
        return cache;
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        this.leftPos = this.field_22789 / 2 - this.sizeX / 2;
        this.topPos = this.field_22790 / 2 - this.sizeY / 2;
        int buttonPos = this.leftPos + this.sizeX - 80 - 16;
        int buttonY = this.topPos + 16;
        if (this.currentPage == Pages.MENU) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.command.attack"), b -> {
                this.currentPage = Pages.ATTACK;
                this.method_25426();
            }).method_46434(buttonPos, buttonY, 80, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.command.movement"), b -> {
                this.currentPage = Pages.MOVEMENT;
                this.method_25426();
            }).method_46434(buttonPos, buttonY += 30, 80, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.team"), b -> {
                LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SMessageGui(C2SMessageGui.Type.TEAM));
                this.method_25419();
            }).method_46434(buttonPos, buttonY += 30, 80, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.command.kill"), b -> {
                LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SServantCommand(C2SServantCommand.ActionType.KILL, this.entityId()));
                LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SMessageGui(C2SMessageGui.Type.SERVANT));
            }).method_46434(buttonPos, buttonY += 30, 80, 20).method_46431());
            if (this.servant != null && this.servant.specialCommands() != null) {
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.command.special"), b -> {
                    this.currentPage = Pages.SPECIAL;
                    this.method_25426();
                }).method_46434(buttonPos, buttonY + 30, 80, 20).method_46431());
            }
        } else if (this.currentPage == Pages.ATTACK) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.back"), this::backButton).method_46434(buttonPos, buttonY, 80, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.command.aggressive"), b -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SServantCommand(C2SServantCommand.ActionType.AGGRESSIVE, this.entityId()))).method_46434(buttonPos, buttonY += 30, 80, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.command.normal"), b -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SServantCommand(C2SServantCommand.ActionType.NORMAL, this.entityId()))).method_46434(buttonPos, buttonY += 30, 80, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.command.defensive"), b -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SServantCommand(C2SServantCommand.ActionType.DEFENSIVE, this.entityId()))).method_46434(buttonPos, buttonY + 30, 80, 20).method_46431());
        } else if (this.currentPage == Pages.MOVEMENT) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.back"), this::backButton).method_46434(buttonPos, buttonY, 80, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.command.follow"), b -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SServantCommand(C2SServantCommand.ActionType.FOLLOW, this.entityId()))).method_46434(buttonPos, buttonY += 30, 80, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.command.stay"), b -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SServantCommand(C2SServantCommand.ActionType.STAY, this.entityId()))).method_46434(buttonPos, buttonY += 30, 80, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.command.protect"), b -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SServantCommand(C2SServantCommand.ActionType.GUARD, this.entityId()))).method_46434(buttonPos, buttonY += 30, 80, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.command.call"), b -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SServantCommand(C2SServantCommand.ActionType.TELEPORT, this.entityId()))).method_46434(buttonPos, buttonY + 30, 80, 20).method_46431());
        } else if (this.currentPage == Pages.SPECIAL) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"fateubw.gui.back"), this::backButton).method_46434(buttonPos, buttonY, 80, 20).method_46431());
            if (this.servant != null) {
                for (int i = 0; i < this.servant.specialCommands().length; ++i) {
                    String id = this.servant.specialCommands()[i];
                    this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)id), b -> LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SServantSpecial(id, this.entityId()))).method_46434(buttonPos, buttonY += 30, 80, 20).method_46431());
                }
            }
        }
    }

    private void backButton(class_4185 button) {
        this.currentPage = Pages.MENU;
        this.method_25426();
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_746 player = this.field_22787.field_1724;
        PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
        if (data == null) {
            return;
        }
        graphics.method_25302(GUI_BACK_GROUND, this.leftPos, this.topPos, 0, 0, this.sizeX, this.sizeY);
        this.drawCommand(graphics, data.getCommandSeals());
        int textX = this.leftPos + 11;
        int textMiddle = this.leftPos + 3 + 54;
        int textY = this.topPos + 116;
        if (this.servant != null) {
            List name = this.field_22793.method_1728((class_5348)this.servant.get().method_5477(), 101);
            for (class_5481 seq : name) {
                this.drawCenteredString(graphics, this.field_22793, seq, textMiddle, textY, 1);
                textY += 12;
            }
            graphics.method_51439(this.field_22793, this.getComponent("fateubw.gui.nobel_phantasm", c -> c.method_27692(class_124.field_1079)), textX, textY += 5, 1, false);
            graphics.method_51439(this.field_22793, this.servant.nobelPhantasm(), textX, textY += 12, 1, false);
            graphics.method_51439(this.field_22793, this.getComponent("fateubw.gui.nobel_phantasm_cost", c -> c.method_27692(class_124.field_1079)), textX, textY += 12, 1, false);
            graphics.method_51433(this.field_22793, "" + this.data.npCost(), textX, textY + 12, 1, false);
            RenderUtils.renderScaledEntityGui((class_332)graphics, (float)(this.leftPos + 26), (float)(this.topPos + 20), (float)61.0f, (float)87.0f, (float)29.0f, (float)0.0625f, (float)mouseX, (float)mouseY, this.servant.get());
        } else {
            this.drawCenteredString(graphics, this.field_22793, this.getComponent("fateubw.gui.no_servant", c -> c.method_27692(class_124.field_1079)), textMiddle, textY, 1);
        }
    }

    private void drawCenteredString(class_332 graphics, class_327 font, class_2561 text, int x, int y, int color) {
        this.drawCenteredString(graphics, font, text.method_30937(), x, y, 1);
    }

    private void drawCenteredString(class_332 graphics, class_327 font, class_5481 text, int x, int y, int color) {
        graphics.method_51430(font, text, x - font.method_30880(text) / 2, y, color, false);
    }

    private void drawCommand(class_332 graphics, int amount) {
        int[] command = new int[]{this.command1, this.command2, this.command3};
        int posX = this.leftPos + this.sizeX + 2;
        int posY = this.topPos + 2;
        block6: for (int i = 0; i < amount; ++i) {
            switch (command[i]) {
                case 0: {
                    graphics.method_52706(SEAL_1, posX, posY + 35 * i, 32, 32);
                    continue block6;
                }
                case 1: {
                    graphics.method_52706(SEAL_2, posX, posY + 35 * i, 32, 32);
                    continue block6;
                }
                case 2: {
                    graphics.method_52706(SEAL_3, posX, posY + 35 * i, 32, 32);
                    continue block6;
                }
                case 3: {
                    graphics.method_52706(SEAL_4, posX, posY + 35 * i, 32, 32);
                }
            }
        }
    }

    public void method_25432() {
        super.method_25432();
        LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SServantCommand(C2SServantCommand.ActionType.CLOSE, this.entityId()));
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void update(S2CServantGui.ServantMetaData data) {
        this.data = data;
        if (this.servant != null && data != null) {
            data.equipment().ifPresent(list -> list.forEach(p -> this.servant.get().method_5673((class_1304)p.getFirst(), (class_1799)p.getSecond())));
            if (data.syncedData() != null) {
                this.servant.get().method_5841().method_12779(data.syncedData());
            }
        }
    }

    private ServantLike<?> createFrom(S2CServantGui.ServantMetaData data) {
        if (data == null) {
            return null;
        }
        class_1297 fromId = class_310.method_1551().field_1687.method_8469(data.entityId());
        if (fromId instanceof ServantLike) {
            ServantLike s = (ServantLike)fromId;
            return s;
        }
        class_1297 created = data.type().method_5883((class_1937)class_310.method_1551().field_1687);
        if (created instanceof ServantLike) {
            ServantLike s = (ServantLike)created;
            return s;
        }
        return null;
    }

    private int entityId() {
        return this.data != null ? this.data.entityId() : 0;
    }

    private static enum Pages {
        MENU,
        MOVEMENT,
        ATTACK,
        SPECIAL;

    }
}

