/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.model;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.client.ClientHandler;
import io.github.flemmli97.fateubw.common.entity.summons.GordiusWheel;
import io.github.flemmli97.fateubw.common.entity.utils.MoveType;
import io.github.flemmli97.tenshilib.client.data.GeoAnimationManager;
import io.github.flemmli97.tenshilib.client.data.GeoModelManager;
import io.github.flemmli97.tenshilib.client.data.ReloadableCache;
import io.github.flemmli97.tenshilib.client.model.BedrockAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_583;
import net.minecraft.class_897;

public class GordiusWheelModel
extends class_583<GordiusWheel>
implements ExtendedModel,
RideableModel<GordiusWheel> {
    public static final class_2960 LOCATION = Fate.modRes("gordius_wheel");
    protected final ReloadableCache<ModelPartsContainer> model = GeoModelManager.getInstance().getModel(LOCATION, model -> {
        this.bull1 = model.getPart("bull1");
        this.bull2 = model.getPart("bull2");
        this.centerBeam = model.getPart("centerBeam");
        this.backBeam = model.getPart("backBeam");
        this.ridingPosition = model.getPart("mountPos");
    });
    protected final ReloadableCache<BedrockAnimations> anim = GeoAnimationManager.getInstance().getAnimation(LOCATION);
    public ModelPartsContainer.ModelPartExtended bull1;
    public ModelPartsContainer.ModelPartExtended bull2;
    public ModelPartsContainer.ModelPartExtended centerBeam;
    public ModelPartsContainer.ModelPartExtended backBeam;
    public ModelPartsContainer.ModelPartExtended ridingPosition;

    public void method_2828(class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, int color) {
        this.getModel().getRoot().render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(GordiusWheel entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.getModel().resetPoses();
        float partialTicks = ClientHandler.getPartialTicks();
        if (entity.field_6213 <= 0) {
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "idle", entity.field_6012, partialTicks);
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "move", entity.field_6012, partialTicks, entity.interpolatedMoveTick(partialTicks));
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "run", entity.field_6012, partialTicks, entity.interpolatedMoveTickOf(MoveType.RUN, partialTicks));
            if (entity.getMoveType() != MoveType.NONE) {
                entity.wheelPartial = partialTicks;
            }
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "wheel_move", entity.wheelMoveTick, entity.wheelPartial, 1.0f);
        }
        ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, entity.getAnimationHandler(), partialTicks);
        if (entity.getWheelEntity() != null) {
            float yRot = GordiusWheelModel.lerpClamped(partialTicks, entity.getWheelEntity().field_5982, entity.getWheelEntity().method_36454());
            float pYRot = GordiusWheelModel.lerpClamped(partialTicks, entity.field_5982, entity.method_36454());
            this.backBeam.yRot -= pYRot * ((float)Math.PI / 180);
            this.backBeam.yRot += yRot * ((float)Math.PI / 180);
            float xRot = class_3532.method_16439((float)partialTicks, (float)entity.getWheelEntity().field_6004, (float)entity.getWheelEntity().method_36455());
            float chariotX = class_3532.method_15363((float)xRot, (float)-15.0f, (float)15.0f);
            this.centerBeam.xRot += chariotX * ((float)Math.PI / 180);
            chariotX = class_3532.method_15363((float)(xRot - chariotX), (float)-40.0f, (float)40.0f);
            this.backBeam.xRot += chariotX * ((float)Math.PI / 180);
        }
    }

    private static float lerpClamped(float partialTicks, float start, float end) {
        while (start < 0.0f) {
            start += 360.0f;
        }
        while (end < 0.0f) {
            end += 360.0f;
        }
        float diff1 = (end %= 360.0f) - (start %= 360.0f);
        float diff2 = Math.min(start, end) + 360.0f - Math.max(start, end);
        if (Math.abs(diff2) > Math.abs(diff1)) {
            return start + partialTicks * diff1;
        }
        return start + partialTicks * diff2;
    }

    public ModelPartsContainer getModel() {
        return (ModelPartsContainer)this.model.get();
    }

    public boolean transform(GordiusWheel entity, class_897<GordiusWheel> entityRenderer, class_1297 rider, class_897<?> ridingEntityRenderer, class_4587 stack, int riderNum) {
        this.ridingPosition.translateAndRotateWithParents(stack);
        GordiusWheelModel.translateRider(stack, (class_1309)entity, rider);
        return true;
    }

    public static void translateRider(class_4587 poseStack, class_1309 entity, class_1297 rider) {
        class_243 attach = rider.method_55668((class_1297)entity);
        float scale = entity.method_55693();
        poseStack.method_22905(1.0f / scale, 1.0f / scale, 1.0f / scale);
        poseStack.method_22904(attach.method_10216(), 0.0, attach.method_10215());
    }
}

