/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.particles;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.TrailPositions;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class TrailRenderer {
    public static void render(class_1297 entity, TrailInfo info, TrailPositions positions, class_4588 consumer, float partialTicks) {
        class_4587 stack = new class_4587();
        class_243 vec3 = class_310.method_1551().method_1561().field_4686.method_19326();
        double lerpX = class_3532.method_16436((double)partialTicks, (double)entity.field_6014, (double)entity.method_23317());
        double lerpY = class_3532.method_16436((double)partialTicks, (double)entity.field_6036, (double)entity.method_23318());
        double lerpZ = class_3532.method_16436((double)partialTicks, (double)entity.field_5969, (double)entity.method_23321());
        double dx = lerpX - vec3.method_10216();
        double dy = lerpY - vec3.method_10214();
        double dz = lerpZ - vec3.method_10215();
        stack.method_22904(dx, dy, dz);
        TrailRenderer.render(info, positions, stack, consumer, class_310.method_1551().method_1561().field_4686, (float)lerpX, (float)lerpY, (float)lerpZ, (float)entity.method_23317(), (float)entity.method_23318(), (float)entity.method_23321(), 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public static void render(TrailInfo info, TrailPositions position, class_4587 stack, class_4588 buffer, class_4184 camera, float partialX, float partialY, float partialZ, float x, float y, float z, float u0, float u1, float v0, float v1) {
        if (position == null || position.size() < 2) {
            return;
        }
        Matrix4f mat = stack.method_23760().method_23761();
        ArrayList<Pair> positions = new ArrayList<Pair>();
        for (int i = 0; i < position.size() - 1; ++i) {
            TrailPositions.TrailPosition next2;
            TrailPositions.TrailPosition next;
            TrailPositions.TrailPosition pos = position.getAt(i);
            if (pos == null) continue;
            TrailPositions.TrailPosition previous = position.getAt(i - 1);
            if (previous == null) {
                previous = pos;
            }
            if ((next = position.getAt(i + 1)) == null) {
                next = pos;
            }
            if ((next2 = position.getAt(i + 2)) == null) {
                next2 = next;
            }
            float step = 1.0f / (float)Math.max(1, info.interpolation());
            for (float j = 0.0f; j < 1.0f; j += step) {
                Vector3f prevPos;
                Vector3f stepPos = TrailRenderer.catmullRom(j, previous.pos(), pos.pos(), next.pos(), next2.pos()).sub(partialX, partialY, partialZ);
                if (stepPos == null) continue;
                Vector3f stepNormal = TrailRenderer.catmullRom(j, previous.normal(), pos.normal(), next.normal(), next2.normal());
                Vector3f previousNormal = null;
                if (!positions.isEmpty()) {
                    prevPos = (Vector3f)((Pair)positions.getLast()).getFirst();
                    previousNormal = (Vector3f)((Pair)positions.getLast()).getSecond();
                } else {
                    prevPos = i == 0 ? next.pos().method_46409().sub(partialX, partialY, partialZ) : previous.pos().method_46409().sub(partialX, partialY, partialZ);
                }
                Vector3f normal = TrailRenderer.calculateNormal(i == 0 ? stepPos : prevPos, i == 0 ? prevPos : stepPos, stepNormal, previousNormal, camera);
                positions.add(Pair.of((Object)stepPos, (Object)normal));
            }
        }
        TrailPositions.TrailPosition current = position.getLast();
        if (current != null) {
            Vector3f currentPos = current.pos().method_46409().sub(x, y, z);
            Pair last = (Pair)positions.getLast();
            positions.add(Pair.of((Object)currentPos, (Object)TrailRenderer.calculateNormal((Vector3f)last.getFirst(), currentPos, current.normal() != null ? current.normal().method_46409() : null, (Vector3f)last.getSecond(), camera)));
        }
        int size = position.getLength() * info.interpolation();
        int diff = Math.abs(size - (positions.size() - 1));
        for (int i = 0; i < positions.size() - 1; ++i) {
            Vector4f[] vertices;
            Pair pos = (Pair)positions.get(i);
            Pair next = (Pair)positions.get(i + 1);
            float prog = class_3532.method_15363((float)((float)(i + diff) / (float)size), (float)0.0f, (float)1.0f);
            float progNext = class_3532.method_15363((float)((float)(i + diff + 1) / (float)size), (float)0.0f, (float)1.0f);
            for (Vector4f vert : vertices = TrailRenderer.vertices(info, (Vector3f)pos.getFirst(), (Vector3f)next.getFirst(), (Vector3f)pos.getSecond(), (Vector3f)next.getSecond(), prog, progNext)) {
                vert.mul((Matrix4fc)mat);
            }
            float ulen = u1 - u0;
            float u0p = class_3532.method_15363((float)(u0 + prog * ulen), (float)u0, (float)u1);
            float u1p = class_3532.method_15363((float)(u0 + progNext * ulen), (float)u0, (float)u1);
            float r = class_3532.method_16439((float)prog, (float)info.r2(), (float)info.r());
            float g = class_3532.method_16439((float)prog, (float)info.g2(), (float)info.g());
            float b = class_3532.method_16439((float)prog, (float)info.b2(), (float)info.b());
            float a = class_3532.method_16439((float)prog, (float)info.a2(), (float)info.a());
            float r2 = class_3532.method_16439((float)progNext, (float)info.r2(), (float)info.r());
            float g2 = class_3532.method_16439((float)progNext, (float)info.g2(), (float)info.g());
            float b2 = class_3532.method_16439((float)progNext, (float)info.b2(), (float)info.b());
            float a2 = class_3532.method_16439((float)progNext, (float)info.a2(), (float)info.a());
            TrailRenderer.draw(buffer, vertices, u0p, u1p, v0, v1, r, g, b, a, r2, g2, b2, a2);
        }
    }

    protected static Vector3f catmullRom(float delta, @Nullable class_243 p1, @Nullable class_243 p2, @Nullable class_243 p3, @Nullable class_243 p4) {
        if (delta == 0.0f) {
            return p2 != null ? p2.method_46409() : null;
        }
        if (delta == 1.0f) {
            return p3 != null ? p3.method_46409() : null;
        }
        if (p1 == null || p2 == null || p3 == null || p4 == null) {
            return null;
        }
        if (p2.equals((Object)p3)) {
            return p2.method_46409();
        }
        return new Vector3f(class_3532.method_41303((float)delta, (float)((float)p1.method_10216()), (float)((float)p2.method_10216()), (float)((float)p3.method_10216()), (float)((float)p4.method_10216())), class_3532.method_41303((float)delta, (float)((float)p1.method_10214()), (float)((float)p2.method_10214()), (float)((float)p3.method_10214()), (float)((float)p4.method_10214())), class_3532.method_41303((float)delta, (float)((float)p1.method_10215()), (float)((float)p2.method_10215()), (float)((float)p3.method_10215()), (float)((float)p4.method_10215())));
    }

    protected static Vector3f calculateNormal(Vector3f from, Vector3f to, @Nullable Vector3f normal, @Nullable Vector3f previousNormal, class_4184 camera) {
        if (normal != null) {
            return normal.normalize();
        }
        if (from.equals((Object)to)) {
            return previousNormal != null ? previousNormal : new Vector3f(0.0f, 1.0f, 0.0f);
        }
        Vector3f target = to.add((Vector3fc)from, new Vector3f());
        return target.cross((Vector3fc)camera.method_19335(), new Vector3f()).normalize();
    }

    protected static Vector4f[] vertices(TrailInfo info, Vector3f current, Vector3f next, Vector3f currentNorm, Vector3f nextNorm, float progPrev, float prog) {
        float scale = class_3532.method_16439((float)progPrev, (float)info.width2(), (float)info.width());
        float scaleNext = class_3532.method_16439((float)prog, (float)info.width2(), (float)info.width());
        Vector4f vert_1 = new Vector4f(current.x() - currentNorm.x() * scale, current.y() - currentNorm.y() * scale, current.z() - currentNorm.z() * scale, 1.0f);
        Vector4f vert_2 = new Vector4f(current.x() + currentNorm.x() * scale, current.y() + currentNorm.y() * scale, current.z() + currentNorm.z() * scale, 1.0f);
        Vector4f vert_3 = new Vector4f(next.x() + nextNorm.x() * scaleNext, next.y() + nextNorm.y() * scaleNext, next.z() + nextNorm.z() * scaleNext, 1.0f);
        Vector4f vert_4 = new Vector4f(next.x() - nextNorm.x() * scaleNext, next.y() - nextNorm.y() * scaleNext, next.z() - nextNorm.z() * scaleNext, 1.0f);
        return new Vector4f[]{vert_1, vert_2, vert_3, vert_4};
    }

    protected static void draw(class_4588 buffer, Vector4f[] vertices, float u0, float u1, float v0, float v1, float r, float g, float b, float a, float r2, float g2, float b2, float a2) {
        for (int i = 0; i < vertices.length; i += 4) {
            buffer.method_22912(vertices[i].x(), vertices[i].y(), vertices[i].z()).method_22913(u0, v1).method_22915(r, g, b, a).method_60803(0xFF00FF);
            buffer.method_22912(vertices[i + 1].x(), vertices[i + 1].y(), vertices[i + 1].z()).method_22913(u0, v0).method_22915(r, g, b, a).method_60803(0xFF00FF);
            buffer.method_22912(vertices[i + 2].x(), vertices[i + 2].y(), vertices[i + 2].z()).method_22913(u1, v0).method_22915(r2, g2, b2, a2).method_60803(0xFF00FF);
            buffer.method_22912(vertices[i + 3].x(), vertices[i + 3].y(), vertices[i + 3].z()).method_22913(u1, v1).method_22915(r2, g2, b2, a2).method_60803(0xFF00FF);
        }
    }
}

