/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.attachment;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.fateubw.api.entity.ServantLike;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.misc.ChainDagger;
import io.github.flemmli97.fateubw.common.network.S2CCommandSeals;
import io.github.flemmli97.fateubw.common.network.S2CMana;
import io.github.flemmli97.fateubw.common.network.S2CPlayerCap;
import io.github.flemmli97.fateubw.common.registry.FateMobEffects;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import net.minecraft.class_8710;

public class PlayerData {
    private final class_1657 player;
    private int currentMana;
    private int commandSeals = 0;
    private int manaRegenCooldown = 100;
    private float manaRegenAccel = 1.0f;
    private Pair<class_1299<?>, class_2487> savedServant;
    private ChainDagger currentDagger;

    public PlayerData(class_1657 player) {
        this.player = player;
    }

    public void setMana(int mana) {
        this.currentMana = Math.min(mana, 100);
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CMana(this), serverPlayer);
        }
    }

    public void addMana(int amount) {
        this.setMana(this.currentMana + amount);
    }

    public int getMana() {
        if (this.player.method_6059(FateMobEffects.RULE_BREAKER.asHolder())) {
            return 0;
        }
        return this.currentMana;
    }

    public boolean useMana(int amount) {
        boolean flag;
        boolean bl = flag = this.getMana() >= amount;
        if (flag) {
            this.currentMana -= amount;
            this.manaRegenAccel = 1.0f;
            this.manaRegenCooldown = 160;
            class_1657 class_16572 = this.player;
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CMana(this), serverPlayer);
            }
        }
        return flag;
    }

    public void tick() {
        if (--this.manaRegenCooldown <= 0 && !this.player.method_6059(FateMobEffects.RULE_BREAKER.asHolder())) {
            this.addMana(1);
            this.manaRegenCooldown = (int)(120.0f / this.manaRegenAccel);
            this.manaRegenAccel = Math.min(this.manaRegenAccel + 0.5f, 10.0f);
        }
    }

    public void saveServant(ServantLike<?> servant) {
        if (servant != null) {
            Object entity = servant.get();
            entity.method_5848();
            entity.method_5772();
            class_2487 nbt = new class_2487();
            entity.method_5647(nbt);
            nbt.method_10551("Pos");
            nbt.method_10551("Motion");
            nbt.method_10551("Rotation");
            nbt.method_10551("UUID");
            this.savedServant = Pair.of((Object)entity.method_5864(), (Object)nbt);
        }
    }

    public void restoreServant(boolean loot) {
        class_1937 class_19372;
        if (this.savedServant != null && (class_19372 = this.player.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (loot) {
                class_5321 lootId = ((class_1299)this.savedServant.getFirst()).method_16351();
                class_52 lootTable = serverLevel.method_8503().method_58576().method_58295(lootId);
                class_47.class_48 builder = this.createLootContext((class_3222)this.player);
                lootTable.method_320(builder.method_309(Optional.empty()), arg_0 -> ((class_1657)this.player).method_5775(arg_0));
                this.savedServant = null;
            } else {
                class_1297 entity = ((class_1299)this.savedServant.getFirst()).method_5883((class_1937)serverLevel);
                if (entity instanceof BaseServant) {
                    BaseServant servant = (BaseServant)entity;
                    servant.method_5943((class_5425)serverLevel, serverLevel.method_8404(servant.method_24515()), class_3730.field_16461, null);
                    entity.method_5651((class_2487)this.savedServant.getSecond());
                    class_243 look = this.player.method_5720();
                    entity.method_5814(this.player.method_23317() + look.field_1352, this.player.method_23318(), this.player.method_23321() + look.field_1350);
                    servant.setOwner(this.player);
                    serverLevel.method_8649(entity);
                    this.savedServant = null;
                }
            }
        }
    }

    private class_47.class_48 createLootContext(class_3222 player) {
        class_1282 source = player.method_48923().method_48802((class_1657)player);
        class_8567 params = new class_8567.class_8568(player.method_51469()).method_51874(class_181.field_1226, (Object)player).method_51874(class_181.field_24424, (Object)player.method_19538()).method_51874(class_181.field_1231, (Object)source).method_51877(class_181.field_1230, (Object)source.method_5529()).method_51877(class_181.field_1227, (Object)source.method_5526()).method_51874(class_181.field_1233, (Object)player).method_51871(player.method_7292()).method_51875(class_173.field_1173);
        return new class_47.class_48(params).method_60568(player.method_59922());
    }

    public int getCommandSeals() {
        return this.commandSeals;
    }

    public boolean useCommandSeal() {
        boolean flag;
        boolean bl = flag = this.commandSeals > 0;
        if (flag) {
            --this.commandSeals;
            class_1657 class_16572 = this.player;
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CCommandSeals(this), serverPlayer);
            }
        }
        return flag;
    }

    public void setCommandSeals(int amount) {
        this.commandSeals = Math.min(amount, 3);
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CCommandSeals(this), serverPlayer);
        }
    }

    public void setThrownDagger(ChainDagger hook) {
        this.currentDagger = hook;
    }

    public ChainDagger getThrownDagger() {
        if (this.currentDagger != null && this.currentDagger.method_5805()) {
            return this.currentDagger;
        }
        return null;
    }

    public class_2487 save(class_2487 compound) {
        compound.method_10569("Mana", this.currentMana);
        compound.method_10569("CommandSeal", this.commandSeals);
        if (this.savedServant != null) {
            compound.method_10582("SavedServantType", class_7923.field_41177.method_10221((Object)((class_1299)this.savedServant.getFirst())).toString());
            compound.method_10566("SavedServant", (class_2520)this.savedServant.getSecond());
        }
        return compound;
    }

    public void load(class_2487 compound) {
        this.currentMana = compound.method_10550("Mana");
        this.commandSeals = compound.method_10550("CommandSeal");
        if (compound.method_10545("SavedServantType")) {
            this.savedServant = Pair.of((Object)((class_1299)class_7923.field_41177.method_10223(class_2960.method_60654((String)compound.method_10558("SavedServantType")))), (Object)compound.method_10562("SavedServant"));
        }
    }

    public void from(PlayerData other) {
        this.currentMana = other.currentMana;
        this.commandSeals = other.commandSeals;
        this.savedServant = other.savedServant;
    }

    public void handleClientUpdatePacket(S2CPlayerCap pkt) {
        this.currentMana = pkt.manaValue;
        this.commandSeals = pkt.commandSeals;
    }
}

