/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.misc;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.entity.misc.BaseProjectile;
import io.github.flemmli97.fateubw.common.entity.utils.OnProjectileHit;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.registry.FateSounds;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedMobDataHandler;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;

public class EnkiduChains
extends BaseProjectile
implements SyncedMobDataHandler {
    protected static final int CHAIN_DURATION = 100;
    protected static final class_2940<Integer> SHOOT_TIME = class_2945.method_12791(EnkiduChains.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Boolean> PREPARING = class_2945.method_12791(EnkiduChains.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Integer> HOOKED_ENTITY = class_2945.method_12791(EnkiduChains.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Float> START_YROT = class_2945.method_12791(EnkiduChains.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> START_XROT = class_2945.method_12791(EnkiduChains.class, (class_2941)class_2943.field_13320);
    public static final TypedResource<class_243> START_POSITION = new TypedResource(Fate.modRes("start_position"));
    private final SyncedDataContainer<EnkiduChains> syncedDataContainer = SyncedDataContainer.builder((class_1297)this).define(START_POSITION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null).build();
    private class_1309 target;
    private class_1297 hookedEntity;
    private class_243 hookedEntityPosition;
    private int preparationTick;
    private int hitTimer;
    public final int renderRand = this.field_5974.method_43048(1000);

    public EnkiduChains(class_1299<? extends EnkiduChains> type, class_1937 level) {
        super(type, level);
    }

    public EnkiduChains(class_1937 level, class_1309 shootingEntity) {
        super((class_1299<? extends BaseProjectile>)((class_1299)FateEntities.ENKIDU_CHAINS.get()), level, shootingEntity);
        this.field_6011.method_12778(SHOOT_TIME, (Object)(this.field_5974.method_43048(15) + 15));
    }

    public EnkiduChains(class_1937 level, class_1309 shooter, class_1309 target) {
        this(level, shooter);
        this.target = target;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(PREPARING, (Object)true);
        builder.method_56912(SHOOT_TIME, (Object)20);
        builder.method_56912(HOOKED_ENTITY, (Object)0);
        builder.method_56912(START_YROT, (Object)Float.valueOf(0.0f));
        builder.method_56912(START_XROT, (Object)Float.valueOf(0.0f));
    }

    public SyncedDataContainer<?> getDataContainer() {
        return this.syncedDataContainer;
    }

    public void method_5674(class_2940<?> key) {
        if (HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.method_5841().method_12789(HOOKED_ENTITY);
            this.hookedEntity = i > 0 ? this.method_37908().method_8469(i) : null;
        }
        super.method_5674(key);
    }

    public boolean preparing() {
        return (Boolean)this.field_6011.method_12789(PREPARING);
    }

    public int livingTickMax() {
        return 80 + (this.hookedEntity != null ? 100 : 0);
    }

    public void method_5773() {
        if (this.method_37908().field_9236) {
            AdvancedParticleContainer.make((class_2394)((class_2394)FateParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.92156863f, 0.92156863f, 0.0f, 1.0f)).addData((AdvancedParticleData)new ScaleData(0.3f)).addData((AdvancedParticleData)new MotionData(this.field_5974.method_43059() * 0.01, this.field_5974.method_43059() * 0.01, this.field_5974.method_43059() * 0.01)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.method_37908(), this.getStartPosition().method_10216(), this.getStartPosition().method_10214() + (double)this.method_17682() * 0.5, this.getStartPosition().method_10215());
        }
        if (this.preparing()) {
            this.updatePreparation();
            return;
        }
        if (!this.method_37908().field_9236) {
            class_1297 thrower = this.method_24921();
            if (thrower == null || !thrower.method_5805()) {
                this.method_31472();
                return;
            }
            if (this.hookedEntity != null) {
                ++this.hitTimer;
                if (!this.hookedEntity.method_5805() || this.hitTimer > 100) {
                    this.method_31472();
                } else {
                    class_1297 class_12972 = this.hookedEntity;
                    if (class_12972 instanceof class_1657) {
                        class_1657 player = (class_1657)class_12972;
                        if (!player.method_31549().field_7480) {
                            player.method_18799(class_243.field_1353);
                            player.method_5859(this.hookedEntityPosition.method_10216(), this.hookedEntityPosition.method_10214(), this.hookedEntityPosition.method_10215());
                            player.field_6037 = true;
                        }
                    } else {
                        this.hookedEntity.method_33574(this.hookedEntityPosition);
                        this.hookedEntity.method_18799(class_243.field_1353);
                    }
                }
            }
            if (this.field_6012 < 4) {
                this.method_5783(class_3417.field_24063, 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 0.8f);
            }
        }
        super.method_5773();
    }

    public void moveEntity() {
        if (this.hookedEntity != null) {
            return;
        }
        super.moveEntity();
    }

    private void updatePreparation() {
        ++this.preparationTick;
        class_243 motion = this.method_18798();
        double f = Math.sqrt(EnkiduChains.horizontalMag((class_243)motion));
        this.method_36456(this.updateRotation(this.field_5982, (float)(class_3532.method_15349((double)motion.field_1352, (double)motion.field_1350) * 57.2957763671875)));
        this.method_36457(this.updateRotation(this.field_6004, (float)(class_3532.method_15349((double)motion.field_1351, (double)f) * 57.2957763671875)));
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        if (!this.method_37908().field_9236) {
            this.field_6011.method_12778(START_YROT, (Object)Float.valueOf(this.method_36454()));
            this.field_6011.method_12778(START_XROT, (Object)Float.valueOf(this.method_36455()));
            this.syncedDataContainer.set(START_POSITION, (Object)this.method_19538());
            if (this.field_6012 == 1) {
                this.method_5783((class_3414)FateSounds.ENTITY_BABYLON_SPAWN.get(), 0.7f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 0.9f);
            }
            if (this.preparing() && this.preparationTick >= (Integer)this.field_6011.method_12789(SHOOT_TIME)) {
                this.field_6011.method_12778(PREPARING, (Object)false);
                class_1297 thrower = this.method_24921();
                if (thrower instanceof class_1657) {
                    class_239 hit = HitResultUtils.entityRayTrace((class_1297)thrower, (double)64.0, (class_3959.class_3960)class_3959.class_3960.field_17558, (class_3959.class_242)class_3959.class_242.field_1348, (boolean)false, (boolean)false, null);
                    this.shootAtPosition(hit.method_17784().field_1352, hit.method_17784().field_1351, hit.method_17784().field_1350, 1.0f, 6.0f);
                } else if (this.target != null) {
                    this.shootAtEntity((class_1297)this.target, 1.0f, 6.0f);
                } else {
                    this.method_31472();
                }
                this.method_5783(class_3417.field_24063, 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 0.8f);
            }
        }
    }

    private float updateRotation(float prev, float current) {
        while (current - prev < -180.0f) {
            prev -= 360.0f;
        }
        while (current - prev >= 180.0f) {
            prev += 360.0f;
        }
        return class_3532.method_16439((float)0.2f, (float)prev, (float)current);
    }

    protected float motionReduction(boolean inWater) {
        return 1.0f;
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(class_3966 result) {
        if (result.method_17782() == this.method_24921()) {
            return false;
        }
        if (this.hookedEntity == null) {
            boolean hurt = false;
            class_1297 class_12972 = this.method_24921();
            if (class_12972 instanceof class_1309) {
                class_1309 entity = (class_1309)class_12972;
                hurt = Utils.runWithInvulTimer((class_1297)entity, result.method_17782(), target -> target.method_5643(this.method_48923().method_48800((class_1297)this, entity), (float)entity.method_45325(class_5134.field_23721) * 0.4f), 2);
            }
            if (!hurt) {
                return false;
            }
            this.moveEntity();
            this.hookedEntity = result.method_17782();
            this.hookedEntityPosition = this.hookedEntity.method_19538();
            this.field_6011.method_12778(HOOKED_ENTITY, (Object)result.method_17782().method_5628());
            class_12972 = this.method_24921();
            if (class_12972 instanceof OnProjectileHit) {
                OnProjectileHit notif = (OnProjectileHit)class_12972;
                notif.onProjectileHit((class_1297)this);
            }
        }
        return true;
    }

    protected void onBlockHit(class_3965 blockRayTraceResult) {
        this.method_31472();
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Preparing", this.preparing());
        class_243 start = this.getStartPosition();
        compound.method_10566("StartPosition", (class_2520)class_243.field_38277.encodeStart((DynamicOps)class_2509.field_11560, (Object)start).getOrThrow());
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(PREPARING, (Object)compound.method_10577("Preparing"));
        this.syncedDataContainer.set(START_POSITION, (Object)class_243.field_38277.parse((DynamicOps)class_2509.field_11560, (Object)compound.method_10580("StartPosition")).result().orElse(this.method_19538()));
    }

    public class_238 method_5830() {
        return super.method_5830().method_18804(this.getStartPosition().method_1020(this.method_19538()));
    }

    public boolean hasHooked() {
        return (Integer)this.field_6011.method_12789(HOOKED_ENTITY) > 0;
    }

    public class_243 getStartPosition() {
        class_243 start = (class_243)this.syncedDataContainer.get(START_POSITION);
        return start == null ? this.method_19538() : start;
    }

    public float getStartY() {
        return ((Float)this.field_6011.method_12789(START_YROT)).floatValue();
    }

    public float getStartX() {
        return ((Float)this.field_6011.method_12789(START_XROT)).floatValue();
    }

    public static void spawnWeaponsAround(class_1309 thrower, class_1309 target, int amount, int range) {
        int targetSize = Math.max(class_3532.method_15386((float)target.method_17682()), class_3532.method_15386((float)target.method_17681()));
        range = Math.max(targetSize + 3, range);
        ArrayList<Pair> angles = new ArrayList<Pair>(amount);
        block0: for (int i = 0; i < amount; ++i) {
            float yRot = thrower.method_59922().method_43057() * 360.0f;
            float xRot = thrower.method_59922().method_43057() * 70.0f + 20.0f;
            int retry = 0;
            do {
                float greatDist = Float.MAX_VALUE;
                for (Pair p : angles) {
                    float d;
                    if (p == null || !((d = EnkiduChains.greatCircDist(yRot, xRot, ((Float)p.getFirst()).floatValue(), ((Float)p.getSecond()).floatValue())) < greatDist)) continue;
                    greatDist = d;
                }
                if (!(greatDist * (float)range > 2.0f)) continue;
                angles.add(Pair.of((Object)Float.valueOf(yRot), (Object)Float.valueOf(xRot)));
                continue block0;
            } while (++retry <= 10);
        }
        class_243 pos = target.method_19538();
        for (Pair offset : angles) {
            if (offset == null) continue;
            EnkiduChains chains = new EnkiduChains(thrower.method_37908(), thrower, target);
            chains.shoot((class_1297)thrower, ((Float)offset.getSecond()).floatValue(), ((Float)offset.getFirst()).floatValue(), 0.0f, 0.02f, 0.0f);
            class_243 area = pos.method_1019(class_243.method_1030((float)(-((Float)offset.getSecond()).floatValue()), (float)((Float)offset.getFirst()).floatValue()).method_1021((double)range));
            chains.method_5814(area.field_1352, area.field_1351, area.field_1350);
            chains.method_37908().method_8649((class_1297)chains);
        }
    }

    private static float greatCircDist(float yRot1, float xRot1, float yRot2, float xRot2) {
        return (float)Math.acos(class_3532.method_15374((float)xRot1) * class_3532.method_15374((float)xRot2) + class_3532.method_15362((float)xRot1) * class_3532.method_15362((float)xRot2) * class_3532.method_15362((float)class_3532.method_15379((float)(yRot1 - yRot2))));
    }
}

